/*
 * Decompiled with CFR 0.152.
 */
package net.azae.xray;

import java.util.Optional;
import net.azae.xray.Xray;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.support.AnnotationSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XrayExtension
implements BeforeEachCallback {
    public static final String XRAY_TEST_ID = "xray test id";
    public static final String UPLOAD_TO_XRAY = "should upload to xray";
    private static final Logger logger = LoggerFactory.getLogger(XrayExtension.class);

    public void beforeEach(ExtensionContext context) {
        logger.debug("beforeEach for: " + context.getDisplayName());
        Optional annotation = AnnotationSupport.findAnnotation((Optional)context.getTestMethod(), Xray.class);
        annotation.ifPresent(testCase -> {
            context.publishReportEntry(XRAY_TEST_ID, testCase.value());
            context.publishReportEntry(UPLOAD_TO_XRAY, String.valueOf(testCase.upload()));
        });
    }
}

