/*
 * Decompiled with CFR 0.152.
 */
package net.azae.xray;

import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.azae.xray.Mapper;
import net.azae.xray.XrayStatus;
import net.azae.xray.XrayTest;
import net.azae.xray.XrayTestSuite;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.reporting.ReportEntry;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XrayListener
implements TestExecutionListener {
    private static final Logger logger = LoggerFactory.getLogger(XrayListener.class);
    private static String baseUrl = "https://xray.cloud.xpand-it.com";
    private XrayTestSuite testSuite;

    public static void publishToXray(HttpClient client, String token, String inputJson) {
        logger.debug("Publish input: " + inputJson);
        HttpRequest request = HttpRequest.newBuilder(URI.create(baseUrl + "/api/v1/import/execution")).header("Content-Type", "application/json").headers("Authorization", "Bearer " + token).POST(HttpRequest.BodyPublishers.ofString(inputJson)).build();
        HttpResponse<String> response = null;
        try {
            response = client.send(request, HttpResponse.BodyHandlers.ofString());
            logger.debug("Publish response: " + response.body());
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static Optional<String> getXrayToken(HttpClient client) {
        String xray_client_secret = XrayListener.getEnv("XRAY_CLIENT_SECRET");
        String xray_client_id = XrayListener.getEnv("XRAY_CLIENT_ID");
        String json = "{ \"client_id\": \"" + xray_client_id + "\", \"client_secret\": \"" + xray_client_secret + "\" }";
        HttpRequest tokenRequest = HttpRequest.newBuilder(URI.create(baseUrl + "/api/v1/authenticate")).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(json)).build();
        HttpResponse<String> tokenResponse = null;
        try {
            tokenResponse = client.send(tokenRequest, HttpResponse.BodyHandlers.ofString());
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
            return Optional.empty();
        }
        return Optional.of(tokenResponse.body().replace("\"", ""));
    }

    private static String getEnv(String env) {
        String variable = System.getenv(env);
        if (variable == null) {
            throw new RuntimeException("Missing " + env + " environment variable");
        }
        return variable;
    }

    static List<String> extractRunningEnvironment(Map<String, String> env) {
        ArrayList<String> runningEnvironment = new ArrayList<String>();
        if (env.keySet().contains("CI")) {
            runningEnvironment.add("gitlab");
        } else if (env.keySet().contains("JENKINS_URL")) {
            runningEnvironment.add("jenkins");
        } else {
            runningEnvironment.add("development");
        }
        return runningEnvironment;
    }

    public void reportingEntryPublished(TestIdentifier testIdentifier, ReportEntry entry) {
        String uniqueId = testIdentifier.getUniqueId();
        XrayTest test = this.getTestSuite(System.getenv()).getTestFromId(uniqueId);
        this.updateXrayTestWithAnnotation(entry, test);
        this.getTestSuite(System.getenv()).putTest(test);
    }

    public void updateXrayTestWithAnnotation(ReportEntry entry, XrayTest test) {
        this.extractXrayTestKey(entry, "xray test id").ifPresent(testKey -> {
            test.setTestKey((String)testKey);
            logger.info("Xray test: " + testKey);
        });
        this.extractXrayTestKey(entry, "should upload to xray").ifPresent(up -> {
            test.setUpload(Boolean.parseBoolean(up));
            logger.info("Xray upload: " + up);
        });
    }

    public Optional<String> extractXrayTestKey(ReportEntry entry, String key) {
        Map map = entry.getKeyValuePairs();
        if (map.containsKey(key)) {
            return Optional.of((String)map.get(key));
        }
        return Optional.empty();
    }

    public void executionFinished(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
        if (!testIdentifier.isTest()) {
            return;
        }
        logger.debug("Execution finished: " + testIdentifier.getDisplayName() + " - " + testExecutionResult.getStatus().toString());
        XrayStatus status = XrayStatus.fromJunitExecution(testExecutionResult.getStatus());
        String uniqueId = testIdentifier.getUniqueId();
        XrayTest test = this.getTestSuite(System.getenv()).getTestFromId(uniqueId);
        test.setStatus(status);
        test.setComment(this.extractComment(testIdentifier, testExecutionResult));
        this.getTestSuite(System.getenv()).putTest(test);
    }

    public String extractComment(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
        if (testExecutionResult.getThrowable().isPresent()) {
            String message = ((Throwable)testExecutionResult.getThrowable().get()).getMessage();
            if (testIdentifier.getParentId().isPresent()) {
                return message + (String)testIdentifier.getParentId().get();
            }
            return message;
        }
        return testIdentifier.getDisplayName();
    }

    public void testPlanExecutionFinished(TestPlan testPlan) {
        logger.info("Uploading results data to Xray...");
        HttpClient client = HttpClient.newBuilder().build();
        this.getTestSuite(System.getenv()).cloneToUpload().ifPresent(suite -> XrayListener.getXrayToken(client).ifPresent(token -> Mapper.ToJsonAsOptional(suite).ifPresent(json -> XrayListener.publishToXray(client, token, json))));
        logger.info("done");
    }

    private XrayTestSuite getTestSuite(Map<String, String> env) {
        if (this.testSuite == null) {
            List<String> runningEnvironment = XrayListener.extractRunningEnvironment(env);
            this.testSuite = XrayTestSuite.withInfos("Automated test", runningEnvironment);
        }
        return this.testSuite;
    }
}

