package net.axay.memoire

import kotlinx.atomicfu.AtomicRef
import kotlinx.atomicfu.atomic
import kotlinx.datetime.Clock
import kotlinx.datetime.Instant

class CacheEntry<T>(val value: T) {
    internal val writeTime: Instant
    internal val accessTime: AtomicRef<Instant>

    init {
        val now = Clock.System.now()
        writeTime = now
        accessTime = atomic(now)
    }
}
