/*
 * Decompiled with CFR 0.152.
 */
package net.axay.memoire;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.datetime.Instant;
import net.axay.memoire.CacheValidationConfig;
import net.axay.memoire.DiskCacheConfig;
import net.axay.memoire.SyncCache;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.FileMetadata;
import okio.FileSystem;
import okio.Okio;
import okio.Path;
import okio.Sink;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\f\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u0002*\u0004\b\u0002\u0010\u00032\u001a\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u0004B'\u0012\u0018\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0005H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0017\u0010\u0017\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0014\u001a\u00020\u0005H\u0016\u00a2\u0006\u0002\u0010\u0018J\u0017\u0010\u0019\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0014\u001a\u00020\u0005H\u0016\u00a2\u0006\u0002\u0010\u0018J\u0017\u0010\u001a\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0005H\u0016\u00a2\u0006\u0002\u0010\u001bJ\u001d\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00028\u0002H\u0016\u00a2\u0006\u0002\u0010\u001eJ\u001f\u0010\u001f\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00028\u0002H\u0016\u00a2\u0006\u0002\u0010 J\u0010\u0010!\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0005H\u0016R#\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000f\u001a\u00020\u0005*\u00028\u00008VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\""}, d2={"Lnet/axay/memoire/DiskCache;", "K", "V", "P", "Lnet/axay/memoire/SyncCache;", "Lokio/Path;", "config", "Lnet/axay/memoire/DiskCacheConfig;", "validationConfig", "Lnet/axay/memoire/CacheValidationConfig;", "(Lnet/axay/memoire/DiskCacheConfig;Lnet/axay/memoire/CacheValidationConfig;)V", "getConfig", "()Lnet/axay/memoire/DiskCacheConfig;", "fileSystem", "Lokio/FileSystem;", "internal", "getInternal", "(Ljava/lang/Object;)Lokio/Path;", "internalContains", "", "key", "internalEvict", "", "internalGet", "(Lokio/Path;)Ljava/lang/Object;", "internalGetAndRemove", "internalIsInvalid", "(Lokio/Path;)Ljava/lang/Boolean;", "internalPut", "value", "(Lokio/Path;Ljava/lang/Object;)V", "internalPutAndGet", "(Lokio/Path;Ljava/lang/Object;)Ljava/lang/Object;", "internalRemove", "memoire-disk"})
public final class DiskCache<K, V, P>
extends SyncCache<K, Path, V, P> {
    @NotNull
    private final DiskCacheConfig<K, V, P> config;
    @NotNull
    private final FileSystem fileSystem;

    public DiskCache(@NotNull DiskCacheConfig<K, V, P> config, @NotNull CacheValidationConfig validationConfig) {
        Intrinsics.checkNotNullParameter(config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)validationConfig, (String)"validationConfig");
        super(validationConfig);
        this.config = config;
        this.fileSystem = this.config.getFileSystem();
        this.fileSystem.createDirectories(this.config.getDirectory());
    }

    @NotNull
    public final DiskCacheConfig<K, V, P> getConfig() {
        return this.config;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public V internalGet(@NotNull Path key) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        try {
            void this_$iv;
            object = this.fileSystem;
            Function1<BufferedSource, V> readerAction$iv = this.config.getDeserializer$memoire_disk();
            boolean bl = false;
            Closeable $this$use$iv$iv = (Closeable)Okio.buffer((Source)this_$iv.source(key));
            boolean $i$f$use = false;
            Object result$iv$iv = null;
            Throwable thrown$iv$iv = null;
            try {
                BufferedSource it$iv = (BufferedSource)$this$use$iv$iv;
                boolean bl2 = false;
                result$iv$iv = readerAction$iv.invoke((Object)it$iv);
            }
            catch (Throwable t$iv$iv) {
                thrown$iv$iv = t$iv$iv;
            }
            try {
                Closeable closeable = $this$use$iv$iv;
                if (closeable != null) {
                    closeable.close();
                }
            }
            catch (Throwable t$iv$iv) {
                if (thrown$iv$iv == null) {
                    thrown$iv$iv = t$iv$iv;
                }
                ExceptionsKt.addSuppressed((Throwable)thrown$iv$iv, (Throwable)t$iv$iv);
            }
            Throwable throwable = thrown$iv$iv;
            if (throwable != null) {
                throw throwable;
            }
            Object object2 = result$iv$iv;
            Intrinsics.checkNotNull((Object)object2);
            object = object2;
        }
        catch (IOException exc) {
            object = null;
        }
        return (V)object;
    }

    public boolean internalContains(@NotNull Path key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.fileSystem.exists(key);
    }

    public void internalPut(@NotNull Path key, P value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        FileSystem this_$iv = this.fileSystem;
        boolean mustCreate$iv = false;
        boolean bl = false;
        Closeable $this$use$iv$iv = (Closeable)Okio.buffer((Sink)this_$iv.sink(key, mustCreate$iv));
        boolean $i$f$use = false;
        Unit result$iv$iv = null;
        Throwable thrown$iv$iv = null;
        try {
            BufferedSink it$iv = (BufferedSink)$this$use$iv$iv;
            boolean bl2 = false;
            BufferedSink $this$internalPut_u24lambda_u2d0 = it$iv;
            boolean bl3 = false;
            this.config.getSerializer$memoire_disk().invoke((Object)$this$internalPut_u24lambda_u2d0, value);
            result$iv$iv = Unit.INSTANCE;
        }
        catch (Throwable t$iv$iv) {
            thrown$iv$iv = t$iv$iv;
        }
        try {
            Closeable closeable = $this$use$iv$iv;
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (Throwable t$iv$iv) {
            if (thrown$iv$iv == null) {
                thrown$iv$iv = t$iv$iv;
            }
            ExceptionsKt.addSuppressed((Throwable)thrown$iv$iv, (Throwable)t$iv$iv);
        }
        Throwable throwable = thrown$iv$iv;
        if (throwable != null) {
            throw throwable;
        }
        Intrinsics.checkNotNull(result$iv$iv);
    }

    @Nullable
    public V internalPutAndGet(@NotNull Path key, P value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.internalPut(key, value);
        return this.internalGet(key);
    }

    public boolean internalRemove(@NotNull Path key) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        try {
            this.fileSystem.delete(key);
            bl = true;
        }
        catch (FileNotFoundException notFound) {
            bl = false;
        }
        return bl;
    }

    @Nullable
    public V internalGetAndRemove(@NotNull Path key) {
        V v;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        V it = v = this.internalGet(key);
        boolean bl = false;
        this.internalRemove(key);
        return v;
    }

    @Nullable
    public Boolean internalIsInvalid(@NotNull Path key) {
        Long l;
        Long l2;
        CacheValidationConfig cacheValidationConfig;
        block10: {
            block9: {
                long p0;
                CacheValidationConfig cacheValidationConfig2;
                Instant.Companion companion;
                Long l3;
                FileMetadata metadata;
                block8: {
                    block7: {
                        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                        if (!this.fileSystem.exists(key)) {
                            return null;
                        }
                        metadata = this.fileSystem.metadata(key);
                        cacheValidationConfig = this.getValidationConfig();
                        l2 = metadata.getLastModifiedAtMillis();
                        if (l2 == null) break block7;
                        l3 = l2;
                        companion = Instant.Companion;
                        long l4 = ((Number)l3).longValue();
                        cacheValidationConfig2 = cacheValidationConfig;
                        boolean bl = false;
                        Instant instant = companion.fromEpochMilliseconds(p0);
                        cacheValidationConfig = cacheValidationConfig2;
                        l2 = instant;
                        if (instant != null) break block8;
                    }
                    return true;
                }
                l = metadata.getLastAccessedAtMillis();
                if (l == null) break block9;
                l3 = l;
                companion = Instant.Companion;
                p0 = ((Number)l3).longValue();
                Long l5 = l2;
                cacheValidationConfig2 = cacheValidationConfig;
                boolean bl = false;
                Instant instant = companion.fromEpochMilliseconds(p0);
                cacheValidationConfig = cacheValidationConfig2;
                l2 = l5;
                Instant instant2 = instant;
                l = instant2;
                if (instant2 != null) break block10;
            }
            return true;
        }
        return !cacheValidationConfig.isValid((Instant)l2, (Instant)l);
    }

    public void internalEvict() {
        Iterable $this$forEach$iv = this.fileSystem.list(this.config.getDirectory());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Path p0 = (Path)element$iv;
            boolean bl = false;
            this.internalRemoveIfInvalid(p0);
        }
    }

    @NotNull
    public Path getInternal(K $this$internal) {
        return this.config.pathFromKey($this$internal);
    }
}

