/*
 * Decompiled with CFR 0.152.
 */
package net.axay.kotlinsmtp.server.utils;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u00072\b\b\u0002\u0010\t\u001a\u00020\u00072\b\b\u0002\u0010\n\u001a\u00020\u0007J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0007J\u000e\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lnet/axay/kotlinsmtp/server/utils/AddressUtils;", "", "()V", "addressRegex", "Lkotlin/text/Regex;", "hostRegex", "extractFromBrackets", "", "string", "openingBracket", "closingBracket", "validateAddress", "", "address", "validateHost", "host", "kotlin-smtp"})
public final class AddressUtils {
    @NotNull
    public static final AddressUtils INSTANCE = new AddressUtils();
    @NotNull
    private static final Regex addressRegex = new Regex("([A-Za-z.0-9]+)(@)([A-Za-z0-9]+\\.)+([A-Za-z]+)");
    @NotNull
    private static final Regex hostRegex = new Regex("(@)([A-Za-z0-9]+\\.)+([A-Za-z]+)");

    private AddressUtils() {
    }

    @Nullable
    public final String extractFromBrackets(@NotNull String string, @NotNull String openingBracket, @NotNull String closingBracket) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        Intrinsics.checkNotNullParameter((Object)openingBracket, (String)"openingBracket");
        Intrinsics.checkNotNullParameter((Object)closingBracket, (String)"closingBracket");
        int fromIndex = StringsKt.indexOf$default((CharSequence)string, (String)openingBracket, (int)0, (boolean)false, (int)6, null);
        int toIndex = StringsKt.indexOf$default((CharSequence)string, (String)closingBracket, (int)0, (boolean)false, (int)6, null);
        if (fromIndex < 0 || toIndex < 0) {
            return null;
        }
        return StringsKt.slice((String)string, (IntRange)RangesKt.until((int)(fromIndex + 1), (int)toIndex));
    }

    public static /* synthetic */ String extractFromBrackets$default(AddressUtils addressUtils, String string, String string2, String string3, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = "<";
        }
        if ((n & 4) != 0) {
            string3 = ">";
        }
        return addressUtils.extractFromBrackets(string, string2, string3);
    }

    public final boolean validateAddress(@NotNull String address) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        return addressRegex.matches((CharSequence)address);
    }

    public final boolean validateHost(@NotNull String host) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        return hostRegex.matches((CharSequence)host);
    }
}

