/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.dense.row.mult;

import org.ejml.MatrixDimensionException;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.dense.row.CommonOps_DDRM;

public class MatrixVectorMult_DDRM {
    public static void mult(DMatrix1Row A2, DMatrixD1 B, DMatrixD1 C2) {
        if (B.numRows == 1) {
            if (A2.numCols != B.numCols) {
                throw new MatrixDimensionException("A and B are not compatible");
            }
        } else if (B.numCols == 1) {
            if (A2.numCols != B.numRows) {
                throw new MatrixDimensionException("A and B are not compatible");
            }
        } else {
            throw new MatrixDimensionException("B is not a vector");
        }
        C2.reshape(A2.numRows, 1);
        if (A2.numCols == 0) {
            CommonOps_DDRM.fill(C2, 0.0);
            return;
        }
        int indexA = 0;
        int cIndex = 0;
        double b0 = B.get(0);
        for (int i = 0; i < A2.numRows; ++i) {
            double total = A2.get(indexA++) * b0;
            for (int j = 1; j < A2.numCols; ++j) {
                total += A2.get(indexA++) * B.get(j);
            }
            C2.set(cIndex++, total);
        }
    }

    public static void multAdd(DMatrix1Row A2, DMatrixD1 B, DMatrixD1 C2) {
        if (B.numRows == 1) {
            if (A2.numCols != B.numCols) {
                throw new MatrixDimensionException("A and B are not compatible");
            }
        } else if (B.numCols == 1) {
            if (A2.numCols != B.numRows) {
                throw new MatrixDimensionException("A and B are not compatible");
            }
        } else {
            throw new MatrixDimensionException("B is not a vector");
        }
        if (A2.numRows != C2.getNumElements()) {
            throw new MatrixDimensionException("C is not compatible with A");
        }
        if (A2.numCols == 0) {
            return;
        }
        int indexA = 0;
        int cIndex = 0;
        for (int i = 0; i < A2.numRows; ++i) {
            double total = A2.get(indexA++) * B.get(0);
            for (int j = 1; j < A2.numCols; ++j) {
                total += A2.get(indexA++) * B.get(j);
            }
            C2.plus(cIndex++, total);
        }
    }

    public static void multTransA_small(DMatrix1Row A2, DMatrixD1 B, DMatrixD1 C2) {
        if (B.numRows == 1) {
            if (A2.numRows != B.numCols) {
                throw new MatrixDimensionException("A and B are not compatible");
            }
        } else if (B.numCols == 1) {
            if (A2.numRows != B.numRows) {
                throw new MatrixDimensionException("A and B are not compatible");
            }
        } else {
            throw new MatrixDimensionException("B is not a vector");
        }
        C2.reshape(A2.numCols, 1);
        int cIndex = 0;
        for (int i = 0; i < A2.numCols; ++i) {
            double total = 0.0;
            int indexA = i;
            for (int j = 0; j < A2.numRows; ++j) {
                total += A2.get(indexA) * B.get(j);
                indexA += A2.numCols;
            }
            C2.set(cIndex++, total);
        }
    }

    public static void multTransA_reorder(DMatrix1Row A2, DMatrixD1 B, DMatrixD1 C2) {
        if (B.numRows == 1) {
            if (A2.numRows != B.numCols) {
                throw new MatrixDimensionException("A and B are not compatible");
            }
        } else if (B.numCols == 1) {
            if (A2.numRows != B.numRows) {
                throw new MatrixDimensionException("A and B are not compatible");
            }
        } else {
            throw new MatrixDimensionException("B is not a vector");
        }
        C2.reshape(A2.numCols, 1);
        if (A2.numRows == 0) {
            CommonOps_DDRM.fill(C2, 0.0);
            return;
        }
        double B_val = B.get(0);
        for (int i = 0; i < A2.numCols; ++i) {
            C2.set(i, A2.get(i) * B_val);
        }
        int indexA = A2.numCols;
        for (int i = 1; i < A2.numRows; ++i) {
            B_val = B.get(i);
            for (int j = 0; j < A2.numCols; ++j) {
                C2.plus(j, A2.get(indexA++) * B_val);
            }
        }
    }

    public static void multAddTransA_small(DMatrix1Row A2, DMatrixD1 B, DMatrixD1 C2) {
        if (B.numRows == 1) {
            if (A2.numRows != B.numCols) {
                throw new MatrixDimensionException("A and B are not compatible");
            }
        } else if (B.numCols == 1) {
            if (A2.numRows != B.numRows) {
                throw new MatrixDimensionException("A and B are not compatible");
            }
        } else {
            throw new MatrixDimensionException("B is not a vector");
        }
        if (A2.numCols != C2.getNumElements()) {
            throw new MatrixDimensionException("C is not compatible with A");
        }
        int cIndex = 0;
        for (int i = 0; i < A2.numCols; ++i) {
            double total = 0.0;
            int indexA = i;
            for (int j = 0; j < A2.numRows; ++j) {
                total += A2.get(indexA) * B.get(j);
                indexA += A2.numCols;
            }
            C2.plus(cIndex++, total);
        }
    }

    public static void multAddTransA_reorder(DMatrix1Row A2, DMatrixD1 B, DMatrixD1 C2) {
        if (B.numRows == 1) {
            if (A2.numRows != B.numCols) {
                throw new MatrixDimensionException("A and B are not compatible");
            }
        } else if (B.numCols == 1) {
            if (A2.numRows != B.numRows) {
                throw new MatrixDimensionException("A and B are not compatible");
            }
        } else {
            throw new MatrixDimensionException("B is not a vector");
        }
        if (A2.numCols != C2.getNumElements()) {
            throw new MatrixDimensionException("C is not compatible with A");
        }
        int indexA = 0;
        for (int j = 0; j < A2.numRows; ++j) {
            double B_val = B.get(j);
            for (int i = 0; i < A2.numCols; ++i) {
                C2.plus(i, A2.get(indexA++) * B_val);
            }
        }
    }

    public static double innerProduct(double[] a, int offsetA, DMatrix1Row B, double[] c, int offsetC) {
        if (a.length - offsetA < B.numRows) {
            throw new IllegalArgumentException("Length of 'a' isn't long enough");
        }
        if (c.length - offsetC < B.numCols) {
            throw new IllegalArgumentException("Length of 'c' isn't long enough");
        }
        int cols = B.numCols;
        double output = 0.0;
        for (int k = 0; k < B.numCols; ++k) {
            double sum = 0.0;
            for (int i = 0; i < B.numRows; ++i) {
                sum += a[offsetA + i] * B.data[k + i * cols];
            }
            output += sum * c[offsetC + k];
        }
        return output;
    }
}

