/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.ts.modal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.automatalib.alphabet.Alphabet;
import net.automatalib.alphabet.GrowingMapAlphabet;
import net.automatalib.automaton.AutomatonCreator;
import net.automatalib.common.util.Pair;
import net.automatalib.common.util.fixpoint.WorksetMappingAlgorithm;
import net.automatalib.ts.modal.ModalTransitionSystem;
import net.automatalib.ts.modal.MutableModalTransitionSystem;
import net.automatalib.ts.modal.transition.ModalEdgeProperty;

class ModalParallelComposition<A extends MutableModalTransitionSystem<S, I, ?, ?>, S, S0, S1, I, T0, T1, TP0 extends ModalEdgeProperty, TP1 extends ModalEdgeProperty>
implements WorksetMappingAlgorithm<Pair<S0, S1>, S, A> {
    private static final float LOAD_FACTOR = 0.5f;
    private final ModalTransitionSystem<S0, I, T0, TP0> mts0;
    private final ModalTransitionSystem<S1, I, T1, TP1> mts1;
    private final A result;

    ModalParallelComposition(ModalTransitionSystem<S0, I, T0, TP0> mts0, ModalTransitionSystem<S1, I, T1, TP1> mts1, AutomatonCreator<A, I> output) {
        Alphabet alphabet;
        this.mts0 = mts0;
        this.mts1 = mts1;
        if (mts0.getInputAlphabet().equals(mts1.getInputAlphabet())) {
            alphabet = mts0.getInputAlphabet();
        } else {
            GrowingMapAlphabet growingAlphabet = new GrowingMapAlphabet(mts0.getInputAlphabet());
            growingAlphabet.addAll(mts1.getInputAlphabet());
            alphabet = growingAlphabet;
        }
        this.result = (MutableModalTransitionSystem)output.createAutomaton(alphabet);
    }

    @Override
    public int expectedElementCount() {
        return (int)(0.5f * (float)this.mts0.size() * (float)this.mts1.size());
    }

    @Override
    public Collection<Pair<S0, S1>> initialize(Map<Pair<S0, S1>, S> mapping) {
        ArrayList<Pair<S0, S1>> initialElements = new ArrayList<Pair<S0, S1>>(this.mts0.getInitialStates().size() * this.mts1.getInitialStates().size());
        for (Object s0 : this.mts0.getInitialStates()) {
            for (Object s1 : this.mts1.getInitialStates()) {
                Pair init = Pair.of(s0, s1);
                Object newState = this.result.addInitialState();
                mapping.put(init, newState);
                initialElements.add(init);
            }
        }
        return initialElements;
    }

    @Override
    public Collection<Pair<S0, S1>> update(Map<Pair<S0, S1>, S> mapping, Pair<S0, S1> currentTuple) {
        ArrayList<Pair<S0, S1>> discovered = new ArrayList<Pair<S0, S1>>();
        List<TransitionData<S0, S1, I>> transitions = this.generateNewTransitions(currentTuple);
        for (TransitionData<S0, S1, I> transition : transitions) {
            Object mappedTarget;
            if (mapping.containsKey(((TransitionData)transition).target)) {
                mappedTarget = mapping.get(((TransitionData)transition).target);
            } else {
                mappedTarget = this.result.addState();
                mapping.put(((TransitionData)transition).target, mappedTarget);
                discovered.add(((TransitionData)transition).target);
            }
            this.result.addModalTransition(mapping.get(currentTuple), (Object)((TransitionData)transition).label, mappedTarget, ((TransitionData)transition).property);
        }
        return discovered;
    }

    private List<TransitionData<S0, S1, I>> generateNewTransitions(Pair<S0, S1> productState) {
        ArrayList<TransitionData<S0, S1, I>> newTransitions = new ArrayList<TransitionData<S0, S1, I>>();
        for (Object symbol : this.mts0.getInputAlphabet()) {
            for (Object transition : this.mts0.getTransitions(productState.getFirst(), symbol)) {
                if (!this.mts1.getInputAlphabet().contains(symbol)) {
                    newTransitions.add(new TransitionData(symbol, Pair.of(this.mts0.getSuccessor(transition), productState.getSecond()), ((ModalEdgeProperty)this.mts0.getTransitionProperty(transition)).getModalType()));
                    continue;
                }
                for (Object partnerTransition : this.mts1.getTransitions(productState.getSecond(), symbol)) {
                    newTransitions.add(new TransitionData(symbol, Pair.of(this.mts0.getSuccessor(transition), this.mts1.getSuccessor(partnerTransition)), ModalParallelComposition.minimalCompatibleType(((ModalEdgeProperty)this.mts0.getTransitionProperty(transition)).getModalType(), ((ModalEdgeProperty)this.mts1.getTransitionProperty(partnerTransition)).getModalType())));
                }
            }
        }
        HashSet alphabetDifference = new HashSet(this.mts1.getInputAlphabet());
        alphabetDifference.removeAll(this.mts0.getInputAlphabet());
        for (Object symbol : alphabetDifference) {
            for (Object transition : this.mts1.getTransitions(productState.getSecond(), symbol)) {
                newTransitions.add(new TransitionData(symbol, Pair.of(productState.getFirst(), this.mts1.getSuccessor(transition)), ((ModalEdgeProperty)this.mts1.getTransitionProperty(transition)).getModalType()));
            }
        }
        return newTransitions;
    }

    private static ModalEdgeProperty.ModalType minimalCompatibleType(ModalEdgeProperty.ModalType arg0, ModalEdgeProperty.ModalType arg1) {
        if (arg0 == ModalEdgeProperty.ModalType.MUST && arg1 == ModalEdgeProperty.ModalType.MUST) {
            return ModalEdgeProperty.ModalType.MUST;
        }
        return ModalEdgeProperty.ModalType.MAY;
    }

    @Override
    public A result() {
        return this.result;
    }

    private static class TransitionData<S0, S1, I> {
        private final I label;
        private final Pair<S0, S1> target;
        private final ModalEdgeProperty.ModalType property;

        TransitionData(I label, Pair<S0, S1> target, ModalEdgeProperty.ModalType property) {
            this.label = label;
            this.target = target;
            this.property = property;
        }
    }
}

