/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.ts.acceptor;

import java.util.Collection;
import net.automatalib.common.util.Pair;
import net.automatalib.ts.acceptor.AcceptorTS;
import net.automatalib.util.ts.acceptor.AcceptanceCombiner;
import net.automatalib.util.ts.comp.TSComposition;

final class AcceptorComposition<S1, S2, I, A1 extends AcceptorTS<S1, I>, A2 extends AcceptorTS<S2, I>>
extends TSComposition<S1, S2, I, S1, S2, A1, A2>
implements AcceptorTS<Pair<S1, S2>, I> {
    private final AcceptanceCombiner combiner;

    AcceptorComposition(A1 ts1, A2 ts2, AcceptanceCombiner combiner) {
        super(ts1, ts2);
        this.combiner = combiner;
    }

    @Override
    public boolean isAccepting(Pair<S1, S2> state) {
        S1 s1 = state.getFirst();
        S2 s2 = state.getSecond();
        boolean acc1 = ((AcceptorTS)this.ts1).isAccepting(s1);
        boolean acc2 = ((AcceptorTS)this.ts2).isAccepting(s2);
        return this.combiner.combine(acc1, acc2);
    }

    @Override
    public boolean isAccepting(Collection<? extends Pair<S1, S2>> states) {
        for (Pair<S1, S2> state : states) {
            if (!this.isAccepting(state)) continue;
            return true;
        }
        return false;
    }
}

