/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.automaton.random;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import net.automatalib.automaton.MutableAutomaton;
import net.automatalib.common.util.collection.CollectionsUtil;
import net.automatalib.common.util.random.RandomUtil;
import org.checkerframework.checker.nullness.qual.Nullable;

public class RandomAutomatonGenerator<S, I, T, SP, TP, A extends MutableAutomaton<S, I, T, SP, TP>> {
    protected final Random random;
    protected final List<? extends I> inputs;
    protected final List<? extends SP> spList;
    protected final List<? extends TP> tpList;
    protected final ArrayList<S> states;
    protected final A automaton;

    public RandomAutomatonGenerator(Random random, Collection<? extends I> inputs, Collection<? extends SP> stateProps, Collection<? extends TP> transProps, A automaton) {
        this.random = random;
        this.spList = CollectionsUtil.randomAccessList(stateProps);
        this.tpList = CollectionsUtil.randomAccessList(transProps);
        this.inputs = CollectionsUtil.randomAccessList(inputs);
        this.states = new ArrayList();
        this.automaton = automaton;
    }

    public A getAutomaton() {
        return this.automaton;
    }

    protected @Nullable TP randomTransProperty() {
        return RandomUtil.choose(this.random, this.tpList);
    }

    protected @Nullable S randomState() {
        return RandomUtil.choose(this.random, this.states);
    }

    protected @Nullable S randomDistinctState(int stateIdx) {
        if (this.states.size() == 1) {
            return null;
        }
        int idx = this.random.nextInt(this.states.size() - 1);
        if (idx >= stateIdx) {
            ++idx;
        }
        return this.states.get(idx);
    }

    protected @Nullable I randomInput() {
        return RandomUtil.choose(this.random, this.inputs);
    }

    public void addStates(int numStates) {
        this.states.ensureCapacity(this.states.size() + numStates);
        for (int i = 0; i < numStates; ++i) {
            Object state = this.automaton.addState(this.randomStateProperty());
            this.states.add(state);
        }
    }

    protected @Nullable SP randomStateProperty() {
        return RandomUtil.choose(this.random, this.spList);
    }

    public void chooseInitial() {
        S init = RandomUtil.choose(this.random, this.states);
        if (init != null) {
            this.automaton.setInitial(init, true);
        }
    }

    public void chooseInitials(int num) {
        List<S> inits = RandomUtil.sampleUnique(this.random, this.states, num);
        for (S init : inits) {
            this.automaton.setInitial(init, true);
        }
    }
}

