/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.serialization.taf;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import net.automatalib.alphabet.Alphabet;
import net.automatalib.automaton.transducer.CompactMealy;
import net.automatalib.automaton.transducer.MealyMachine;
import net.automatalib.common.util.IOUtil;
import net.automatalib.serialization.InputModelData;
import net.automatalib.serialization.InputModelSerializationProvider;
import net.automatalib.serialization.taf.parser.PrintStreamDiagnosticListener;
import net.automatalib.serialization.taf.parser.TAFParser;
import net.automatalib.serialization.taf.writer.TAFWriter;

public final class TAFSerializationMealy
implements InputModelSerializationProvider<String, MealyMachine<?, String, ?, ?>, MealyMachine<?, String, ?, String>> {
    private static final TAFSerializationMealy INSTANCE = new TAFSerializationMealy();

    private TAFSerializationMealy() {
    }

    public static TAFSerializationMealy getInstance() {
        return INSTANCE;
    }

    @Override
    public void writeModel(OutputStream os, MealyMachine<?, String, ?, ?> model, Alphabet<String> alphabet) throws IOException {
        try (Writer w = IOUtil.asBufferedNonClosingUTF8Writer(os);){
            TAFWriter.writeMealy(model, alphabet, w);
        }
    }

    @Override
    public InputModelData<String, MealyMachine<?, String, ?, String>> readModel(InputStream is) throws IOException {
        CompactMealy<String, String> automaton = TAFParser.parseMealy(is, PrintStreamDiagnosticListener.getStderrDiagnosticListener());
        return new InputModelData(automaton, automaton.getInputAlphabet());
    }
}

