/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.modelchecker.m3c.solver;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.automatalib.graph.ContextFreeModalProcessSystem;
import net.automatalib.graph.ProceduralModalProcessGraph;
import net.automatalib.modelchecker.m3c.formula.AtomicNode;
import net.automatalib.modelchecker.m3c.formula.DependencyGraph;
import net.automatalib.modelchecker.m3c.formula.DiamondNode;
import net.automatalib.modelchecker.m3c.formula.FormulaNode;
import net.automatalib.modelchecker.m3c.formula.OrNode;
import net.automatalib.modelchecker.m3c.formula.TrueNode;
import net.automatalib.modelchecker.m3c.formula.modalmu.LfpNode;
import net.automatalib.modelchecker.m3c.formula.modalmu.VariableNode;
import net.automatalib.modelchecker.m3c.solver.AbstractDDSolver;
import net.automatalib.modelchecker.m3c.solver.WitnessTree;
import net.automatalib.modelchecker.m3c.solver.WitnessTreeState;
import net.automatalib.ts.modal.transition.ProceduralModalEdgeProperty;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

final class WitnessTreeExtractor<L, AP> {
    private final WitnessTree<L, AP> wTree = new WitnessTree();
    private final Map<L, AbstractDDSolver.WorkUnit<?, ?>> units;
    private final DependencyGraph<L, AP> dg;
    private final BitSet initialContext;

    private WitnessTreeExtractor(Map<L, AbstractDDSolver.WorkUnit<?, ?>> units, DependencyGraph<L, AP> dg, BitSet initialContext) {
        this.units = units;
        this.dg = dg;
        this.initialContext = initialContext;
    }

    static <L, AP> WitnessTree<L, AP> computeWitness(ContextFreeModalProcessSystem<L, AP> cfmps, Map<L, AbstractDDSolver.WorkUnit<?, ?>> workUnits, DependencyGraph<L, AP> dependencyGraph, FormulaNode<L, AP> formula, BitSet initialContext) {
        assert (Objects.equals(dependencyGraph.getAST().toString(), formula.toString()));
        WitnessTreeExtractor<L, AP> extractor = new WitnessTreeExtractor<L, AP>(workUnits, dependencyGraph, initialContext);
        return super.computeWitnessStep(cfmps, dependencyGraph.getAST());
    }

    private WitnessTree<L, AP> computeWitnessStep(ContextFreeModalProcessSystem<L, AP> cfmps, FormulaNode<L, AP> formula) {
        ArrayDeque queue = new ArrayDeque();
        AbstractDDSolver.WorkUnit<?, ?> mainUnit = this.units.get(cfmps.getMainProcess());
        assert (mainUnit != null);
        WitnessTreeState<?, L, ?, AP> init = this.getInitialTreeState(mainUnit, formula);
        queue.add(init);
        while (!queue.isEmpty()) {
            List<WitnessTreeState<?, L, ?, AP>> nextTreeStates;
            WitnessTreeState queueElement = (WitnessTreeState)queue.pop();
            int currentNode = (Integer)this.wTree.addNode(queueElement);
            if (currentNode > 0) {
                this.wTree.connect(queueElement.parentId, currentNode, (Object)queueElement.displayLabel);
            }
            if ((nextTreeStates = this.getNextTreeStates(queueElement)).isEmpty()) {
                this.wTree.computePath(currentNode);
                break;
            }
            queue.addAll(nextTreeStates);
        }
        return this.wTree;
    }

    private List<WitnessTreeState<?, L, ?, AP>> getNextTreeStates(WitnessTreeState<?, L, ?, AP> queueElement) {
        FormulaNode visitedFormula = queueElement.subformula;
        if (visitedFormula instanceof LfpNode) {
            visitedFormula = ((LfpNode)visitedFormula).getChild();
        }
        if (visitedFormula instanceof VariableNode) {
            visitedFormula = this.dg.getFormulaNodes().get(visitedFormula.getVarNumber());
        }
        if (visitedFormula instanceof OrNode) {
            return this.exploreOR((OrNode)visitedFormula, queueElement);
        }
        if (visitedFormula instanceof DiamondNode) {
            return this.exploreDia((DiamondNode)visitedFormula, queueElement);
        }
        if (visitedFormula instanceof TrueNode) {
            return Collections.emptyList();
        }
        if (visitedFormula instanceof AtomicNode) {
            return Collections.emptyList();
        }
        throw new IllegalArgumentException("Cannot handle node" + visitedFormula);
    }

    private <N, E> List<WitnessTreeState<?, L, ?, AP>> exploreOR(OrNode<L, AP> formula, WitnessTreeState<N, L, E, AP> queueElement) {
        FormulaNode leftFormula = formula.getLeftChild();
        FormulaNode rightFormula = formula.getRightChild();
        ArrayList result = new ArrayList();
        if (queueElement.getSatisfiedSubformulae(this.dg, queueElement.state).get(leftFormula.getVarNumber())) {
            result.add(new WitnessTreeState(queueElement.stack, queueElement.unit, queueElement.state, leftFormula, queueElement.context, leftFormula.toString(), null, this.wTree.size() - 1));
        }
        if (queueElement.getSatisfiedSubformulae(this.dg, queueElement.state).get(rightFormula.getVarNumber())) {
            result.add(new WitnessTreeState(queueElement.stack, queueElement.unit, queueElement.state, rightFormula, queueElement.context, rightFormula.toString(), null, this.wTree.size() - 1));
        }
        return result;
    }

    private <N> List<WitnessTreeState<?, L, ?, AP>> exploreDia(DiamondNode<L, AP> formula, WitnessTreeState<N, L, ?, AP> queueElement) {
        if (Objects.equals(queueElement.state, queueElement.pmpg.getFinalNode())) {
            assert (queueElement.stack != null);
            return this.findDiaMoveEndNodeReturn(queueElement);
        }
        if (formula.getAction() == null) {
            return this.findDiaMoveWithEmpty(queueElement, formula);
        }
        return this.findDiaMoveRegularStep(queueElement, formula);
    }

    private <N, E> List<WitnessTreeState<?, L, ?, AP>> findDiaMoveWithEmpty(WitnessTreeState<N, L, E, AP> queueElement, DiamondNode<L, AP> formula) {
        ArrayList result = new ArrayList();
        ProceduralModalProcessGraph pmpg = queueElement.pmpg;
        for (Object edge : pmpg.getOutgoingEdges(queueElement.state)) {
            Object target = pmpg.getTarget(edge);
            Object label = pmpg.getEdgeLabel(edge);
            if (((ProceduralModalEdgeProperty)pmpg.getEdgeProperty(edge)).isInternal()) {
                if (!queueElement.getSatisfiedSubformulae(this.dg, target).get(formula.getChild().getVarNumber())) continue;
                WitnessTreeState toAdd = new WitnessTreeState(queueElement.stack, queueElement.unit, target, formula.getChild(), queueElement.context, Objects.toString(label), label, this.wTree.size() - 1);
                result.add(toAdd);
                continue;
            }
            AbstractDDSolver.WorkUnit<?, ?> unit = this.units.get(label);
            assert (unit != null);
            WitnessTreeState<?, L, ?, AP> toAdd = this.buildProcessNode(queueElement, unit, label, target, formula);
            if (toAdd == null) continue;
            result.add(toAdd);
        }
        return result;
    }

    private <N, E> List<WitnessTreeState<?, L, ?, AP>> findDiaMoveEndNodeReturn(WitnessTreeState<N, L, E, AP> queueElement) {
        assert (queueElement.stack != null);
        WitnessTreeState<?, L, ?, AP> toAdd = this.buildReturnNode(queueElement, queueElement.stack);
        return Collections.singletonList(toAdd);
    }

    private <N, E> List<WitnessTreeState<?, L, ?, AP>> findDiaMoveRegularStep(WitnessTreeState<N, L, E, AP> queueElement, DiamondNode<L, AP> formula) {
        ArrayList result = new ArrayList();
        Object moveLabel = formula.getAction();
        ProceduralModalProcessGraph pmpg = queueElement.pmpg;
        for (Object edge : pmpg.getOutgoingEdges(queueElement.state)) {
            Object target = pmpg.getTarget(edge);
            Object label = pmpg.getEdgeLabel(edge);
            if (((ProceduralModalEdgeProperty)pmpg.getEdgeProperty(edge)).isInternal()) {
                if (!Objects.equals(label, moveLabel) || !queueElement.getSatisfiedSubformulae(this.dg, target).get(formula.getChild().getVarNumber())) continue;
                WitnessTreeState toAdd = new WitnessTreeState(queueElement.stack, queueElement.unit, target, formula.getChild(), queueElement.context, Objects.toString(label), label, this.wTree.size() - 1);
                result.add(toAdd);
                continue;
            }
            AbstractDDSolver.WorkUnit<?, ?> unit = this.units.get(label);
            assert (unit != null);
            WitnessTreeState<?, L, ?, AP> toAdd = this.buildProcessNode(queueElement, unit, label, target, formula);
            if (toAdd == null) continue;
            result.add(toAdd);
        }
        return result;
    }

    private <N1, N2, E1, E2> @Nullable WitnessTreeState<N2, L, E2, AP> buildProcessNode(WitnessTreeState<N1, L, E1, AP> queueElement, AbstractDDSolver.WorkUnit<N2, E2> unit, L label, N1 target, DiamondNode<L, AP> formula) {
        BitSet finalFormulae;
        Object initialNode;
        WitnessTreeState succ = new WitnessTreeState(queueElement.stack, queueElement.unit, target, queueElement.subformula, queueElement.context, Objects.toString(label), null, queueElement.parentId);
        WitnessTreeState<N2, Object, E2, AP> result = new WitnessTreeState<N2, Object, E2, AP>(succ, unit, initialNode = unit.pmpg.getInitialNode(), formula, finalFormulae = queueElement.getSatisfiedSubformulae(this.dg, target), Objects.toString(label), null, this.wTree.size() - 1);
        if (result.getSatisfiedSubformulae(this.dg, result.state).get(formula.getVarNumber())) {
            return result;
        }
        return null;
    }

    private <N1, N2, E1, E2> WitnessTreeState<N2, L, E2, AP> buildReturnNode(WitnessTreeState<N1, L, E1, AP> queueElement, WitnessTreeState<N2, L, E2, AP> prev) {
        return new WitnessTreeState(prev.stack, prev.unit, prev.state, queueElement.subformula, prev.context, "return", null, this.wTree.size() - 1);
    }

    private <N, E> WitnessTreeState<?, L, ?, AP> getInitialTreeState(AbstractDDSolver.WorkUnit<N, E> unit, FormulaNode<L, AP> formula) {
        @NonNull N initialNode = unit.pmpg.getInitialNode();
        return new WitnessTreeState<N, Object, E, AP>(null, unit, initialNode, formula, this.initialContext, "", null, -1);
    }
}

