/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.incremental.mealy.dag;

import net.automatalib.incremental.mealy.dag.StateSignature;

final class State<O> {
    private final StateSignature<O> signature;
    private int numIncoming;

    State(StateSignature<O> signature) {
        this.signature = signature;
    }

    void increaseIncoming() {
        ++this.numIncoming;
    }

    void decreaseIncoming() {
        --this.numIncoming;
    }

    boolean isConfluence() {
        return this.numIncoming > 1;
    }

    State<O> getSuccessor(int idx) {
        return ((State[])this.signature.successors.array)[idx];
    }

    O getOutput(int idx) {
        return (O)this.signature.outputs.array[idx];
    }

    StateSignature<O> getSignature() {
        return this.signature;
    }

    void ensureInputCapacity(int capacity) {
        this.signature.successors.ensureCapacity(capacity);
        this.signature.outputs.ensureCapacity(capacity);
    }
}

