/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.graph.base;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.automatalib.common.smartcollection.ResizingArrayStorage;
import net.automatalib.common.util.collection.CollectionsUtil;
import net.automatalib.graph.MutableGraph;
import net.automatalib.graph.base.CompactEdge;
import net.automatalib.graph.concept.NodeIDs;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class AbstractCompactGraph<E extends CompactEdge<EP>, NP, EP>
implements MutableGraph<Integer, E, NP, EP>,
MutableGraph.IntAbstraction<E, NP, EP>,
NodeIDs<Integer> {
    private final ResizingArrayStorage<List<E>> edges;
    private int size;

    public AbstractCompactGraph() {
        this.edges = new ResizingArrayStorage<List>(List.class);
    }

    public AbstractCompactGraph(int initialCapacity) {
        this.edges = new ResizingArrayStorage<List>(List.class, initialCapacity);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Collection<Integer> getNodes() {
        return CollectionsUtil.intRange(0, this.size);
    }

    @Override
    public NodeIDs<Integer> nodeIDs() {
        return this;
    }

    @Override
    public Collection<E> getOutgoingEdges(Integer node) {
        return this.getOutgoingEdges((int)node);
    }

    @Override
    public Collection<E> getOutgoingEdges(int node) {
        return Collections.unmodifiableCollection(((List[])this.edges.array)[node]);
    }

    @Override
    public Integer getTarget(E edge) {
        return this.getIntTarget(edge);
    }

    @Override
    public int getIntTarget(E edge) {
        return ((CompactEdge)edge).getTarget();
    }

    @Override
    public Integer addNode(@Nullable NP property) {
        return this.addIntNode(property);
    }

    @Override
    public int addIntNode(@Nullable NP property) {
        int n = this.size++;
        this.edges.ensureCapacity(n + 1);
        ((List[])this.edges.array)[n] = new ArrayList();
        this.setNodeProperty(n, property);
        return n;
    }

    @Override
    public void setNodeProperty(Integer node, @Nullable NP property) {
        this.setNodeProperty(node.intValue(), property);
    }

    @Override
    public E connect(Integer source, Integer target, @Nullable EP property) {
        return (E)this.connect((int)source, (int)target, (Object)property);
    }

    @Override
    public E connect(int source, int target, @Nullable EP property) {
        E edge = this.createEdge(source, target, property);
        List edges = ((List[])this.edges.array)[source];
        edges.add(edge);
        return edge;
    }

    protected abstract E createEdge(int var1, int var2, @Nullable EP var3);

    @Override
    public void setEdgeProperty(E edge, EP property) {
        ((CompactEdge)edge).setProperty(property);
    }

    @Override
    public int getNodeId(Integer node) {
        return node;
    }

    @Override
    public Integer getNode(int id) {
        if (id < 0 || id >= this.size) {
            throw new IllegalArgumentException();
        }
        return id;
    }

    @Override
    public NP getNodeProperty(Integer node) {
        return this.getNodeProperty(node.intValue());
    }

    @Override
    public EP getEdgeProperty(E edge) {
        return ((CompactEdge)edge).getProperty();
    }
}

