/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.automaton;

import java.util.function.IntFunction;
import net.automatalib.alphabet.Alphabet;
import net.automatalib.automaton.Automaton;
import net.automatalib.automaton.abstraction.DeterministicAbstractions;
import net.automatalib.automaton.simple.SimpleDeterministicAutomaton;
import net.automatalib.ts.DeterministicTransitionSystem;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface DeterministicAutomaton<S, I, T>
extends Automaton<S, I, T>,
SimpleDeterministicAutomaton<S, I>,
DeterministicTransitionSystem<S, I, T> {
    @Override
    default public FullIntAbstraction<T> fullIntAbstraction(Alphabet<I> alphabet) {
        return this.fullIntAbstraction(alphabet.size(), alphabet);
    }

    @Override
    default public FullIntAbstraction<T> fullIntAbstraction(int numInputs, IntFunction<? extends I> symMapping) {
        return new DeterministicAbstractions.FullIntAbstraction(this.stateIntAbstraction(), numInputs, symMapping);
    }

    default public StateIntAbstraction<I, T> stateIntAbstraction() {
        return new DeterministicAbstractions.StateIntAbstraction(this);
    }

    public static interface FullIntAbstraction<T>
    extends IntAbstraction<T>,
    SimpleDeterministicAutomaton.FullIntAbstraction {
        @Override
        default public int getSuccessor(int state, int input) {
            T trans = this.getTransition(state, input);
            if (trans == null) {
                return -1;
            }
            return this.getIntSuccessor(trans);
        }

        public @Nullable T getTransition(int var1, int var2);
    }

    public static interface StateIntAbstraction<I, T>
    extends IntAbstraction<T>,
    SimpleDeterministicAutomaton.StateIntAbstraction<I> {
        @Override
        default public int getSuccessor(int state, I input) {
            T trans = this.getTransition(state, input);
            if (trans == null) {
                return -1;
            }
            return this.getIntSuccessor(trans);
        }

        public @Nullable T getTransition(int var1, I var2);
    }

    public static interface IntAbstraction<T>
    extends SimpleDeterministicAutomaton.IntAbstraction {
        public int getIntSuccessor(T var1);
    }
}

