/*
 * Decompiled with CFR 0.152.
 */
package info.scce.addlib.serializer;

import info.scce.addlib.dd.DD;
import info.scce.addlib.dd.DDManager;
import info.scce.addlib.dd.DDManagerException;
import info.scce.addlib.serializer.DDProperty;
import info.scce.addlib.traverser.PostorderTraverser;
import info.scce.addlib.util.IOUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Scanner;
import org.checkerframework.checker.nullness.qual.NonNull;

public abstract class DDSerializer<M extends DDManager<D, ?>, D extends DD<M, D>> {
    public String serialize(D f) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        this.serialize(pw, f);
        return sw.toString();
    }

    public void serialize(File file, D f) throws IOException {
        try (PrintWriter pw = IOUtils.getBufferedPrintWriterUTF8(file);){
            this.serialize(pw, f);
        }
    }

    public void serialize(OutputStream out, D f) {
        try (PrintWriter pw = IOUtils.getOutputStreamPrintWriterUTF8(out);){
            this.serialize(pw, f);
        }
    }

    protected void serialize(PrintWriter pw, D f) {
        for (DD g2 : new PostorderTraverser<D>(f)) {
            if (g2.isConstant()) {
                pw.print(g2.ptr() + ";");
                pw.print("constant;");
                pw.print(this.escapeString(this.constantToString(g2)) + ";");
                pw.println();
                continue;
            }
            pw.print(g2.ptr() + ";");
            pw.print("non-constant;");
            pw.print(this.escapeString(g2.readName()) + ";");
            pw.print(((DD)g2.t()).ptr() + ";");
            pw.print(((DD)g2.e()).ptr() + ";");
            pw.print(g2.readPerm() + ";");
            pw.println();
        }
        pw.println(((DD)f).ptr() + ";root;");
        pw.flush();
    }

    public D deserialize(M ddManager, String str, DDProperty ddProperty) {
        try (StringReader sr = new StringReader(str);){
            D d;
            try (Scanner sc = new Scanner(sr);){
                d = this.deserialize(ddManager, sc, ddProperty);
            }
            return d;
        }
    }

    public D deserialize(M ddManager, File file, DDProperty ddProperty) throws FileNotFoundException {
        return this.deserialize(ddManager, file, ddProperty, "UTF-8");
    }

    public D deserialize(M ddManager, File file, DDProperty ddProperty, String charset) throws FileNotFoundException {
        try (Scanner sc = new Scanner(file, charset);){
            D d = this.deserialize(ddManager, sc, ddProperty);
            return d;
        }
    }

    public D deserialize(M ddManager, InputStream in, DDProperty ddProperty) {
        return this.deserialize(ddManager, in, ddProperty, "UTF-8");
    }

    public D deserialize(M ddManager, InputStream in, DDProperty ddProperty, String charset) {
        Scanner sc = new Scanner(in, charset);
        return this.deserialize(ddManager, sc, ddProperty);
    }

    private D deserialize(M ddManager, Scanner sc, DDProperty ddProperty) {
        HashMap<Long, @NonNull Object> cache = new HashMap<Long, Object>();
        DD result = null;
        while (result == null && sc.hasNextLine()) {
            String line = sc.nextLine();
            String[] parts = line.split(";");
            long id = Long.parseLong(parts[0]);
            String type = parts[1];
            if ("root".equals(type)) {
                result = (DD)cache.get(id);
                if (result == null) {
                    throw new IllegalArgumentException("The given input to deserialize has an invalid format!");
                }
                result.ref();
                continue;
            }
            if ("constant".equals(type)) {
                String strValue = this.unescapeString(parts[2]);
                D f = this.parseConstant(ddManager, strValue);
                cache.put(id, f);
                continue;
            }
            if (!"non-constant".equals(type)) continue;
            String varName = this.unescapeString(parts[2]);
            long idThen = Long.parseLong(parts[3]);
            long idElse = Long.parseLong(parts[4]);
            int varIndex = Integer.parseInt(parts[5]);
            DD t = (DD)cache.get(idThen);
            DD e = (DD)cache.get(idElse);
            if (t == null || e == null) {
                throw new IllegalArgumentException("The given input to deserialize has an invalid format!");
            }
            DD f = null;
            switch (ddProperty) {
                case VARINDEX: {
                    f = this.ithVar(ddManager, varIndex, t, e);
                    break;
                }
                case VARNAME: {
                    f = this.namedVar(ddManager, varName, t, e);
                    break;
                }
                case VARNAMEANDVARINDEX: {
                    try {
                        f = this.namedIthVar(ddManager, varName, varIndex, t, e);
                        break;
                    }
                    catch (DDManagerException ex) {
                        for (DD dd : cache.values()) {
                            dd.recursiveDeref();
                        }
                        throw ex;
                    }
                }
                default: {
                    throw new IllegalArgumentException("DDProperty is invalid!");
                }
            }
            cache.put(id, f);
        }
        if (result == null) {
            throw new IllegalArgumentException("Could not parse a XDD with the given input!");
        }
        for (DD f : cache.values()) {
            f.recursiveDeref();
        }
        return (D)result;
    }

    protected String escapeString(String str) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == '\n') {
                sb.append("\\n");
                continue;
            }
            if (c == '\r') {
                sb.append("\\r");
                continue;
            }
            if (c == ';') {
                sb.append("\\c");
                continue;
            }
            if (c == '\\') {
                sb.append("\\b");
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    protected String unescapeString(String str) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == '\\') {
                char c2;
                if ((c2 = str.charAt(++i)) == 'n') {
                    sb.append('\n');
                }
                if (c2 == 'r') {
                    sb.append('\r');
                }
                if (c2 == 'c') {
                    sb.append(';');
                }
                if (c2 != 'b') continue;
                sb.append('\\');
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    protected abstract D parseConstant(M var1, String var2);

    protected abstract String constantToString(D var1);

    protected abstract D ithVar(M var1, int var2, D var3, D var4);

    protected abstract D namedVar(M var1, String var2, D var3, D var4);

    protected abstract D namedIthVar(M var1, String var2, int var3, D var4, D var5);
}

