/*
 * Decompiled with CFR 0.152.
 */
package info.scce.addlib.dd.xdd.ringlikedd.example;

import info.scce.addlib.backend.ADDBackend;
import info.scce.addlib.backend.BackendProvider;
import info.scce.addlib.dd.add.ADD;
import info.scce.addlib.dd.add.ADDManager;
import info.scce.addlib.dd.xdd.XDD;
import info.scce.addlib.dd.xdd.ringlikedd.FieldDDManager;
import java.util.HashMap;
import java.util.Map;

public class ArithmeticDDManager
extends FieldDDManager<Double> {
    public ArithmeticDDManager() {
        this(BackendProvider.getADDBackend());
    }

    public ArithmeticDDManager(ADDBackend backend) {
        super(backend);
    }

    @Override
    protected Double zeroElement() {
        return 0.0;
    }

    @Override
    protected Double oneElement() {
        return 1.0;
    }

    @Override
    protected Double add(Double a, Double b) {
        return a + b;
    }

    @Override
    protected Double addInverse(Double a) {
        return -a.doubleValue();
    }

    @Override
    protected Double mult(Double a, Double b) {
        return a * b;
    }

    @Override
    protected Double multInverse(Double a) {
        return 1.0 / a;
    }

    @Override
    protected Double inf(Double a, Double b) {
        return Math.min(a, b);
    }

    @Override
    protected Double sup(Double a, Double b) {
        return Math.max(a, b);
    }

    @Override
    public Double parseElement(String input) {
        return Double.parseDouble(input);
    }

    public ADD toADD(ADDManager ddManagerTarget, XDD<Double> sourceDD) {
        HashMap<XDD<Double>, ADD> cache = new HashMap<XDD<Double>, ADD>();
        ADD result = this.toADDRecursive(ddManagerTarget, sourceDD, cache);
        cache.remove(sourceDD);
        for (ADD g2 : cache.values()) {
            g2.recursiveDeref();
        }
        return result;
    }

    private ADD toADDRecursive(ADDManager ddManagerTarget, XDD<Double> sourceDD, Map<XDD<Double>, ADD> cache) {
        ADD result = cache.get(sourceDD);
        if (result == null) {
            if (sourceDD.isConstant()) {
                result = ddManagerTarget.constant(sourceDD.v());
            } else {
                String name = sourceDD.readName();
                int idx = ddManagerTarget.varIdx(name);
                ADD t = this.toADDRecursive(ddManagerTarget, (XDD<Double>)sourceDD.t(), cache);
                ADD e = this.toADDRecursive(ddManagerTarget, (XDD<Double>)sourceDD.e(), cache);
                ADD varIdx = ddManagerTarget.ithVar(idx);
                result = varIdx.ite(t, e);
                varIdx.recursiveDeref();
            }
            cache.put(sourceDD, result);
        }
        return result;
    }
}

