/*
 * Decompiled with CFR 0.152.
 */
package info.scce.addlib.dd.xdd.latticedd.example;

import java.util.Objects;
import org.checkerframework.checker.initialization.qual.UnderInitialization;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Interval {
    private double lb;
    private double ub;
    private boolean lbIncluded;
    private boolean ubIncluded;

    public Interval(double lb, boolean lbIncluded, double ub, boolean ubIncluded) {
        this.lb = lb;
        this.ub = ub;
        this.lbIncluded = lbIncluded;
        this.ubIncluded = ubIncluded;
        if (lb == Double.NEGATIVE_INFINITY && this.lbIncluded) {
            throw new IllegalArgumentException("Negative infinity is not a real number");
        }
        if (ub == Double.POSITIVE_INFINITY && this.ubIncluded) {
            throw new IllegalArgumentException("Positive infinity is not a real number");
        }
        if (this.isEmpty()) {
            this.lb = 0.0;
            this.ub = 0.0;
            this.lbIncluded = false;
            this.ubIncluded = false;
        }
    }

    public static Interval empty() {
        return new Interval(0.0, false, 0.0, false);
    }

    public static Interval complete() {
        return new Interval(Double.NEGATIVE_INFINITY, false, Double.POSITIVE_INFINITY, false);
    }

    public static Interval parseInterval(String str) {
        boolean ubIncluded;
        boolean lbIncluded;
        if (str.charAt(0) == '[') {
            lbIncluded = true;
        } else if (str.charAt(0) == '(') {
            lbIncluded = false;
        } else {
            throw new IllegalArgumentException("Malformed interval: " + str);
        }
        if (str.charAt(str.length() - 1) == ']') {
            ubIncluded = true;
        } else if (str.charAt(str.length() - 1) == ')') {
            ubIncluded = false;
        } else {
            throw new IllegalArgumentException("Malformed interval: " + str);
        }
        String[] parts = str.substring(1, str.length() - 1).split(", *");
        double lb = Double.parseDouble(parts[0]);
        double ub = Double.parseDouble(parts[1]);
        return new Interval(lb, lbIncluded, ub, ubIncluded);
    }

    public boolean contains(Interval other) {
        return this.lbSmallerEqThan(other) && this.ubGreaterEqThan(other) || other.equals(Interval.empty());
    }

    public Interval union(Interval other) {
        boolean ubIncluded;
        double ub;
        boolean lbIncluded;
        double lb;
        if (Interval.empty().equals(this)) {
            return other;
        }
        if (Interval.empty().equals(other)) {
            return this;
        }
        if (this.lbSmallerEqThan(other)) {
            lb = this.lb;
            lbIncluded = this.lbIncluded;
        } else {
            lb = other.lb;
            lbIncluded = other.lbIncluded;
        }
        if (this.ubGreaterEqThan(other)) {
            ub = this.ub;
            ubIncluded = this.ubIncluded;
        } else {
            ub = other.ub;
            ubIncluded = other.ubIncluded;
        }
        return new Interval(lb, lbIncluded, ub, ubIncluded);
    }

    public Interval intersect(Interval other) {
        boolean ubIncluded;
        double ub;
        boolean lbIncluded;
        double lb;
        if (Interval.empty().equals(this)) {
            return this;
        }
        if (Interval.empty().equals(other)) {
            return other;
        }
        if (this.lbSmallerEqThan(other)) {
            lb = other.lb;
            lbIncluded = other.lbIncluded;
        } else {
            lb = this.lb;
            lbIncluded = this.lbIncluded;
        }
        if (this.ubGreaterEqThan(other)) {
            ub = other.ub;
            ubIncluded = other.ubIncluded;
        } else {
            ub = this.ub;
            ubIncluded = this.ubIncluded;
        }
        return new Interval(lb, lbIncluded, ub, ubIncluded);
    }

    private boolean ubGreaterEqThan(Interval other) {
        if (this.ubIncluded || !other.ubIncluded) {
            return this.ub >= other.ub;
        }
        return this.ub > other.ub;
    }

    private boolean lbSmallerEqThan(Interval other) {
        if (this.lbIncluded || !other.lbIncluded) {
            return this.lb <= other.lb;
        }
        return this.lb < other.lb;
    }

    private boolean isEmpty(@UnderInitialization Interval this) {
        return this.lb > this.ub || this.lb == this.ub && (!this.lbIncluded || !this.ubIncluded);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Interval interval = (Interval)o;
        return Double.compare(interval.lb, this.lb) == 0 && Double.compare(interval.ub, this.ub) == 0 && this.lbIncluded == interval.lbIncluded && this.ubIncluded == interval.ubIncluded;
    }

    public int hashCode() {
        return Objects.hash(this.lb, this.ub, this.lbIncluded, this.ubIncluded);
    }

    public String toString() {
        return (this.lbIncluded ? "[" : "(") + this.lb + ", " + this.ub + (this.ubIncluded ? "]" : ")");
    }
}

