/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.word;

import java.util.AbstractList;
import net.automatalib.word.Word;

class SubwordList<I>
extends AbstractList<Word<I>> {
    private final Word<I> word;
    private final boolean reverse;
    private final boolean prefix;

    SubwordList(Word<I> word, boolean prefix, boolean reverse) {
        this.word = word;
        this.prefix = prefix;
        this.reverse = reverse;
    }

    @Override
    public Word<I> get(int index) {
        int length = this.word.length();
        if (index < 0 || index > length) {
            throw new IndexOutOfBoundsException();
        }
        int idx = this.reverse ? length - index : index;
        return this.prefix ? this.word.prefix(idx) : this.word.suffix(idx);
    }

    @Override
    public int size() {
        return this.word.length() + 1;
    }
}

