/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.visualization.dot;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.Writer;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JViewport;
import javax.swing.event.MouseInputAdapter;
import net.automatalib.common.util.IOUtil;
import net.automatalib.visualization.dot.DOTUtil;
import net.automatalib.visualization.dot.PlottedGraph;
import org.checkerframework.checker.initialization.qual.UnknownInitialization;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DOTImageComponent
extends JComponent {
    private static final Logger LOGGER = LoggerFactory.getLogger(DOTImageComponent.class);
    private @Nullable String dot;
    private @Nullable BufferedImage img;
    private final Action saveDotAction = new AbstractAction("Save DOT"){

        @Override
        public void actionPerformed(ActionEvent e) {
            JFileChooser saveDlg = new JFileChooser();
            saveDlg.setFileFilter(DOTUtil.DOT_FILTER);
            int result = saveDlg.showSaveDialog(DOTImageComponent.this);
            if (result != 0) {
                return;
            }
            String dot = DOTImageComponent.this.dot;
            if (dot == null) {
                throw new IllegalStateException("No DOT text has been set");
            }
            try (Writer w = IOUtil.asBufferedUTF8Writer(saveDlg.getSelectedFile());){
                w.write(dot);
            }
            catch (IOException ex) {
                LOGGER.error("Cannot save DOT", (Throwable)ex);
                JOptionPane.showMessageDialog(DOTImageComponent.this, "Could not save DOT file: " + ex.getMessage(), "Cannot save DOT", 0);
            }
        }
    };
    private final Action savePngAction = new AbstractAction("Save PNG"){

        @Override
        public void actionPerformed(ActionEvent e) {
            JFileChooser chooser = new JFileChooser();
            chooser.setFileFilter(DOTUtil.PNG_FILTER);
            int result = chooser.showSaveDialog(DOTImageComponent.this);
            if (result != 0) {
                return;
            }
            BufferedImage img = DOTImageComponent.this.img;
            if (img == null) {
                throw new IllegalStateException("No image has been set");
            }
            try {
                ImageIO.write((RenderedImage)img, "png", chooser.getSelectedFile());
            }
            catch (IOException ex) {
                LOGGER.error("Cannot save PNG", (Throwable)ex);
                JOptionPane.showMessageDialog(DOTImageComponent.this, "Could not save PNG file: " + ex.getMessage(), "Could not save PNG", 0);
            }
        }
    };

    DOTImageComponent() {
        DnDMover dnDMover = new DnDMover();
        this.setPreferredSize(new Dimension(800, 600));
        this.addMouseListener(dnDMover);
        this.addMouseMotionListener(dnDMover);
    }

    void setImage(@UnknownInitialization(value=DOTImageComponent.class) DOTImageComponent this, @Nullable BufferedImage img) {
        this.img = img;
        Dimension dim = img != null ? new Dimension(img.getWidth(), img.getHeight()) : new Dimension(800, 600);
        this.setSize(dim);
        this.setPreferredSize(dim);
        this.repaint();
    }

    void setDotText(@Nullable String dot) {
        this.dot = dot;
    }

    void setData(@Nullable PlottedGraph pg) {
        if (pg == null) {
            this.setDotText(null);
            this.setImage(null);
        } else {
            this.setDotText(pg.getDotText());
            this.setImage(pg.getImage());
        }
    }

    Action getSavePngAction() {
        return this.savePngAction;
    }

    Action getSaveDotAction() {
        return this.saveDotAction;
    }

    @Override
    protected void paintComponent(Graphics g) {
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.img != null) {
            g.drawImage(this.img, 0, 0, null);
        }
    }

    private class DnDMover
    extends MouseInputAdapter {
        private final DOTImageComponent cmp;
        private Point holdPointOnView;

        DnDMover() {
            this.cmp = DOTImageComponent.this;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.cmp.setCursor(Cursor.getPredefinedCursor(13));
            this.holdPointOnView = e.getPoint();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.cmp.setCursor(null);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            Point dragEventPoint = e.getPoint();
            JViewport viewport = (JViewport)this.cmp.getParent();
            assert (viewport != null);
            Point viewPos = viewport.getViewPosition();
            int maxViewPosX = this.cmp.getWidth() - viewport.getWidth();
            int maxViewPosY = this.cmp.getHeight() - viewport.getHeight();
            assert (this.holdPointOnView != null);
            if (this.cmp.getWidth() > viewport.getWidth()) {
                viewPos.x -= dragEventPoint.x - this.holdPointOnView.x;
                if (viewPos.x < 0) {
                    viewPos.x = 0;
                    this.holdPointOnView.x = dragEventPoint.x;
                }
                if (viewPos.x > maxViewPosX) {
                    viewPos.x = maxViewPosX;
                    this.holdPointOnView.x = dragEventPoint.x;
                }
            }
            if (this.cmp.getHeight() > viewport.getHeight()) {
                viewPos.y -= dragEventPoint.y - this.holdPointOnView.y;
                if (viewPos.y < 0) {
                    viewPos.y = 0;
                    this.holdPointOnView.y = dragEventPoint.y;
                }
                if (viewPos.y > maxViewPosY) {
                    viewPos.y = maxViewPosY;
                    this.holdPointOnView.y = dragEventPoint.y;
                }
            }
            viewport.setViewPosition(viewPos);
        }
    }
}

