/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.visualization.dot;

import com.google.common.io.CharStreams;
import java.awt.Desktop;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.List;
import javax.imageio.ImageIO;
import net.automatalib.AutomataLibProperty;
import net.automatalib.AutomataLibSettings;
import net.automatalib.common.util.IOUtil;
import net.automatalib.common.util.Pair;
import net.automatalib.common.util.process.ProcessUtil;
import net.automatalib.visualization.dot.DOTDialog;
import net.automatalib.visualization.dot.DOTMultiDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DOT {
    private static final Logger LOGGER;
    private static String dotExe;

    private DOT() {
    }

    public static void setDotExe(String dotExe) {
        DOT.dotExe = dotExe;
    }

    public static boolean checkUsable() {
        try {
            String[] dotCheck = DOT.buildRawDOTCommand("-V");
            return ProcessUtil.invokeProcess(dotCheck) == 0;
        }
        catch (IOException | InterruptedException ex) {
            LOGGER.error("Error executing dot", (Throwable)ex);
            return false;
        }
    }

    public static InputStream runDOT(File dotFile, String format, String ... additionalOpts) throws IOException {
        return DOT.runDOT(IOUtil.asBufferedUTF8Reader(dotFile), format, additionalOpts);
    }

    public static InputStream runDOT(Reader r, String format, String ... additionalOpts) throws IOException {
        String[] dotCommand = DOT.buildDOTCommand(format, additionalOpts);
        Process p = ProcessUtil.buildProcess(dotCommand, r, null, arg_0 -> ((Logger)LOGGER).warn(arg_0));
        return p.getInputStream();
    }

    public static InputStream runDOT(String dotText, String format, String ... additionalOpts) throws IOException {
        try (StringReader sr = new StringReader(dotText);){
            InputStream inputStream = DOT.runDOT((Reader)sr, format, additionalOpts);
            return inputStream;
        }
    }

    public static void runDOT(File dotFile, String format, File out) throws IOException {
        DOT.runDOT(IOUtil.asBufferedUTF8Reader(dotFile), format, out);
    }

    public static void runDOT(Reader r, String format, File out) throws IOException {
        String[] dotCommand = DOT.buildDOTCommand(format, "-o" + out.getAbsolutePath());
        try {
            ProcessUtil.invokeProcess(dotCommand, r, arg_0 -> ((Logger)LOGGER).warn(arg_0));
        }
        catch (InterruptedException ex) {
            LOGGER.error("Interrupted while waiting for 'dot' process to exit.", (Throwable)ex);
        }
    }

    public static void runDOT(String dotText, String format, File out) throws IOException {
        DOT.runDOT((Reader)new StringReader(dotText), format, out);
    }

    public static void renderDOTExternal(File dotFile, String format) throws IOException {
        DOT.renderDOTExternal(IOUtil.asBufferedUTF8Reader(dotFile), format);
    }

    public static void renderDOTExternal(Reader r, String format) throws IOException {
        File image = File.createTempFile("dot", format);
        DOT.runDOT(r, format, image);
        Desktop.getDesktop().open(image);
    }

    public static void renderDOTExternal(String dotText, String format) throws IOException {
        DOT.renderDOTExternal(new StringReader(dotText), format);
    }

    public static void renderDOT(File dotFile, boolean modal) throws IOException {
        DOT.renderDOT(IOUtil.asBufferedUTF8Reader(dotFile), modal);
    }

    public static void renderDOT(Reader r, boolean modal) throws IOException {
        DOT.renderDOT(CharStreams.toString((Readable)r), modal);
    }

    public static void renderDOT(String dotText, boolean modal) throws IOException {
        new DOTDialog(dotText, modal);
    }

    public static void renderDOTFiles(List<Pair<String, File>> files, boolean modal) throws IOException {
        DOT.renderDOTInternal(files, modal, f -> CharStreams.toString((Readable)IOUtil.asBufferedUTF8Reader(f)));
    }

    public static void renderDOTReaders(List<Pair<String, Reader>> readers, boolean modal) throws IOException {
        DOT.renderDOTInternal(readers, modal, CharStreams::toString);
    }

    public static void renderDOTStrings(List<Pair<String, String>> dotTexts, boolean modal) throws IOException {
        DOT.renderDOTInternal(dotTexts, modal, s -> s);
    }

    private static <I> void renderDOTInternal(List<Pair<String, I>> dots, boolean modal, DOTMultiDialog.ThrowableExtractor<I, String> extractor) throws IOException {
        new DOTMultiDialog<I>(dots, modal, extractor);
    }

    public static BufferedImage renderDOTImage(File dotFile) throws IOException {
        return DOT.renderDOTImage(IOUtil.asBufferedUTF8Reader(dotFile));
    }

    public static BufferedImage renderDOTImage(Reader dotReader) throws IOException {
        try (InputStream pngIs = DOT.runDOT(dotReader, "png", new String[0]);){
            BufferedImage bufferedImage = ImageIO.read(pngIs);
            return bufferedImage;
        }
    }

    public static BufferedImage renderDOTImage(String dotText) throws IOException {
        return DOT.renderDOTImage(new StringReader(dotText));
    }

    private static String[] buildRawDOTCommand(String ... opts) {
        String[] dotArgs = new String[1 + opts.length];
        dotArgs[0] = dotExe;
        System.arraycopy(opts, 0, dotArgs, 1, opts.length);
        return dotArgs;
    }

    private static String[] buildDOTCommand(String format, String ... additionalOpts) {
        String[] dotArgs = new String[1 + additionalOpts.length];
        dotArgs[0] = "-T" + format;
        System.arraycopy(additionalOpts, 0, dotArgs, 1, additionalOpts.length);
        return DOT.buildRawDOTCommand(dotArgs);
    }

    static {
        String dotExeName;
        LOGGER = LoggerFactory.getLogger(DOT.class);
        AutomataLibSettings settings = AutomataLibSettings.getInstance();
        String dotExePath = settings.getProperty(AutomataLibProperty.DOT_EXE_DIR);
        String dotExe = dotExeName = settings.getProperty(AutomataLibProperty.DOT_EXE_NAME, "dot");
        if (dotExePath != null) {
            Path dotBasePath = FileSystems.getDefault().getPath(dotExePath, new String[0]);
            Path resolvedDotPath = dotBasePath.resolve(dotExeName);
            dotExe = resolvedDotPath.toString();
        }
        DOT.dotExe = dotExe;
    }
}

