/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.ts.traversal;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Iterator;
import net.automatalib.common.util.Holder;
import net.automatalib.ts.TransitionSystem;
import net.automatalib.util.traversal.TraversalOrder;
import net.automatalib.util.ts.traversal.BFSRecord;
import net.automatalib.util.ts.traversal.BreadthFirstIterator;
import net.automatalib.util.ts.traversal.DFRecord;
import net.automatalib.util.ts.traversal.DepthFirstIterator;
import net.automatalib.util.ts.traversal.TSTraversalAction;
import net.automatalib.util.ts.traversal.TSTraversalVisitor;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class TSTraversal {
    public static final int NO_LIMIT = -1;

    private TSTraversal() {
    }

    public static <S, I, T, D> void breadthFirst(TransitionSystem<S, ? super I, T> ts, Collection<? extends I> inputs, TSTraversalVisitor<S, I, T, D> visitor) {
        TSTraversal.breadthFirst(ts, -1, inputs, visitor);
    }

    public static <S, I, T, D> boolean breadthFirst(TransitionSystem<S, ? super I, T> ts, int limit, Collection<? extends I> inputs, TSTraversalVisitor<S, I, T, D> visitor) {
        ArrayDeque bfsQueue = new ArrayDeque();
        boolean complete = true;
        int stateCount = 0;
        Holder dataHolder = new Holder();
        block12: for (Object initS : ts.getInitialStates()) {
            dataHolder.value = null;
            TSTraversalAction act = visitor.processInitial(initS, dataHolder);
            switch (act) {
                case ABORT_INPUT: 
                case ABORT_STATE: 
                case IGNORE: {
                    continue block12;
                }
                case ABORT_TRAVERSAL: {
                    return complete;
                }
                case EXPLORE: {
                    if (stateCount != limit) {
                        bfsQueue.offer(new BFSRecord(initS, dataHolder.value));
                        ++stateCount;
                        continue block12;
                    }
                    complete = false;
                    continue block12;
                }
            }
            throw new IllegalStateException("Unknown action " + (Object)((Object)act));
        }
        while (!bfsQueue.isEmpty()) {
            @NonNull BFSRecord current = (BFSRecord)bfsQueue.poll();
            Object state = current.state;
            Object data = current.data;
            if (!visitor.startExploration(state, data)) continue;
            block14: for (I input : inputs) {
                Collection<T> transitions = ts.getTransitions(state, input);
                block15: for (T trans : transitions) {
                    S succ = ts.getSuccessor(trans);
                    dataHolder.value = null;
                    TSTraversalAction act = visitor.processTransition(state, data, input, trans, succ, dataHolder);
                    switch (act) {
                        case IGNORE: {
                            continue block15;
                        }
                        case ABORT_INPUT: {
                            continue block14;
                        }
                        case ABORT_STATE: {
                            break block14;
                        }
                        case ABORT_TRAVERSAL: {
                            return complete;
                        }
                        case EXPLORE: {
                            if (stateCount != limit) {
                                bfsQueue.offer(new BFSRecord(succ, dataHolder.value));
                                ++stateCount;
                                break;
                            }
                            complete = false;
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Unknown action " + (Object)((Object)act));
                        }
                    }
                }
            }
            visitor.finishExploration(state, data);
        }
        return complete;
    }

    public static <S, I> Iterable<S> breadthFirstOrder(TransitionSystem<S, I, ?> ts, Collection<? extends I> inputs) {
        return () -> TSTraversal.breadthFirstIterator(ts, inputs);
    }

    public static <S, I> Iterator<S> breadthFirstIterator(TransitionSystem<S, I, ?> ts, Collection<? extends I> inputs) {
        return new BreadthFirstIterator(ts, inputs);
    }

    public static <S, I, T, D> void depthFirst(TransitionSystem<S, I, T> ts, Collection<? extends I> inputs, TSTraversalVisitor<S, I, T, D> visitor) {
        TSTraversal.depthFirst(ts, -1, inputs, visitor);
    }

    public static <S, I, T, D> boolean depthFirst(TransitionSystem<S, ? super I, T> ts, int limit, Collection<? extends I> inputs, TSTraversalVisitor<S, I, T, D> visitor) {
        ArrayDeque dfsStack = new ArrayDeque();
        Holder dataHolder = new Holder();
        boolean complete = true;
        int stateCount = 0;
        block12: for (Object initS : ts.getInitialStates()) {
            dataHolder.value = null;
            TSTraversalAction act = visitor.processInitial(initS, dataHolder);
            switch (act) {
                case ABORT_INPUT: 
                case ABORT_STATE: 
                case IGNORE: {
                    continue block12;
                }
                case ABORT_TRAVERSAL: {
                    return complete;
                }
                case EXPLORE: {
                    if (stateCount != limit) {
                        dfsStack.push(new DFRecord(initS, inputs, dataHolder.value));
                        ++stateCount;
                        continue block12;
                    }
                    complete = false;
                    continue block12;
                }
            }
            throw new IllegalStateException("Unknown action " + (Object)((Object)act));
        }
        block13: while (!dfsStack.isEmpty()) {
            @NonNull DFRecord current = (DFRecord)dfsStack.peek();
            Object currState = current.state;
            Object currData = current.data;
            if (current.start(ts) && !visitor.startExploration(currState, currData)) {
                dfsStack.pop();
                continue;
            }
            DFRecord.LastTransition lastTransition = current.getLastTransition();
            if (lastTransition != null) {
                visitor.backtrackTransition(currState, currData, lastTransition.input, lastTransition.transition, lastTransition.state, lastTransition.data);
            }
            if (!current.hasNextTransition(ts)) {
                dfsStack.pop();
                visitor.finishExploration(currState, currData);
                continue;
            }
            Object input = current.input();
            Object trans = current.transition();
            S succ = ts.getSuccessor(trans);
            dataHolder.value = null;
            TSTraversalAction act = visitor.processTransition(currState, currData, input, trans, succ, dataHolder);
            switch (act) {
                case ABORT_INPUT: {
                    current.advanceInput(ts);
                    continue block13;
                }
                case ABORT_STATE: {
                    dfsStack.pop();
                    continue block13;
                }
                case ABORT_TRAVERSAL: {
                    return complete;
                }
                case IGNORE: {
                    current.advance(ts);
                    continue block13;
                }
                case EXPLORE: {
                    if (stateCount != limit) {
                        Object data = dataHolder.value;
                        current.setLastTransition(input, trans, succ, data);
                        dfsStack.push(new DFRecord(succ, inputs, data));
                        ++stateCount;
                        continue block13;
                    }
                    complete = false;
                    continue block13;
                }
            }
            throw new IllegalStateException("Unknown action " + (Object)((Object)act));
        }
        return complete;
    }

    public static <S, I> Iterable<S> depthFirstOrder(TransitionSystem<S, I, ?> ts, Collection<? extends I> inputs) {
        return () -> TSTraversal.depthFirstIterator(ts, inputs);
    }

    public static <S, I> Iterator<S> depthFirstIterator(TransitionSystem<S, I, ?> ts, Collection<? extends I> inputs) {
        return new DepthFirstIterator(ts, inputs);
    }

    public static <S, I, T, D> void traverse(TraversalOrder order, TransitionSystem<S, ? super I, T> ts, Collection<? extends I> inputs, TSTraversalVisitor<S, I, T, D> visitor) {
        TSTraversal.traverse(order, ts, -1, inputs, visitor);
    }

    public static <S, I, T, D> boolean traverse(TraversalOrder order, TransitionSystem<S, ? super I, T> ts, int limit, Collection<? extends I> inputs, TSTraversalVisitor<S, I, T, D> visitor) {
        switch (order) {
            case BREADTH_FIRST: {
                return TSTraversal.breadthFirst(ts, limit, inputs, visitor);
            }
            case DEPTH_FIRST: {
                return TSTraversal.depthFirst(ts, limit, inputs, visitor);
            }
        }
        throw new IllegalArgumentException("Unknown traversal order: " + (Object)((Object)order));
    }
}

