/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.graph.traversal;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import net.automatalib.common.util.Holder;
import net.automatalib.graph.IndefiniteGraph;
import net.automatalib.util.graph.traversal.BFRecord;
import net.automatalib.util.graph.traversal.BreadthFirstIterator;
import net.automatalib.util.graph.traversal.DFRecord;
import net.automatalib.util.graph.traversal.DepthFirstIterator;
import net.automatalib.util.graph.traversal.GraphTraversalAction;
import net.automatalib.util.graph.traversal.GraphTraversalVisitor;
import net.automatalib.util.traversal.TraversalOrder;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class GraphTraversal {
    public static final int NO_LIMIT = -1;

    private GraphTraversal() {
    }

    public static <N, E, D> void breadthFirst(IndefiniteGraph<N, E> graph, N initialNode, GraphTraversalVisitor<N, E, D> visitor) {
        GraphTraversal.breadthFirst(graph, -1, initialNode, visitor);
    }

    public static <N, E, D> void breadthFirst(IndefiniteGraph<N, E> graph, Collection<? extends N> initialNodes, GraphTraversalVisitor<N, E, D> visitor) {
        GraphTraversal.breadthFirst(graph, -1, initialNodes, visitor);
    }

    public static <N, E, D> boolean breadthFirst(IndefiniteGraph<N, E> graph, int limit, N initialNode, GraphTraversalVisitor<N, E, D> visitor) {
        return GraphTraversal.breadthFirst(graph, limit, Collections.singleton(initialNode), visitor);
    }

    public static <N, E, D> boolean breadthFirst(IndefiniteGraph<N, E> graph, int limit, Collection<? extends N> initialNodes, GraphTraversalVisitor<N, E, D> visitor) {
        ArrayDeque bfsQueue = new ArrayDeque();
        boolean complete = true;
        int nodeCount = 0;
        Holder dataHolder = new Holder();
        block11: for (N init : initialNodes) {
            dataHolder.value = null;
            GraphTraversalAction act = visitor.processInitial(init, dataHolder);
            switch (act) {
                case IGNORE: 
                case ABORT_NODE: {
                    continue block11;
                }
                case ABORT_TRAVERSAL: {
                    return complete;
                }
                case EXPLORE: {
                    if (nodeCount != limit) {
                        bfsQueue.add(new BFRecord(init, dataHolder.value));
                        ++nodeCount;
                        continue block11;
                    }
                    complete = false;
                    continue block11;
                }
            }
            throw new IllegalArgumentException("Unknown action " + (Object)((Object)act));
        }
        block12: while (!bfsQueue.isEmpty()) {
            @NonNull BFRecord current = (BFRecord)bfsQueue.poll();
            Object currNode = current.node;
            Object currData = current.data;
            if (!visitor.startExploration(currNode, currData)) continue;
            Iterator<E> edges = graph.getOutgoingEdgesIterator(currNode);
            block13: while (edges.hasNext()) {
                E edge = edges.next();
                N tgtNode = graph.getTarget(edge);
                dataHolder.value = null;
                GraphTraversalAction act = visitor.processEdge(currNode, currData, edge, tgtNode, dataHolder);
                switch (act) {
                    case IGNORE: {
                        continue block13;
                    }
                    case ABORT_NODE: {
                        continue block12;
                    }
                    case ABORT_TRAVERSAL: {
                        return complete;
                    }
                    case EXPLORE: {
                        if (nodeCount != limit) {
                            bfsQueue.offer(new BFRecord(tgtNode, dataHolder.value));
                            ++nodeCount;
                            continue block13;
                        }
                        complete = false;
                        continue block13;
                    }
                }
                throw new IllegalArgumentException("Unknown action " + (Object)((Object)act));
            }
            visitor.finishExploration(currNode, currData);
        }
        return complete;
    }

    public static <N, E> Iterable<N> breadthFirstOrder(IndefiniteGraph<N, E> graph, Collection<? extends N> start) {
        return () -> GraphTraversal.breadthFirstIterator(graph, start);
    }

    public static <N, E> Iterator<N> breadthFirstIterator(IndefiniteGraph<N, E> graph, Collection<? extends N> start) {
        return new BreadthFirstIterator<N, E>(graph, start);
    }

    public static <N, E, D> void depthFirst(IndefiniteGraph<N, E> graph, N initialNode, GraphTraversalVisitor<N, E, D> visitor) {
        GraphTraversal.depthFirst(graph, -1, initialNode, visitor);
    }

    public static <N, E, D> void depthFirst(IndefiniteGraph<N, E> graph, Collection<? extends N> initialNodes, GraphTraversalVisitor<N, E, D> visitor) {
        GraphTraversal.depthFirst(graph, -1, initialNodes, visitor);
    }

    public static <N, E, D> boolean depthFirst(IndefiniteGraph<N, E> graph, int limit, N initialNode, GraphTraversalVisitor<N, E, D> visitor) {
        return GraphTraversal.depthFirst(graph, limit, Collections.singleton(initialNode), visitor);
    }

    public static <N, E, D> boolean depthFirst(IndefiniteGraph<N, E> graph, int limit, Collection<? extends N> initialNodes, GraphTraversalVisitor<N, E, D> visitor) {
        ArrayDeque dfsStack = new ArrayDeque();
        Holder dataHolder = new Holder();
        boolean complete = true;
        int nodeCount = 0;
        block11: for (N init : initialNodes) {
            dataHolder.value = null;
            GraphTraversalAction act = visitor.processInitial(init, dataHolder);
            switch (act) {
                case IGNORE: 
                case ABORT_NODE: {
                    continue block11;
                }
                case ABORT_TRAVERSAL: {
                    return complete;
                }
                case EXPLORE: {
                    if (nodeCount != limit) {
                        dfsStack.push(new DFRecord(init, dataHolder.value));
                        ++nodeCount;
                        continue block11;
                    }
                    complete = false;
                    continue block11;
                }
            }
            throw new IllegalArgumentException("Unknown action " + (Object)((Object)act));
        }
        block12: while (!dfsStack.isEmpty()) {
            @NonNull DFRecord current = (DFRecord)dfsStack.peek();
            Object currNode = current.node;
            Object currData = current.data;
            if (current.start(graph) && !visitor.startExploration(currNode, currData)) {
                dfsStack.pop();
                continue;
            }
            DFRecord.LastEdge lastEdge = current.getLastEdge();
            if (lastEdge != null) {
                visitor.backtrackEdge(currNode, currData, lastEdge.edge, lastEdge.node, lastEdge.data);
            }
            if (!current.hasNextEdge()) {
                dfsStack.pop();
                visitor.finishExploration(currNode, currData);
                continue;
            }
            Object edge = current.nextEdge();
            N tgt = graph.getTarget(edge);
            GraphTraversalAction act = visitor.processEdge(currNode, currData, edge, tgt, dataHolder);
            switch (act) {
                case IGNORE: {
                    continue block12;
                }
                case ABORT_NODE: {
                    dfsStack.pop();
                    continue block12;
                }
                case ABORT_TRAVERSAL: {
                    return complete;
                }
                case EXPLORE: {
                    if (nodeCount != limit) {
                        Object data = dataHolder.value;
                        current.setLastEdge(edge, tgt, data);
                        dfsStack.push(new DFRecord(tgt, data));
                        ++nodeCount;
                        continue block12;
                    }
                    complete = false;
                    continue block12;
                }
            }
            throw new IllegalArgumentException("Unknown action " + (Object)((Object)act));
        }
        return complete;
    }

    public static <N, E> Iterable<N> depthFirstOrder(IndefiniteGraph<N, E> graph, Collection<? extends N> start) {
        return () -> GraphTraversal.depthFirstIterator(graph, start);
    }

    public static <N, E> Iterator<N> depthFirstIterator(IndefiniteGraph<N, E> graph, Collection<? extends N> start) {
        return new DepthFirstIterator<N, E>(graph, start);
    }

    public static <N, E, D> void traverse(TraversalOrder order, IndefiniteGraph<N, E> graph, N initialNode, GraphTraversalVisitor<N, E, D> visitor) {
        GraphTraversal.traverse(order, graph, -1, initialNode, visitor);
    }

    public static <N, E, D> void traverse(TraversalOrder order, IndefiniteGraph<N, E> graph, Collection<? extends N> initialNodes, GraphTraversalVisitor<N, E, D> visitor) {
        GraphTraversal.traverse(order, graph, -1, initialNodes, visitor);
    }

    public static <N, E, D> boolean traverse(TraversalOrder order, IndefiniteGraph<N, E> graph, int limit, N initialNode, GraphTraversalVisitor<N, E, D> visitor) {
        return GraphTraversal.traverse(order, graph, limit, Collections.singleton(initialNode), visitor);
    }

    public static <N, E, D> boolean traverse(TraversalOrder order, IndefiniteGraph<N, E> graph, int limit, Collection<? extends N> initialNodes, GraphTraversalVisitor<N, E, D> visitor) {
        switch (order) {
            case BREADTH_FIRST: {
                return GraphTraversal.breadthFirst(graph, limit, initialNodes, visitor);
            }
            case DEPTH_FIRST: {
                return GraphTraversal.depthFirst(graph, limit, initialNodes, visitor);
            }
        }
        throw new IllegalArgumentException("Unknown traversal order " + (Object)((Object)order));
    }
}

