/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.graph;

import com.google.common.collect.AbstractIterator;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Queue;
import java.util.function.Predicate;
import net.automatalib.common.util.mapping.MutableMapping;
import net.automatalib.graph.IndefiniteGraph;
import net.automatalib.util.graph.Path;
import org.checkerframework.checker.index.qual.NonNegative;

final class FindShortestPathsIterator<N, E>
extends AbstractIterator<Path<N, E>> {
    private final Queue<N> bfsQueue;
    private final IndefiniteGraph<N, E> graph;
    private final MutableMapping<N, Pred<N, E>> preds;
    private final Predicate<? super N> targetPred;
    private final int limit;

    FindShortestPathsIterator(IndefiniteGraph<N, E> graph, Collection<? extends N> start, @NonNegative int limit, Predicate<? super N> targetPred) {
        this.graph = graph;
        this.preds = graph.createStaticNodeMapping();
        this.limit = limit;
        this.targetPred = targetPred;
        this.bfsQueue = new ArrayDeque<N>(start.size());
        for (N startNode : start) {
            this.preds.put(startNode, new Pred<Object, Object>(null, null, 0));
            this.bfsQueue.add(startNode);
        }
    }

    protected Path<N, E> computeNext() {
        while (!this.bfsQueue.isEmpty()) {
            N curr = this.bfsQueue.poll();
            if (this.targetPred.test(curr)) {
                return this.makePath(curr);
            }
            int currentDepth = ((Pred)this.preds.get(curr)).depth;
            Iterator<E> edgeIter = this.graph.getOutgoingEdgesIterator(curr);
            while (edgeIter.hasNext()) {
                E edge = edgeIter.next();
                N tgt = this.graph.getTarget(edge);
                Pred targetPred = (Pred)this.preds.get(tgt);
                if (targetPred != null || currentDepth >= this.limit) continue;
                this.preds.put(tgt, new Pred<N, E>(curr, edge, currentDepth + 1));
                this.bfsQueue.add(tgt);
            }
        }
        return (Path)this.endOfData();
    }

    private Path<N, E> makePath(N target) {
        N currNode = target;
        Pred pred = (Pred)this.preds.get(currNode);
        ArrayList edges = new ArrayList(pred.depth);
        while (pred != null && pred.edge != null) {
            edges.add(pred.edge);
            currNode = pred.node;
            pred = (Pred)this.preds.get(currNode);
        }
        Collections.reverse(edges);
        return new Path<N, E>(this.graph, currNode, edges);
    }

    private static final class Pred<N, E> {
        public final N node;
        public final E edge;
        public final int depth;

        Pred(N node, E edge, int depth) {
            this.node = node;
            this.edge = edge;
            this.depth = depth;
        }
    }
}

