/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.automaton.random;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Random;
import net.automatalib.alphabet.Alphabet;
import net.automatalib.alphabet.ProceduralInputAlphabet;
import net.automatalib.alphabet.ProceduralOutputAlphabet;
import net.automatalib.alphabet.VPAlphabet;
import net.automatalib.automaton.MutableDeterministic;
import net.automatalib.automaton.fsa.CompactDFA;
import net.automatalib.automaton.fsa.DFA;
import net.automatalib.automaton.procedural.SBA;
import net.automatalib.automaton.procedural.SPA;
import net.automatalib.automaton.procedural.SPMM;
import net.automatalib.automaton.procedural.StackSBA;
import net.automatalib.automaton.procedural.StackSPA;
import net.automatalib.automaton.procedural.StackSPMM;
import net.automatalib.automaton.transducer.CompactMealy;
import net.automatalib.automaton.transducer.CompactMoore;
import net.automatalib.automaton.vpa.DefaultOneSEVPA;
import net.automatalib.automaton.vpa.Location;
import net.automatalib.util.automaton.Automata;
import net.automatalib.util.automaton.fsa.DFAs;
import net.automatalib.util.automaton.procedural.SPAs;
import net.automatalib.util.automaton.random.RandomDeterministicAutomatonGenerator;
import net.automatalib.util.automaton.random.RandomICAutomatonGenerator;
import net.automatalib.util.minimizer.OneSEVPAMinimizer;
import org.checkerframework.checker.index.qual.NonNegative;

public final class RandomAutomata {
    private RandomAutomata() {
    }

    public static <I> CompactDFA<I> randomICDFA(Random rand, @NonNegative int numStates, Alphabet<I> inputs, boolean minimize) {
        CompactDFA dfa = (CompactDFA)new RandomICAutomatonGenerator().withStateProperties(Random::nextBoolean).generateICDeterministicAutomaton(numStates, inputs, new CompactDFA.Creator(), rand);
        return minimize ? DFAs.minimize(dfa) : dfa;
    }

    public static <I> DefaultOneSEVPA<I> randomOneSEVPA(Random r, int locCount, VPAlphabet<I> alphabet, double acceptanceProb, double initialRetTransProb, boolean minimize) {
        return RandomAutomata.randomOneSEVPA(r, locCount, alphabet, acceptanceProb, initialRetTransProb, minimize, new DefaultOneSEVPA<I>(alphabet, locCount));
    }

    public static <I> DefaultOneSEVPA<I> randomOneSEVPA(Random r, int locCount, VPAlphabet<I> alphabet, double acceptanceProb, double initialRetTransProb, boolean minimize, DefaultOneSEVPA<I> result) {
        result.addInitialLocation(r.nextDouble() < acceptanceProb);
        for (int i = 0; i < locCount - 1; ++i) {
            I intSym;
            Location srcLoc;
            if (alphabet.getNumInternals() == 0 || r.nextDouble() < initialRetTransProb) {
                I callSym;
                Location stackLoc;
                int stackSym;
                I retSym;
                do {
                    retSym = alphabet.getReturnSymbol(r.nextInt(alphabet.getNumReturns()));
                    srcLoc = result.getLocation(r.nextInt(result.size()));
                    callSym = alphabet.getCallSymbol(r.nextInt(alphabet.getNumCalls()));
                } while (result.getReturnSuccessor(srcLoc, retSym, stackSym = result.encodeStackSym(stackLoc = result.getLocation(r.nextInt(result.size())), callSym)) != null);
                Location newLoc = result.addLocation(r.nextDouble() < acceptanceProb);
                result.setReturnSuccessor(srcLoc, retSym, stackSym, newLoc);
                continue;
            }
            do {
                intSym = alphabet.getInternalSymbol(r.nextInt(alphabet.getNumInternals()));
            } while (result.getInternalSuccessor(srcLoc = result.getLocation(r.nextInt(result.size())), intSym) != null);
            Location newLoc = result.addLocation(r.nextDouble() < acceptanceProb);
            result.setInternalSuccessor(srcLoc, intSym, newLoc);
        }
        for (Location loc : result.getLocations()) {
            for (Object intSym : alphabet.getInternalAlphabet()) {
                if (result.getInternalSuccessor(loc, intSym) != null) continue;
                Location tgtLoc = result.getLocation(r.nextInt(result.size()));
                result.setInternalSuccessor(loc, intSym, tgtLoc);
            }
            for (Object callSym : alphabet.getCallAlphabet()) {
                for (Location stackLoc : result.getLocations()) {
                    int stackSym = result.encodeStackSym(stackLoc, callSym);
                    for (Object retSym : alphabet.getReturnAlphabet()) {
                        if (result.getReturnSuccessor(loc, retSym, stackSym) != null) continue;
                        Location tgtLoc = result.getLocation(r.nextInt(result.size()));
                        result.setReturnSuccessor(loc, retSym, stackSym, tgtLoc);
                    }
                }
            }
        }
        if (minimize) {
            return OneSEVPAMinimizer.minimize(result, alphabet);
        }
        return result;
    }

    public static <I> SPA<?, I> randomSPA(Random random, ProceduralInputAlphabet<I> alphabet, int procedureSize) {
        return RandomAutomata.randomSPA(random, alphabet, procedureSize, true);
    }

    public static <I> SPA<?, I> randomSPA(Random random, ProceduralInputAlphabet<I> alphabet, int procedureSize, boolean minimize) {
        StackSPA result;
        do {
            HashMap dfas = Maps.newHashMapWithExpectedSize((int)alphabet.getNumCalls());
            Alphabet<I> proceduralAlphabet = alphabet.getProceduralAlphabet();
            for (Object procedure : alphabet.getCallAlphabet()) {
                CompactDFA<I> dfa = RandomAutomata.randomDFA(random, procedureSize, proceduralAlphabet, minimize);
                dfas.put(procedure, dfa);
            }
            result = new StackSPA(alphabet, alphabet.getCallSymbol(random.nextInt(alphabet.getNumCalls())), dfas);
        } while (minimize && !SPAs.isMinimal(result));
        return result;
    }

    public static <I> SBA<?, I> randomSBA(Random random, ProceduralInputAlphabet<I> alphabet, int procedureSize) {
        return RandomAutomata.randomSBA(random, alphabet, procedureSize, true);
    }

    public static <I> SBA<?, I> randomSBA(Random random, ProceduralInputAlphabet<I> alphabet, int procedureSize, boolean minimize) {
        assert (procedureSize > 1);
        ArrayList<Object> inputs = new ArrayList<Object>(alphabet.size());
        ArrayList nonTerminatingProcedures = new ArrayList(alphabet.getNumCalls());
        inputs.add(alphabet.getReturnSymbol());
        inputs.addAll(alphabet.getInternalAlphabet());
        for (Object i : alphabet.getCallAlphabet()) {
            if (random.nextBoolean()) {
                inputs.add(i);
                continue;
            }
            nonTerminatingProcedures.add(i);
        }
        HashMap dfas = Maps.newHashMapWithExpectedSize((int)alphabet.getNumCalls());
        for (Object procedure : alphabet.getCallAlphabet()) {
            CompactDFA<Object> dfa = new CompactDFA<Object>(alphabet);
            RandomAutomata.randomDeterministic(random, procedureSize - 2, inputs, Collections.singletonList(Boolean.TRUE), DFA.TRANSITION_PROPERTIES, dfa, false);
            ArrayList<Integer> originalStates = new ArrayList<Integer>(dfa.getStates());
            Integer successSink = dfa.addState(true);
            Integer sink = dfa.addState(false);
            for (Object i : alphabet) {
                dfa.setTransition(successSink, i, sink);
                dfa.setTransition(sink, i, sink);
            }
            for (Integer s : originalStates) {
                for (Object i : nonTerminatingProcedures) {
                    dfa.setTransition(s, i, successSink);
                }
                if (nonTerminatingProcedures.contains(procedure)) {
                    dfa.setTransition(s, (Object)alphabet.getReturnSymbol(), sink);
                    continue;
                }
                if (random.nextBoolean()) {
                    dfa.setTransition(s, (Object)alphabet.getReturnSymbol(), successSink);
                    continue;
                }
                dfa.setTransition(s, (Object)alphabet.getReturnSymbol(), sink);
            }
            if (minimize) {
                Automata.invasiveMinimize(dfa, alphabet);
            }
            assert (DFAs.isPrefixClosed(dfa, alphabet));
            dfas.put(procedure, dfa);
        }
        return new StackSBA(alphabet, alphabet.getCallSymbol(random.nextInt(alphabet.getNumCalls())), dfas);
    }

    public static <I, O> SPMM<?, I, ?, O> randomSPMM(Random random, ProceduralInputAlphabet<I> inputAlphabet, ProceduralOutputAlphabet<O> outputAlphabet, int procedureSize) {
        return RandomAutomata.randomSPMM(random, inputAlphabet, outputAlphabet, procedureSize, true);
    }

    public static <I, O> SPMM<?, I, ?, O> randomSPMM(Random random, ProceduralInputAlphabet<I> inputAlphabet, ProceduralOutputAlphabet<O> outputAlphabet, int procedureSize, boolean minimize) {
        assert (procedureSize > 0);
        HashSet<Object> nonContinuableSymbols = new HashSet<Object>();
        nonContinuableSymbols.add(inputAlphabet.getReturnSymbol());
        for (Object i : inputAlphabet.getCallAlphabet()) {
            if (!random.nextBoolean()) continue;
            nonContinuableSymbols.add(i);
        }
        HashMap mealies = Maps.newHashMapWithExpectedSize((int)inputAlphabet.getNumCalls());
        for (Object procedure : inputAlphabet.getCallAlphabet()) {
            CompactMealy mealy = new CompactMealy(inputAlphabet);
            RandomAutomata.randomDeterministic(random, procedureSize - 1, inputAlphabet, Collections.emptyList(), outputAlphabet, mealy, false);
            ArrayList<Integer> originalStates = new ArrayList<Integer>(mealy.getStates());
            Integer sink = (Integer)mealy.addState();
            for (Object i : inputAlphabet) {
                mealy.setTransition(sink, i, sink, outputAlphabet.getErrorSymbol());
                boolean isNonContinuable = nonContinuableSymbols.contains(i);
                for (Integer s : originalStates) {
                    Object output = mealy.getTransitionProperty(s, i);
                    if (!isNonContinuable && !outputAlphabet.isErrorSymbol(output)) continue;
                    mealy.setTransition(s, i, sink, output);
                }
            }
            if (minimize) {
                Automata.invasiveMinimize(mealy, inputAlphabet);
            }
            mealies.put(procedure, mealy);
        }
        Alphabet<O> internalOutputs = outputAlphabet.getRegularAlphabet();
        return new StackSPMM(inputAlphabet, inputAlphabet.getCallSymbol(random.nextInt(inputAlphabet.getNumCalls())), internalOutputs.getSymbol(random.nextInt(internalOutputs.size())), outputAlphabet.getErrorSymbol(), mealies);
    }

    public static <S, I, T, SP, TP, A extends MutableDeterministic<S, I, T, SP, TP>> A randomDeterministic(Random rand, @NonNegative int numStates, Collection<? extends I> inputs, Collection<? extends SP> stateProps, Collection<? extends TP> transProps, A out) {
        return RandomAutomata.randomDeterministic(rand, numStates, inputs, stateProps, transProps, out, true);
    }

    public static <S, I, T, SP, TP, A extends MutableDeterministic<S, I, T, SP, TP>> A randomDeterministic(Random rand, @NonNegative int numStates, Collection<? extends I> inputs, Collection<? extends SP> stateProps, Collection<? extends TP> transProps, A out, boolean minimize) {
        RandomDeterministicAutomatonGenerator gen = new RandomDeterministicAutomatonGenerator(rand, inputs, stateProps, transProps, out);
        gen.addStates(numStates);
        gen.addTransitions();
        gen.chooseInitial();
        if (minimize) {
            Automata.invasiveMinimize(out, inputs);
        }
        return out;
    }

    public static <I> CompactDFA<I> randomDFA(Random rand, @NonNegative int numStates, Alphabet<I> inputs, boolean minimize) {
        return RandomAutomata.randomDeterministic(rand, numStates, inputs, DFA.STATE_PROPERTIES, DFA.TRANSITION_PROPERTIES, new CompactDFA<I>(inputs), minimize);
    }

    public static <I> CompactDFA<I> randomDFA(Random rand, @NonNegative int numStates, Alphabet<I> inputs) {
        return RandomAutomata.randomDFA(rand, numStates, inputs, true);
    }

    public static <I, O> CompactMealy<I, O> randomMealy(Random rand, @NonNegative int numStates, Alphabet<I> inputs, Collection<? extends O> outputs, boolean minimize) {
        return RandomAutomata.randomDeterministic(rand, numStates, inputs, Collections.singleton(null), outputs, new CompactMealy(inputs), minimize);
    }

    public static <I, O> CompactMealy<I, O> randomMealy(Random rand, @NonNegative int numStates, Alphabet<I> inputs, Collection<? extends O> outputs) {
        return RandomAutomata.randomMealy(rand, numStates, inputs, outputs, true);
    }

    public static <I, O> CompactMoore<I, O> randomMoore(Random rand, @NonNegative int numStates, Alphabet<I> inputs, Collection<? extends O> outputs, boolean minimize) {
        return RandomAutomata.randomDeterministic(rand, numStates, inputs, outputs, Collections.singleton(null), new CompactMoore(inputs), minimize);
    }

    public static <I, O> CompactMoore<I, O> randomMoore(Random rand, @NonNegative int numStates, Alphabet<I> inputs, Collection<? extends O> outputs) {
        return RandomAutomata.randomMoore(rand, numStates, inputs, outputs, true);
    }
}

