/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.automaton.procedural;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import net.automatalib.alphabet.ProceduralInputAlphabet;
import net.automatalib.automaton.procedural.SPMM;
import net.automatalib.automaton.transducer.MealyMachine;
import net.automatalib.util.automaton.procedural.ATSequences;
import net.automatalib.util.automaton.procedural.ProceduralUtil;
import net.automatalib.word.Word;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class SPMMs {
    private SPMMs() {
    }

    public static <I, O> ATSequences<I> computeATSequences(SPMM<?, I, ?, O> spmm) {
        return SPMMs.computeATSequences(spmm, spmm.getInputAlphabet());
    }

    public static <I, O> ATSequences<I> computeATSequences(SPMM<?, I, ?, O> spmm, ProceduralInputAlphabet<I> alphabet) {
        assert (SPMMs.isValid(spmm, alphabet));
        Map<I, Word<I>> terminatingSequences = SPMMs.computeTerminatingSequences(spmm, alphabet);
        Map<I, Word<I>> accessSequences = SPMMs.computeAccessSequences(spmm, alphabet, terminatingSequences);
        return new ATSequences<I>(accessSequences, terminatingSequences);
    }

    public static <I, O> Map<I, Word<I>> computeTerminatingSequences(SPMM<?, I, ?, O> spmm, ProceduralInputAlphabet<I> alphabet) {
        Word returnWord = Word.fromLetter(alphabet.getReturnSymbol());
        return ProceduralUtil.computeTerminatingSequences(spmm.getProcedures(), alphabet, (mealy, trace) -> {
            Word output = (Word)mealy.computeSuffixOutput(trace, returnWord);
            return !output.isEmpty() && !spmm.isErrorOutput(output.lastSymbol());
        });
    }

    public static <I, O> Map<I, Word<I>> computeAccessSequences(SPMM<?, I, ?, O> spmm, ProceduralInputAlphabet<I> alphabet, Map<I, Word<I>> terminatingSequences) {
        return ProceduralUtil.computeAccessSequences(spmm.getProcedures(), alphabet, spmm.getProceduralInputs(alphabet), spmm.getInitialProcedure(), terminatingSequences, (mealy, trace) -> !spmm.isErrorOutput(((Word)mealy.computeOutput(trace)).lastSymbol()));
    }

    public static <I, O> boolean isValid(SPMM<?, I, ?, O> spmm) {
        return SPMMs.isValid(spmm, spmm.getInputAlphabet());
    }

    public static <I, O> boolean isValid(SPMM<?, I, ?, O> spmm, ProceduralInputAlphabet<I> alphabet) {
        Map<I, Word<I>> ts = SPMMs.computeTerminatingSequences(spmm, alphabet);
        Collection<I> proceduralInputs = spmm.getProceduralInputs(alphabet);
        HashSet nonContinuableSymbols = new HashSet(alphabet.getCallAlphabet());
        nonContinuableSymbols.removeAll(ts.keySet());
        nonContinuableSymbols.retainAll(proceduralInputs);
        nonContinuableSymbols.add(alphabet.getReturnSymbol());
        for (MealyMachine p : spmm.getProcedures().values()) {
            if (SPMMs.isErrorReturnAndCallClosed(p, proceduralInputs, nonContinuableSymbols, spmm.getErrorOutput())) continue;
            return false;
        }
        return true;
    }

    private static <S, I, O> boolean isErrorReturnAndCallClosed(MealyMachine<S, I, ?, O> procedure, Collection<I> inputs, Collection<I> nonContinuableInputs, O errorOutput) {
        for (I i : inputs) {
            boolean isNonContinuable = nonContinuableInputs.contains(i);
            for (Object s : procedure) {
                Object output = procedure.getOutput(s, i);
                Object succ = procedure.getSuccessor(s, i);
                if (succ == null || !isNonContinuable && !Objects.equals(output, errorOutput) || SPMMs.isSink(procedure, inputs, succ, errorOutput)) continue;
                return false;
            }
        }
        return true;
    }

    private static <S, I, T, O> boolean isSink(MealyMachine<S, I, T, O> m, Collection<? extends I> inputs, S state, O output) {
        for (I i : inputs) {
            Object t = m.getTransition(state, i);
            if (t == null || Objects.equals(m.getSuccessor(t), state) && Objects.equals(m.getTransitionOutput(t), output)) continue;
            return false;
        }
        return true;
    }

    public static <I, O> boolean testEquivalence(SPMM<?, I, ?, O> spmm1, SPMM<?, I, ?, O> spmm2, ProceduralInputAlphabet<I> alphabet) {
        return SPMMs.findSeparatingWord(spmm1, spmm2, alphabet) == null;
    }

    public static <I, O> @Nullable Word<I> findSeparatingWord(SPMM<?, I, ?, O> spmm1, SPMM<?, I, ?, O> spmm2, ProceduralInputAlphabet<I> alphabet) {
        ATSequences<I> at1 = SPMMs.computeATSequences(spmm1, alphabet);
        ATSequences<I> at2 = SPMMs.computeATSequences(spmm2, alphabet);
        return ProceduralUtil.findSeparatingWord(spmm1.getProcedures(), at1, spmm2.getProcedures(), at2, alphabet);
    }
}

