/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.automaton.procedural;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.automatalib.alphabet.Alphabet;
import net.automatalib.alphabet.ProceduralInputAlphabet;
import net.automatalib.automaton.fsa.DFA;
import net.automatalib.automaton.graph.TransitionEdge;
import net.automatalib.automaton.procedural.SPA;
import net.automatalib.automaton.vpa.OneSEVPA;
import net.automatalib.automaton.vpa.SEVPA;
import net.automatalib.common.util.Pair;
import net.automatalib.common.util.mapping.Mapping;
import net.automatalib.graph.ContextFreeModalProcessSystem;
import net.automatalib.graph.Graph;
import net.automatalib.util.automaton.Automata;
import net.automatalib.util.automaton.procedural.ATRSequences;
import net.automatalib.util.automaton.procedural.CFMPSViewSPA;
import net.automatalib.util.automaton.procedural.NSEVPAConverter;
import net.automatalib.util.automaton.procedural.OneSEVPAConverter;
import net.automatalib.util.automaton.procedural.ProceduralUtil;
import net.automatalib.util.graph.Graphs;
import net.automatalib.util.graph.apsp.APSPResult;
import net.automatalib.word.Word;
import net.automatalib.word.WordBuilder;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class SPAs {
    private SPAs() {
    }

    public static <I> ATRSequences<I> computeATRSequences(SPA<?, I> spa) {
        return SPAs.computeATRSequences(spa, spa.getInputAlphabet());
    }

    public static <I> ATRSequences<I> computeATRSequences(SPA<?, I> spa, ProceduralInputAlphabet<I> alphabet) {
        Map<I, Word<I>> terminatingSequences = SPAs.computeTerminatingSequences(spa, alphabet);
        Pair<Map<I, Word<I>>, Map<I, Word<I>>> accessAndReturnSequences = SPAs.computeAccessAndReturnSequences(spa, alphabet, terminatingSequences);
        Map<I, Word<I>> accessSequences = accessAndReturnSequences.getFirst();
        Map<I, Word<I>> returnSequences = accessAndReturnSequences.getSecond();
        return new ATRSequences<I>(accessSequences, terminatingSequences, returnSequences);
    }

    public static <I> Map<I, Word<I>> computeTerminatingSequences(SPA<?, I> spa, ProceduralInputAlphabet<I> alphabet) {
        return ProceduralUtil.computeTerminatingSequences(spa.getProcedures(), alphabet, DFA::accepts);
    }

    public static <I> Pair<Map<I, Word<I>>, Map<I, Word<I>>> computeAccessAndReturnSequences(SPA<?, I> spa, ProceduralInputAlphabet<I> alphabet, Map<I, Word<I>> terminatingSequences) {
        Object initialProcedure = spa.getInitialProcedure();
        if (initialProcedure == null || spa.getProcedure(initialProcedure) == null) {
            return Pair.of(Collections.emptyMap(), Collections.emptyMap());
        }
        Map submodels = spa.getProcedures();
        Collection<I> proceduralInputs = spa.getProceduralInputs(alphabet);
        HashMap accessSequences = Maps.newHashMapWithExpectedSize((int)alphabet.getNumCalls());
        HashMap returnSequences = Maps.newHashMapWithExpectedSize((int)alphabet.getNumCalls());
        HashSet finishedProcedures = Sets.newHashSetWithExpectedSize((int)alphabet.getNumCalls());
        accessSequences.put(initialProcedure, Word.fromLetter(initialProcedure));
        returnSequences.put(initialProcedure, Word.fromLetter(alphabet.getReturnSymbol()));
        finishedProcedures.add(initialProcedure);
        ArrayDeque<I> pendingProcedures = new ArrayDeque<I>();
        pendingProcedures.add(initialProcedure);
        while (!pendingProcedures.isEmpty()) {
            Object i = pendingProcedures.pop();
            DFA dfa = (DFA)submodels.get(i);
            if (dfa == null) continue;
            Collection<I> newProcedures = SPAs.discoverAccessAndReturnSequences(alphabet, proceduralInputs, i, dfa, finishedProcedures, accessSequences, terminatingSequences, returnSequences);
            pendingProcedures.addAll(newProcedures);
        }
        return Pair.of(accessSequences, returnSequences);
    }

    private static <I> Collection<I> discoverAccessAndReturnSequences(ProceduralInputAlphabet<I> alphabet, Collection<I> proceduralInputs, I procedure, DFA<?, I> dfa, Set<I> finishedProcedures, Map<I, Word<I>> accessSequences, Map<I, Word<I>> terminatingSequences, Map<I, Word<I>> returnSequences) {
        ArrayList<Object> newASRS = new ArrayList<Object>();
        List<Word<Object>> acceptingPaths = SPAs.exploreAccessSequences(dfa, proceduralInputs, alphabet::isCallSymbol);
        block0: for (Word<Object> trace : acceptingPaths) {
            for (int i = 0; i < trace.length(); ++i) {
                Object input = trace.getSymbol(i);
                if (alphabet.isCallSymbol(input)) {
                    if (!finishedProcedures.contains(input)) {
                        Word<Object> remainingTrace = trace.subWord(i + 1);
                        for (Object r : remainingTrace) {
                            if (!alphabet.isCallSymbol(r) || terminatingSequences.containsKey(r)) continue;
                            continue block0;
                        }
                        Mapping<Object, Word> tsMapping = terminatingSequences::get;
                        WordBuilder<Object> accessBuilder = new WordBuilder<Object>();
                        @NonNull Word<I> as = accessSequences.get(procedure);
                        accessBuilder.append((Word<Object>)as);
                        accessBuilder.append(alphabet.expand(trace.subWord(0, i), tsMapping));
                        accessBuilder.append(input);
                        accessSequences.put(input, accessBuilder.toWord());
                        WordBuilder<Object> terminatingBuilder = new WordBuilder<Object>();
                        @NonNull Word<I> rs = returnSequences.get(procedure);
                        terminatingBuilder.append((Object)alphabet.getReturnSymbol());
                        terminatingBuilder.append(alphabet.expand(remainingTrace, tsMapping));
                        terminatingBuilder.append((Word<Object>)rs);
                        returnSequences.put(input, terminatingBuilder.toWord());
                        finishedProcedures.add(input);
                        newASRS.add(input);
                    } else if (!terminatingSequences.containsKey(input)) continue block0;
                }
                if (!finishedProcedures.containsAll(alphabet.getCallAlphabet())) continue;
                return newASRS;
            }
        }
        return newASRS;
    }

    private static <S, I> List<Word<I>> exploreAccessSequences(DFA<S, I> dfa, Collection<I> inputs, Predicate<I> callPredicate) {
        Object init = dfa.getInitialState();
        if (init == null) {
            return Collections.emptyList();
        }
        ArrayList<Word<I>> result = new ArrayList<Word<I>>(inputs.size());
        Graph tgv = dfa.transitionGraphView(inputs);
        APSPResult apsp = Graphs.findAPSP(tgv, edge -> 0.0f);
        ArrayList acceptingStates = new ArrayList(dfa.size());
        for (Object s : dfa) {
            if (!dfa.isAccepting(s)) continue;
            acceptingStates.add(s);
        }
        block1: for (Object i : inputs) {
            if (!callPredicate.test(i)) continue;
            for (Object s : dfa) {
                List<TransitionEdge> init2s;
                Object succ = dfa.getSuccessor(s, i);
                if (succ == null || (init2s = apsp.getShortestPath(init, s)) == null) continue;
                for (Object acc : acceptingStates) {
                    List<TransitionEdge> succ2acc = apsp.getShortestPath(succ, acc);
                    if (succ2acc == null) continue;
                    WordBuilder<Object> wb = new WordBuilder<Object>(init2s.size() + succ2acc.size() + 1);
                    for (TransitionEdge t : init2s) {
                        wb.append(t.getInput());
                    }
                    wb.append(i);
                    for (TransitionEdge t : succ2acc) {
                        wb.append(t.getInput());
                    }
                    result.add(wb.toWord());
                    continue block1;
                }
            }
        }
        return result;
    }

    public static <I> boolean isMinimal(SPA<?, I> spa) {
        return SPAs.isMinimal(spa, spa.getInputAlphabet());
    }

    public static <I> boolean isMinimal(SPA<?, I> spa, ProceduralInputAlphabet<I> alphabet) {
        return SPAs.isMinimal(alphabet, SPAs.computeATRSequences(spa, alphabet));
    }

    public static <I> boolean isMinimal(ProceduralInputAlphabet<I> alphabet, ATRSequences<I> atrSequences) {
        Alphabet callAlphabet = alphabet.getCallAlphabet();
        return atrSequences.accessSequences.keySet().containsAll(callAlphabet) && atrSequences.terminatingSequences.keySet().containsAll(callAlphabet) && atrSequences.returnSequences.keySet().containsAll(callAlphabet);
    }

    public static <I> boolean testEquivalence(SPA<?, I> spa1, SPA<?, I> spa2, ProceduralInputAlphabet<I> alphabet) {
        return SPAs.findSeparatingWord(spa1, spa2, alphabet) == null;
    }

    public static <I> @Nullable Word<I> findSeparatingWord(SPA<?, I> spa1, SPA<?, I> spa2, ProceduralInputAlphabet<I> alphabet) {
        ATRSequences<I> atr1 = SPAs.computeATRSequences(spa1, alphabet);
        ATRSequences<I> atr2 = SPAs.computeATRSequences(spa2, alphabet);
        for (Object procedure : alphabet.getCallAlphabet()) {
            Word rs;
            Word ts;
            Word as;
            DFA p1 = (DFA)spa1.getProcedure(procedure);
            DFA p2 = (DFA)spa2.getProcedure(procedure);
            if (p1 != null && p2 != null) {
                Word as1 = atr1.accessSequences.get(procedure);
                Word ts1 = atr1.terminatingSequences.get(procedure);
                Word rs1 = atr1.returnSequences.get(procedure);
                Word as2 = atr2.accessSequences.get(procedure);
                Word ts2 = atr2.terminatingSequences.get(procedure);
                Word rs2 = atr2.returnSequences.get(procedure);
                if (as1 != null && ts1 != null && rs1 != null && as2 != null && ts2 != null && rs2 != null) {
                    HashSet localAlphabet = new HashSet(atr1.terminatingSequences.keySet());
                    localAlphabet.retainAll(atr2.terminatingSequences.keySet());
                    localAlphabet.addAll(alphabet.getInternalAlphabet());
                    Word sepWord = Automata.findSeparatingWord(p1, p2, localAlphabet);
                    if (sepWord == null) continue;
                    ATRSequences<I> acceptingATR = p1.accepts(sepWord) ? atr1 : atr2;
                    Word as3 = acceptingATR.accessSequences.get(procedure);
                    Word<Object> ts3 = alphabet.expand(sepWord, acceptingATR.terminatingSequences::get);
                    Word rs3 = acceptingATR.returnSequences.get(procedure);
                    return Word.fromWords(as3, ts3, rs3);
                }
                if (as1 != null && ts1 != null && rs1 != null) {
                    return Word.fromWords(as1, ts1, rs1);
                }
                if (as2 == null || ts2 == null || rs2 == null) continue;
                return Word.fromWords(as2, ts2, rs2);
            }
            if (p1 != null) {
                as = atr1.accessSequences.get(procedure);
                ts = atr1.terminatingSequences.get(procedure);
                rs = atr1.returnSequences.get(procedure);
                if (as == null || ts == null || rs == null) continue;
                return Word.fromWords(as, ts, rs);
            }
            if (p2 == null) continue;
            as = atr2.accessSequences.get(procedure);
            ts = atr2.terminatingSequences.get(procedure);
            rs = atr2.returnSequences.get(procedure);
            if (as == null || ts == null || rs == null) continue;
            return Word.fromWords(as, ts, rs);
        }
        return null;
    }

    public static <I> OneSEVPA<?, I> toOneSEVPA(SPA<?, I> spa) {
        return OneSEVPAConverter.convert(spa);
    }

    public static <I> SEVPA<?, I> toNSEVPA(SPA<?, I> spa) {
        return NSEVPAConverter.convert(spa);
    }

    public static <I> ContextFreeModalProcessSystem<I, Void> toCFMPS(SPA<?, I> spa) {
        return new CFMPSViewSPA<I>(spa);
    }
}

