/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.automaton.procedural;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.BiPredicate;
import net.automatalib.alphabet.ProceduralInputAlphabet;
import net.automatalib.automaton.UniversalDeterministicAutomaton;
import net.automatalib.util.automaton.Automata;
import net.automatalib.util.automaton.cover.Covers;
import net.automatalib.util.automaton.procedural.ATSequences;
import net.automatalib.word.Word;
import net.automatalib.word.WordBuilder;
import org.checkerframework.checker.nullness.qual.Nullable;

final class ProceduralUtil {
    private ProceduralUtil() {
    }

    static <I, M extends UniversalDeterministicAutomaton<?, I, ?, ?, ?>> Map<I, Word<I>> computeTerminatingSequences(Map<I, ? extends M> procedures, ProceduralInputAlphabet<I> alphabet, BiPredicate<M, Word<I>> tracePredicate) {
        HashMap terminatingSequences = Maps.newHashMapWithExpectedSize((int)alphabet.getNumCalls());
        block0: for (Object procedure : alphabet.getCallAlphabet()) {
            UniversalDeterministicAutomaton p = (UniversalDeterministicAutomaton)procedures.get(procedure);
            if (p == null) continue;
            Iterator iter = Covers.stateCoverIterator(p, alphabet.getInternalAlphabet());
            while (iter.hasNext()) {
                Word trace = iter.next();
                if (!tracePredicate.test(p, trace)) continue;
                terminatingSequences.put(procedure, trace);
                continue block0;
            }
        }
        HashSet remainingProcedures = new HashSet(alphabet.getCallAlphabet());
        remainingProcedures.removeAll(terminatingSequences.keySet());
        HashSet eligibleInputs = new HashSet(alphabet.getInternalAlphabet());
        eligibleInputs.addAll(terminatingSequences.keySet());
        boolean stable = false;
        while (!stable) {
            stable = true;
            block3: for (Object i : new ArrayList(remainingProcedures)) {
                UniversalDeterministicAutomaton p = (UniversalDeterministicAutomaton)procedures.get(i);
                if (p == null) {
                    remainingProcedures.remove(i);
                    continue;
                }
                Iterator iter = Covers.stateCoverIterator(p, eligibleInputs);
                while (iter.hasNext()) {
                    Word trace = iter.next();
                    if (!tracePredicate.test(p, trace)) continue;
                    terminatingSequences.put(i, alphabet.expand(trace, terminatingSequences::get));
                    remainingProcedures.remove(i);
                    eligibleInputs.add(i);
                    stable = false;
                    continue block3;
                }
            }
        }
        return terminatingSequences;
    }

    static <I, M extends UniversalDeterministicAutomaton<?, I, ?, ?, ?>> Map<I, Word<I>> computeAccessSequences(Map<I, ? extends M> procedures, ProceduralInputAlphabet<I> alphabet, Collection<I> proceduralInputs, @Nullable I initialProcedure, Map<I, Word<I>> terminatingSequences, BiPredicate<M, Word<I>> transitionPredicate) {
        if (initialProcedure == null) {
            return Collections.emptyMap();
        }
        UniversalDeterministicAutomaton initialP = (UniversalDeterministicAutomaton)procedures.get(initialProcedure);
        if (initialP == null || initialP.getInitialState() == null) {
            return Collections.emptyMap();
        }
        HashMap accessSequences = Maps.newHashMapWithExpectedSize((int)alphabet.getNumCalls());
        HashSet finishedProcedures = Sets.newHashSetWithExpectedSize((int)alphabet.getNumCalls());
        accessSequences.put(initialProcedure, Word.fromLetter(initialProcedure));
        finishedProcedures.add(initialProcedure);
        ArrayDeque<I> pendingProcedures = new ArrayDeque<I>();
        pendingProcedures.add(initialProcedure);
        while (!pendingProcedures.isEmpty()) {
            Object i = pendingProcedures.pop();
            UniversalDeterministicAutomaton p = (UniversalDeterministicAutomaton)procedures.get(i);
            if (p == null) continue;
            Collection<I> newProcedures = ProceduralUtil.discoverAccessSequences(alphabet, proceduralInputs, i, p, finishedProcedures, accessSequences, terminatingSequences, transitionPredicate);
            pendingProcedures.addAll(newProcedures);
        }
        return accessSequences;
    }

    private static <I, M extends UniversalDeterministicAutomaton<?, I, ?, ?, ?>> Collection<I> discoverAccessSequences(ProceduralInputAlphabet<I> alphabet, Collection<I> proceduralInputs, I procedure, M p, Set<I> finishedProcedures, Map<I, Word<I>> accessSequences, Map<I, Word<I>> terminatingSequences, BiPredicate<M, Word<I>> predicate) {
        ArrayList<I> newAS = new ArrayList<I>();
        Iterator<Word<I>> transitionCoverIterator = Covers.transitionCoverIterator(p, proceduralInputs);
        while (transitionCoverIterator.hasNext()) {
            Word<I> trace = transitionCoverIterator.next();
            I sym = trace.lastSymbol();
            if (alphabet.isCallSymbol(sym)) {
                if (finishedProcedures.contains(sym) || !predicate.test(p, trace)) continue;
                WordBuilder<Object> accessBuilder = new WordBuilder<Object>();
                Word<I> as = accessSequences.get(procedure);
                accessBuilder.append((Word<Object>)as);
                accessBuilder.append(alphabet.expand(trace.prefix(-1), terminatingSequences::get));
                accessBuilder.append((Object)sym);
                accessSequences.put(sym, accessBuilder.toWord());
                finishedProcedures.add(sym);
                newAS.add(sym);
            }
            if (!finishedProcedures.containsAll(alphabet.getCallAlphabet())) continue;
            return newAS;
        }
        return newAS;
    }

    static <I, M extends UniversalDeterministicAutomaton<?, I, ?, ?, ?>> @Nullable Word<I> findSeparatingWord(Map<I, M> sys1, ATSequences<I> at1, Map<I, M> sys2, ATSequences<I> at2, ProceduralInputAlphabet<I> alphabet) {
        for (Object procedure : alphabet.getCallAlphabet()) {
            Word as;
            UniversalDeterministicAutomaton p1 = (UniversalDeterministicAutomaton)sys1.get(procedure);
            UniversalDeterministicAutomaton p2 = (UniversalDeterministicAutomaton)sys2.get(procedure);
            if (p1 != null && p2 != null) {
                Word as1 = at1.accessSequences.get(procedure);
                Word ts1 = at1.terminatingSequences.get(procedure);
                Word as2 = at2.accessSequences.get(procedure);
                Word ts2 = at2.terminatingSequences.get(procedure);
                if (as1 != null && as2 != null) {
                    if (ts1 == null && ts2 != null) {
                        return Word.fromWords(as2, ts2, Word.fromLetter(alphabet.getReturnSymbol()));
                    }
                    if (ts1 != null && ts2 == null) {
                        return Word.fromWords(as1, ts1, Word.fromLetter(alphabet.getReturnSymbol()));
                    }
                    Word<I> sepWord = Automata.findSeparatingWord(p1, p2, alphabet);
                    if (sepWord == null) continue;
                    Word as3 = at1.accessSequences.get(procedure);
                    Word<Object> expandedSepWord = alphabet.expand(sepWord.prefix(-1), at1.terminatingSequences::get);
                    return Word.fromWords(as3, expandedSepWord, Word.fromLetter(sepWord.lastSymbol()));
                }
                if (as1 == null && as2 != null) {
                    return as2;
                }
                if (as1 == null) continue;
                return as1;
            }
            if (!(p1 != null ? (as = at1.accessSequences.get(procedure)) != null : p2 != null && (as = at2.accessSequences.get(procedure)) != null)) continue;
            return as;
        }
        return null;
    }
}

