/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.automaton.procedural;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.automatalib.alphabet.ProceduralInputAlphabet;
import net.automatalib.automaton.fsa.DFA;
import net.automatalib.automaton.procedural.SBA;
import net.automatalib.graph.ContextFreeModalProcessSystem;
import net.automatalib.graph.ProceduralModalProcessGraph;
import net.automatalib.ts.modal.transition.ProceduralModalEdgeProperty;
import net.automatalib.util.automaton.procedural.PMPGEdge;
import org.checkerframework.checker.nullness.qual.Nullable;

class CFMPSViewSBA<I>
implements ContextFreeModalProcessSystem<I, Void> {
    private final SBA<?, I> sba;
    private final Map<I, ProceduralModalProcessGraph<?, I, ?, Void, ?>> pmpgs;

    CFMPSViewSBA(SBA<?, I> sba) {
        this.sba = sba;
        Map procedures = sba.getProcedures();
        this.pmpgs = Maps.newHashMapWithExpectedSize((int)procedures.size());
        for (Map.Entry e : procedures.entrySet()) {
            this.pmpgs.put(e.getKey(), new MPGView(sba, e.getKey(), (DFA)e.getValue()));
        }
    }

    @Override
    public Map<I, ProceduralModalProcessGraph<?, I, ?, Void, ?>> getPMPGs() {
        return this.pmpgs;
    }

    @Override
    public @Nullable I getMainProcess() {
        return this.sba.getInitialProcedure();
    }

    private static class MPGView<S, I>
    implements ProceduralModalProcessGraph<S, I, PMPGEdge<I, S>, Void, ProceduralModalEdgeProperty> {
        private static final Object INITIAL = new Object();
        private static final Object FINAL = new Object();
        private final ProceduralInputAlphabet<I> alphabet;
        private final Collection<I> proceduralInputs;
        private final I procedure;
        private final DFA<S, I> dfa;
        private final S dfaInit;
        private final S initialNode;
        private final S finalNode;
        private final List<S> nodes;

        MPGView(SBA<?, I> sba, I procedure, DFA<S, I> dfa) {
            ArrayList nodes;
            Object dfaInit = dfa.getInitialState();
            if (dfaInit == null) {
                throw new IllegalArgumentException("Empty DFAs cannot be mapped to ModalProcessGraphs");
            }
            this.alphabet = sba.getInputAlphabet();
            this.proceduralInputs = sba.getProceduralInputs();
            this.procedure = procedure;
            this.dfa = dfa;
            this.dfaInit = dfaInit;
            Object finalNode = null;
            for (Object s : dfa) {
                Object rSucc = dfa.getSuccessor(s, this.alphabet.getReturnSymbol());
                if (rSucc == null || !dfa.isAccepting(rSucc)) continue;
                finalNode = rSucc;
                break;
            }
            this.initialNode = INITIAL;
            if (finalNode == null) {
                this.finalNode = FINAL;
                nodes = new ArrayList(dfa.size() + 2);
                nodes.add(this.finalNode);
            } else {
                this.finalNode = finalNode;
                nodes = new ArrayList(dfa.size() + 1);
            }
            nodes.add(this.initialNode);
            for (Object s : dfa) {
                if (!dfa.isAccepting(s)) continue;
                nodes.add(s);
            }
            this.nodes = Collections.unmodifiableList(nodes);
        }

        @Override
        public Collection<PMPGEdge<I, S>> getOutgoingEdges(S node) {
            if (node == this.initialNode) {
                return Collections.singletonList(new PMPGEdge<I, S>(this.procedure, this.dfaInit, ProceduralModalEdgeProperty.ProceduralType.INTERNAL));
            }
            if (node == this.finalNode) {
                return Collections.emptyList();
            }
            ArrayList<PMPGEdge<I, S>> result = new ArrayList<PMPGEdge<I, S>>(this.proceduralInputs.size());
            for (I i : this.proceduralInputs) {
                S succ = this.dfa.getSuccessor(node, i);
                if (succ == null || !this.dfa.isAccepting(succ)) continue;
                ProceduralModalEdgeProperty.ProceduralType type = this.alphabet.isCallSymbol(i) ? ProceduralModalEdgeProperty.ProceduralType.PROCESS : ProceduralModalEdgeProperty.ProceduralType.INTERNAL;
                result.add(new PMPGEdge<I, S>(i, succ, type));
            }
            return result;
        }

        @Override
        public S getTarget(PMPGEdge<I, S> edge) {
            return edge.succ;
        }

        @Override
        public Collection<S> getNodes() {
            return this.nodes;
        }

        @Override
        public Set<Void> getNodeProperty(S node) {
            return Collections.emptySet();
        }

        @Override
        public ProceduralModalEdgeProperty getEdgeProperty(PMPGEdge<I, S> edge) {
            return edge;
        }

        @Override
        public I getEdgeLabel(PMPGEdge<I, S> edge) {
            return edge.input;
        }

        @Override
        public S getFinalNode() {
            return this.finalNode;
        }

        @Override
        public S getInitialNode() {
            return this.initialNode;
        }
    }
}

