/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.automaton.fsa;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import net.automatalib.alphabet.Alphabet;
import net.automatalib.automaton.concept.InputAlphabetHolder;
import net.automatalib.automaton.concept.StateIDs;
import net.automatalib.automaton.fsa.CompactDFA;
import net.automatalib.automaton.fsa.CompactNFA;
import net.automatalib.automaton.fsa.MutableDFA;
import net.automatalib.automaton.fsa.MutableNFA;
import net.automatalib.automaton.fsa.NFA;
import net.automatalib.ts.acceptor.AcceptorTS;
import net.automatalib.util.automaton.Automata;
import net.automatalib.util.ts.acceptor.AcceptanceCombiner;
import net.automatalib.util.ts.acceptor.Acceptors;
import net.automatalib.util.ts.copy.TSCopy;
import net.automatalib.util.ts.traversal.TSTraversalMethod;

public final class NFAs {
    private NFAs() {
    }

    public static <I> CompactNFA<I> combine(NFA<?, I> nfa1, NFA<?, I> nfa2, Alphabet<I> inputAlphabet, AcceptanceCombiner combiner) {
        return NFAs.combine(nfa1, nfa2, inputAlphabet, new CompactNFA<I>(inputAlphabet), combiner);
    }

    public static <I, S, A extends MutableNFA<S, I>> A combine(NFA<?, I> nfa1, NFA<?, I> nfa2, Collection<? extends I> inputs, A out, AcceptanceCombiner combiner) {
        AcceptorTS acc = Acceptors.combine(nfa1, nfa2, combiner);
        TSCopy.copy(TSTraversalMethod.DEPTH_FIRST, acc, -1, inputs, out);
        return out;
    }

    public static <I> CompactNFA<I> and(NFA<?, I> nfa1, NFA<?, I> nfa2, Alphabet<I> inputAlphabet) {
        return NFAs.and(nfa1, nfa2, inputAlphabet, new CompactNFA<I>(inputAlphabet));
    }

    public static <I, S, A extends MutableNFA<S, I>> A and(NFA<?, I> nfa1, NFA<?, I> nfa2, Collection<? extends I> inputs, A out) {
        return NFAs.combine(nfa1, nfa2, inputs, out, AcceptanceCombiner.AND);
    }

    public static <I> CompactNFA<I> or(NFA<?, I> nfa1, NFA<?, I> nfa2, Alphabet<I> inputAlphabet) {
        return NFAs.or(nfa1, nfa2, inputAlphabet, new CompactNFA<I>(inputAlphabet));
    }

    public static <I, S, A extends MutableNFA<S, I>> A or(NFA<?, I> nfa1, NFA<?, I> nfa2, Collection<? extends I> inputs, A out) {
        return NFAs.combine(nfa1, nfa2, inputs, out, AcceptanceCombiner.OR);
    }

    public static <I> CompactNFA<I> xor(NFA<?, I> nfa1, NFA<?, I> nfa2, Alphabet<I> inputAlphabet) {
        return NFAs.xor(nfa1, nfa2, inputAlphabet, new CompactNFA<I>(inputAlphabet));
    }

    public static <I, S, A extends MutableNFA<S, I>> A xor(NFA<?, I> nfa1, NFA<?, I> nfa2, Collection<? extends I> inputs, A out) {
        return NFAs.combine(nfa1, nfa2, inputs, out, AcceptanceCombiner.XOR);
    }

    public static <I> CompactNFA<I> equiv(NFA<?, I> nfa1, NFA<?, I> nfa2, Alphabet<I> inputAlphabet) {
        return NFAs.equiv(nfa1, nfa2, inputAlphabet, new CompactNFA<I>(inputAlphabet));
    }

    public static <I, S, A extends MutableNFA<S, I>> A equiv(NFA<?, I> nfa1, NFA<?, I> nfa2, Collection<? extends I> inputs, A out) {
        return NFAs.combine(nfa1, nfa2, inputs, out, AcceptanceCombiner.EQUIV);
    }

    public static <I> CompactNFA<I> impl(NFA<?, I> nfa1, NFA<?, I> nfa2, Alphabet<I> inputAlphabet) {
        return NFAs.impl(nfa1, nfa2, inputAlphabet, new CompactNFA<I>(inputAlphabet));
    }

    public static <I, S, A extends MutableNFA<S, I>> A impl(NFA<?, I> nfa1, NFA<?, I> nfa2, Collection<? extends I> inputs, A out) {
        return NFAs.combine(nfa1, nfa2, inputs, out, AcceptanceCombiner.IMPL);
    }

    public static <I> CompactDFA<I> determinize(NFA<?, I> nfa, Alphabet<I> inputAlphabet) {
        return NFAs.determinize(nfa, inputAlphabet, false, true);
    }

    public static <I> CompactDFA<I> determinize(NFA<?, I> nfa, Alphabet<I> inputAlphabet, boolean partial, boolean minimize) {
        CompactDFA<I> result = new CompactDFA<I>(inputAlphabet);
        NFAs.determinize(nfa, inputAlphabet, result, partial, minimize);
        return result;
    }

    public static <I> void determinize(NFA<?, I> nfa, Collection<? extends I> inputs, MutableDFA<?, I> out, boolean partial, boolean minimize) {
        NFAs.doDeterminize(nfa, inputs, out, partial);
        if (minimize) {
            Automata.invasiveMinimize(out, inputs);
        }
    }

    public static <I, A extends NFA<?, I> & InputAlphabetHolder<I>> CompactDFA<I> determinize(A nfa) {
        return NFAs.determinize(nfa, false, true);
    }

    public static <I, A extends NFA<?, I> & InputAlphabetHolder<I>> CompactDFA<I> determinize(A nfa, boolean partial, boolean minimize) {
        return NFAs.determinize(nfa, ((InputAlphabetHolder<I>)nfa).getInputAlphabet(), partial, minimize);
    }

    public static <I> void determinize(NFA<?, I> nfa, Collection<? extends I> inputs, MutableDFA<?, I> out) {
        NFAs.determinize(nfa, inputs, out, false, true);
    }

    private static <I, SI, SO> void doDeterminize(NFA<SI, I> nfa, Collection<? extends I> inputs, MutableDFA<SO, I> out, boolean partial) {
        HashMap<BitSet, Object> outStateMap = new HashMap<BitSet, Object>();
        StateIDs stateIds = nfa.stateIDs();
        ArrayDeque<DeterminizeRecord<Object, Object>> stack = new ArrayDeque<DeterminizeRecord<Object, Object>>();
        ArrayList initList = new ArrayList(nfa.getInitialStates());
        BitSet initBs = new BitSet();
        for (Object init : initList) {
            initBs.set(stateIds.getStateId(init));
        }
        boolean initAcc = nfa.isAccepting(initList);
        Object initOut = out.addInitialState(initAcc);
        outStateMap.put(initBs, initOut);
        stack.push(new DeterminizeRecord(initList, initOut));
        while (!stack.isEmpty()) {
            DeterminizeRecord curr = (DeterminizeRecord)stack.pop();
            List inStates = curr.inputStates;
            Object outState = curr.outputState;
            for (I sym : inputs) {
                BitSet succBs = new BitSet();
                ArrayList succList = new ArrayList();
                for (Object inState : inStates) {
                    for (Object succState : nfa.getSuccessors(inState, sym)) {
                        int succId = stateIds.getStateId(succState);
                        if (succBs.get(succId)) continue;
                        succBs.set(succId);
                        succList.add(succState);
                    }
                }
                if (partial && succList.isEmpty()) continue;
                Object outSucc = outStateMap.get(succBs);
                if (outSucc == null) {
                    outSucc = out.addState(nfa.isAccepting(succList));
                    outStateMap.put(succBs, outSucc);
                    stack.push(new DeterminizeRecord(succList, outSucc));
                }
                out.setTransition(outState, sym, outSucc);
            }
        }
    }

    private static final class DeterminizeRecord<SI, SO> {
        private final List<SI> inputStates;
        private final SO outputState;

        DeterminizeRecord(List<SI> inputStates, SO outputState) {
            this.inputStates = inputStates;
            this.outputState = outputState;
        }
    }
}

