/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.automaton.equivalence;

import com.google.common.collect.AbstractIterator;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import net.automatalib.automaton.UniversalDeterministicAutomaton;
import net.automatalib.automaton.fsa.FiniteStateAcceptor;
import net.automatalib.common.util.collection.CollectionsUtil;
import net.automatalib.util.automaton.Automata;
import net.automatalib.word.Word;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class CharacterizingSets {
    private CharacterizingSets() {
    }

    public static <I> void findCharacterizingSet(UniversalDeterministicAutomaton<?, I, ?, ?, ?> automaton, Collection<? extends I> inputs, Collection<? super Word<I>> result) {
        CharacterizingSets.findIncrementalCharacterizingSet(automaton, inputs, Collections.emptyList(), result);
    }

    public static <S, I> void findCharacterizingSet(UniversalDeterministicAutomaton<S, I, ?, ?, ?> automaton, Collection<? extends I> inputs, S state, Collection<? super Word<I>> result) {
        Object prop = automaton.getStateProperty(state);
        ArrayList currentBlock = new ArrayList();
        boolean multipleStateProps = false;
        for (Object s : automaton) {
            if (Objects.equals(s, state)) continue;
            Object sProp = automaton.getStateProperty(s);
            if (!Objects.equals(sProp, prop)) {
                multipleStateProps = true;
                continue;
            }
            currentBlock.add(s);
        }
        if (multipleStateProps) {
            result.add(Word.epsilon());
        }
        while (!currentBlock.isEmpty()) {
            Iterator it = currentBlock.iterator();
            Word<? extends I> suffix = null;
            while (it.hasNext() && suffix == null) {
                Object s = it.next();
                suffix = Automata.findSeparatingWord(automaton, state, s, inputs);
            }
            if (suffix == null) {
                return;
            }
            result.add(suffix);
            List<?> trace = CharacterizingSets.buildTrace(automaton, state, suffix);
            ArrayList nextBlock = new ArrayList();
            while (it.hasNext()) {
                Object s = it.next();
                if (!CharacterizingSets.checkTrace(automaton, s, suffix, trace)) continue;
                nextBlock.add(s);
            }
            currentBlock = nextBlock;
        }
    }

    public static <I> Iterator<Word<I>> characterizingSetIterator(UniversalDeterministicAutomaton<?, I, ?, ?, ?> automaton, Collection<? extends I> inputs) {
        return new IncrementalCharacterizingSetIterator(automaton, inputs, Collections.emptyList());
    }

    private static <S, I, T, SP, TP> List<?> buildTrace(UniversalDeterministicAutomaton<S, I, T, SP, TP> automaton, S state, Word<I> suffix) {
        if (suffix.isEmpty()) {
            Object prop = automaton.getStateProperty(state);
            return Collections.singletonList(prop);
        }
        ArrayList<@Nullable Object> trace = new ArrayList<Object>(2 * suffix.length());
        S curr = state;
        for (I sym : suffix) {
            Object trans = automaton.getTransition(curr, sym);
            if (trans == null) {
                return trace;
            }
            Object transitionProperty = automaton.getTransitionProperty(trans);
            trace.add(transitionProperty);
            curr = automaton.getSuccessor(trans);
            Object stateProperty = automaton.getStateProperty(curr);
            trace.add(stateProperty);
        }
        if (automaton instanceof FiniteStateAcceptor) {
            return trace.subList(trace.size() - 2, trace.size());
        }
        return trace;
    }

    private static <S, I, T, SP, TP, P> boolean checkTrace(UniversalDeterministicAutomaton<S, I, T, SP, TP> automaton, S state, Word<I> suffix, List<P> trace) {
        Iterator<P> it = trace.iterator();
        S curr = state;
        for (I sym : suffix) {
            Object trans = automaton.getTransition(curr, sym);
            if (!it.hasNext()) {
                return trans == null;
            }
            if (trans == null) {
                return false;
            }
            Object transitionProperty = automaton.getTransitionProperty(trans);
            if (!Objects.equals(transitionProperty, it.next())) {
                return false;
            }
            curr = automaton.getSuccessor(trans);
            Object stateProperty = automaton.getStateProperty(curr);
            if (Objects.equals(stateProperty, it.next())) continue;
            return false;
        }
        return true;
    }

    public static <S, I> boolean findIncrementalCharacterizingSet(UniversalDeterministicAutomaton<S, I, ?, ?, ?> automaton, Collection<? extends I> inputs, Collection<? extends Word<I>> oldSuffixes, Collection<? super Word<I>> newSuffixes) {
        Word<? extends I> suffix;
        boolean refined = false;
        List<? extends Word<I>> oldSuffixList = CollectionsUtil.randomAccessList(oldSuffixes);
        Queue<List<S>> blocks = CharacterizingSets.buildInitialBlocks(automaton, oldSuffixList);
        if (!oldSuffixes.contains(Word.epsilon()) && CharacterizingSets.epsilonRefine(automaton, blocks)) {
            newSuffixes.add(Word.epsilon());
            refined = true;
        }
        while ((suffix = CharacterizingSets.refine(automaton, inputs, blocks)) != null) {
            newSuffixes.add(suffix);
            refined = true;
        }
        return refined;
    }

    public static <I> Iterator<Word<I>> incrementalCharacterizingSetIterator(UniversalDeterministicAutomaton<?, I, ?, ?, ?> automaton, Collection<? extends I> inputs, Collection<? extends Word<I>> oldSuffixes) {
        return new IncrementalCharacterizingSetIterator(automaton, inputs, oldSuffixes);
    }

    private static <S, I> Queue<List<S>> buildInitialBlocks(UniversalDeterministicAutomaton<S, I, ?, ?, ?> automaton, List<? extends Word<I>> oldSuffixes) {
        HashMap initialPartitioning = new HashMap();
        ArrayDeque<List<S>> blocks = new ArrayDeque<List<S>>();
        for (Object state : automaton) {
            List<List<?>> sig = CharacterizingSets.buildSignature(automaton, oldSuffixes, state);
            ArrayList block = (ArrayList)initialPartitioning.get(sig);
            if (block == null) {
                block = new ArrayList();
                blocks.add(block);
                initialPartitioning.put(sig, block);
            }
            block.add(state);
        }
        return blocks;
    }

    private static <S, I> List<List<?>> buildSignature(UniversalDeterministicAutomaton<S, I, ?, ?, ?> automaton, List<? extends Word<I>> suffixes, S state) {
        ArrayList signature = new ArrayList(suffixes.size());
        for (Word<I> suffix : suffixes) {
            List<?> trace = CharacterizingSets.buildTrace(automaton, state, suffix);
            signature.add(trace);
        }
        return signature;
    }

    private static <S, I> boolean epsilonRefine(UniversalDeterministicAutomaton<S, I, ?, ?, ?> automaton, Queue<List<S>> blockQueue) {
        int initialSize = blockQueue.size();
        boolean refined = false;
        for (int i = 0; i < initialSize; ++i) {
            @NonNull List<S> block = blockQueue.poll();
            if (block.size() <= 1) continue;
            Map<?, List<S>> propCluster = CharacterizingSets.clusterByProperty(automaton, block);
            if (propCluster.size() > 1) {
                refined = true;
            }
            blockQueue.addAll(propCluster.values());
        }
        return refined;
    }

    private static <S, I> @Nullable Word<I> refine(UniversalDeterministicAutomaton<S, I, ?, ?, ?> automaton, Collection<? extends I> inputs, Queue<List<S>> blockQueue) {
        List<S> currBlock;
        while ((currBlock = blockQueue.poll()) != null) {
            if (currBlock.size() <= 1) continue;
            Iterator<S> it = currBlock.iterator();
            S ref = it.next();
            Word<? extends I> suffix = null;
            S state = null;
            while (it.hasNext() && suffix == null) {
                state = it.next();
                suffix = Automata.findSeparatingWord(automaton, ref, state, inputs);
            }
            if (state == null || suffix == null) continue;
            int otherBlocks = blockQueue.size();
            HashMap buckets = new HashMap();
            ArrayList<S> firstBucket = new ArrayList<S>();
            ArrayList<S> secondBucket = new ArrayList<S>();
            firstBucket.add(ref);
            buckets.put(CharacterizingSets.buildTrace(automaton, ref, suffix), firstBucket);
            secondBucket.add(state);
            buckets.put(CharacterizingSets.buildTrace(automaton, state, suffix), secondBucket);
            CharacterizingSets.cluster(automaton, suffix, it, buckets);
            blockQueue.addAll(buckets.values());
            for (int i = 0; i < otherBlocks; ++i) {
                @NonNull List<S> otherBlock = blockQueue.poll();
                if (otherBlock.size() <= 1) continue;
                buckets.clear();
                CharacterizingSets.cluster(automaton, suffix, otherBlock.iterator(), buckets);
                blockQueue.addAll(buckets.values());
            }
            return suffix;
        }
        return null;
    }

    private static <S, I, SP> Map<?, List<S>> clusterByProperty(UniversalDeterministicAutomaton<S, I, ?, SP, ?> automaton, List<S> states) {
        HashMap<Object, List> result = new HashMap<Object, List>();
        for (S state : states) {
            Object prop = automaton.getStateProperty(state);
            List block = result.computeIfAbsent(prop, k -> new ArrayList());
            block.add(state);
        }
        return result;
    }

    private static <S, I> void cluster(UniversalDeterministicAutomaton<S, I, ?, ?, ?> automaton, Word<I> suffix, Iterator<S> stateIt, Map<List<?>, List<S>> bucketMap) {
        while (stateIt.hasNext()) {
            S state = stateIt.next();
            List<?> trace = CharacterizingSets.buildTrace(automaton, state, suffix);
            List bucket = bucketMap.computeIfAbsent(trace, k -> new ArrayList());
            bucket.add(state);
        }
    }

    private static class IncrementalCharacterizingSetIterator<S, I>
    extends AbstractIterator<Word<I>> {
        private final UniversalDeterministicAutomaton<S, I, ?, ?, ?> automaton;
        private final Collection<? extends I> inputs;
        private final List<? extends Word<I>> oldSuffixes;
        private Queue<List<S>> blocks;

        IncrementalCharacterizingSetIterator(UniversalDeterministicAutomaton<S, I, ?, ?, ?> automaton, Collection<? extends I> inputs, Collection<? extends Word<I>> oldSuffixes) {
            this.automaton = automaton;
            this.inputs = inputs;
            this.oldSuffixes = CollectionsUtil.randomAccessList(oldSuffixes);
        }

        protected Word<I> computeNext() {
            Word suffix;
            if (this.blocks == null) {
                this.blocks = CharacterizingSets.buildInitialBlocks(this.automaton, this.oldSuffixes);
                if (!this.oldSuffixes.contains(Word.epsilon()) && CharacterizingSets.epsilonRefine(this.automaton, this.blocks)) {
                    return Word.epsilon();
                }
            }
            if ((suffix = CharacterizingSets.refine(this.automaton, this.inputs, this.blocks)) != null) {
                return suffix;
            }
            return (Word)this.endOfData();
        }
    }
}

