/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.automaton.equivalence;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import net.automatalib.automaton.Automaton;
import net.automatalib.common.util.Pair;

public final class Bisimulation {
    private Bisimulation() {
    }

    public static <AS, I, AT, A extends Automaton<AS, I, AT>, BS, BT, B extends Automaton<BS, I, BT>> Set<Pair<AS, BS>> bisimulationEquivalenceRelation(A a, B b, Collection<I> inputs) {
        HashSet bisim = Sets.newHashSetWithExpectedSize((int)(a.size() * b.size()));
        HashSet change = Sets.newHashSetWithExpectedSize((int)(a.size() * b.size()));
        for (Object p : a.getStates()) {
            for (Object q : b.getStates()) {
                boolean empty = true;
                for (I sym : inputs) {
                    empty &= a.getTransitions(p, sym).isEmpty() && b.getTransitions(q, sym).isEmpty();
                    if (a.getTransitions(p, sym).isEmpty() || b.getTransitions(q, sym).isEmpty()) continue;
                    change.add(Pair.of(p, q));
                    break;
                }
                if (!empty) continue;
                change.add(Pair.of(p, q));
            }
        }
        while (!bisim.equals(change)) {
            HashSet swap = change;
            change = bisim;
            bisim = swap;
            change.clear();
            for (Pair p : bisim) {
                boolean exists;
                boolean forall = true;
                block5: for (I sym : inputs) {
                    for (Object t : a.getTransitions(p.getFirst(), sym)) {
                        exists = false;
                        for (Object f : b.getTransitions(p.getSecond(), sym)) {
                            for (Pair s : bisim) {
                                if (!Objects.equals(a.getSuccessor(t), s.getFirst()) || !Objects.equals(b.getSuccessor(f), s.getSecond())) continue;
                                exists = true;
                                break;
                            }
                            if (!exists) continue;
                            break;
                        }
                        if (exists) continue;
                        forall = false;
                        continue block5;
                    }
                }
                if (!forall) continue;
                block9: for (I sym : inputs) {
                    for (Object f : b.getTransitions(p.getSecond(), sym)) {
                        exists = false;
                        for (Object t : a.getTransitions(p.getFirst(), sym)) {
                            for (Pair s : bisim) {
                                if (!Objects.equals(b.getSuccessor(f), s.getSecond()) || !Objects.equals(a.getSuccessor(t), s.getFirst())) continue;
                                exists = true;
                                break;
                            }
                            if (!exists) continue;
                            break;
                        }
                        if (exists) continue;
                        forall = false;
                        continue block9;
                    }
                }
                if (!forall) continue;
                change.add(p);
            }
        }
        return change;
    }
}

