/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.automaton.cover;

import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Sets;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Iterator;
import java.util.Queue;
import net.automatalib.automaton.DeterministicAutomaton;
import net.automatalib.common.util.mapping.MutableMapping;
import net.automatalib.util.automaton.cover.Covers;
import net.automatalib.util.automaton.cover.Record;
import net.automatalib.word.Word;
import org.checkerframework.checker.nullness.qual.Nullable;

class IncrementalTransitionCoverIterator<S, I>
extends AbstractIterator<Word<I>> {
    private final DeterministicAutomaton<S, I, ?> automaton;
    private final Collection<? extends I> inputs;
    private final Collection<? extends Word<I>> oldCover;
    private final MutableMapping<S, @Nullable Record<S, I>> reach;
    private final Queue<Record<S, I>> bfsQueue;
    private Iterator<? extends I> inputIterator;
    private Record<S, I> curr;

    IncrementalTransitionCoverIterator(DeterministicAutomaton<S, I, ?> automaton, Collection<? extends I> inputs, Collection<? extends Word<I>> oldCover) {
        this.automaton = automaton;
        this.inputs = inputs;
        this.oldCover = oldCover;
        this.reach = automaton.createStaticStateMapping();
        this.bfsQueue = new ArrayDeque<Record<S, I>>();
    }

    protected Word<I> computeNext() {
        if (this.inputIterator == null) {
            Object init = this.automaton.getInitialState();
            if (init == null) {
                return (Word)this.endOfData();
            }
            this.initialize(init);
            this.curr = this.bfsQueue.poll();
            this.inputIterator = this.inputs.iterator();
        }
        while (this.curr != null) {
            while (this.inputIterator.hasNext()) {
                Object succ;
                I in = this.inputIterator.next();
                if (!this.curr.coveredInputs.add(in) || (succ = this.automaton.getSuccessor(this.curr.state, in)) == null) continue;
                Word succAs = this.curr.accessSequence.append(in);
                if (this.reach.get(succ) == null) {
                    Record succRec = new Record(succ, succAs, Sets.newHashSetWithExpectedSize((int)this.inputs.size()));
                    this.reach.put(succ, succRec);
                    this.bfsQueue.add(succRec);
                }
                return succAs;
            }
            this.curr = this.bfsQueue.poll();
            this.inputIterator = this.inputs.iterator();
        }
        return (Word)this.endOfData();
    }

    private void initialize(S init) {
        Record initRec = new Record(init, Word.epsilon(), Sets.newHashSetWithExpectedSize((int)this.inputs.size()));
        this.reach.put(init, initRec);
        this.bfsQueue.add(initRec);
        Covers.buildReachFromTransitionCover(this.reach, this.bfsQueue, this.automaton, this.oldCover, (s, as) -> new Record(s, as, Sets.newHashSetWithExpectedSize((int)this.inputs.size())), w -> {});
    }
}

