/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.automaton.conformance;

import com.google.common.collect.Iterators;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.automatalib.automaton.UniversalDeterministicAutomaton;
import net.automatalib.common.util.collection.AbstractThreeLevelIterator;
import net.automatalib.common.util.collection.CollectionsUtil;
import net.automatalib.common.util.collection.ReusableIterator;
import net.automatalib.util.automaton.cover.Covers;
import net.automatalib.util.automaton.equivalence.CharacterizingSets;
import net.automatalib.word.Word;
import net.automatalib.word.WordBuilder;

public class WMethodTestsIterator<I>
extends AbstractThreeLevelIterator<Word<I>, List<I>, Word<I>, Word<I>> {
    private final Collection<? extends I> inputs;
    private final int maxDepth;
    private final Iterable<Word<I>> suffixes;

    public WMethodTestsIterator(UniversalDeterministicAutomaton<?, I, ?, ?, ?> automaton, Collection<? extends I> inputs) {
        this(automaton, inputs, 0);
    }

    public WMethodTestsIterator(UniversalDeterministicAutomaton<?, I, ?, ?, ?> automaton, Collection<? extends I> inputs, int maxDepth) {
        super(Iterators.concat((Iterator)Iterators.singletonIterator(Word.epsilon()), Covers.transitionCoverIterator(automaton, inputs)));
        this.inputs = inputs;
        this.maxDepth = maxDepth;
        Iterator<Word<I>> characterizingSet = CharacterizingSets.characterizingSetIterator(automaton, inputs);
        this.suffixes = !characterizingSet.hasNext() ? Collections.singletonList(Word.epsilon()) : new ReusableIterator<Word<I>>(characterizingSet);
    }

    @Override
    protected Iterator<List<I>> l2Iterator(Word<I> l1Object) {
        return CollectionsUtil.allTuples(this.inputs, 0, this.maxDepth).iterator();
    }

    @Override
    protected Iterator<Word<I>> l3Iterator(Word<I> prefix, List<I> middle) {
        return this.suffixes.iterator();
    }

    @Override
    protected Word<I> combine(Word<I> prefix, List<I> middle, Word<I> suffix) {
        WordBuilder<I> wb = new WordBuilder<I>(prefix.size() + middle.size() + suffix.size());
        return wb.append(prefix).append(middle).append(suffix).toWord();
    }
}

