/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.automaton.conformance;

import com.google.common.collect.Iterators;
import java.util.AbstractQueue;
import java.util.Comparator;
import java.util.Iterator;
import net.automatalib.common.smartcollection.ResizingArrayStorage;
import org.checkerframework.checker.nullness.qual.Nullable;

class StrictPriorityQueue<E>
extends AbstractQueue<E> {
    private final ResizingArrayStorage<E> storage = new ResizingArrayStorage<Object>(Object.class);
    private final Comparator<? super E> comparator;
    private final MergeOperation<E> mergeOp;
    private int size;

    StrictPriorityQueue(Comparator<? super E> comparator, MergeOperation<E> mergeOp) {
        this.comparator = comparator;
        this.mergeOp = mergeOp;
    }

    @Override
    public boolean offer(E e) {
        this.storage.ensureCapacity(this.size + 1);
        this.storage.array[this.size++] = e;
        if (!this.upHeap()) {
            --this.size;
            return false;
        }
        return true;
    }

    private boolean upHeap() {
        int currIdx = this.size - 1;
        Object elem = this.storage.array[currIdx];
        int steps = 0;
        while (currIdx > 0) {
            int parentIdx = currIdx / 2;
            Object parent = this.storage.array[parentIdx];
            int cmp = this.comparator.compare(elem, parent);
            if (cmp == 0) {
                this.storage.array[parentIdx] = this.mergeOp.merge(parent, elem);
                return false;
            }
            if (cmp > 0) break;
            currIdx = parentIdx;
            ++steps;
        }
        currIdx = this.size - 1;
        for (int i = 0; i < steps; ++i) {
            int parentIdx = currIdx / 2;
            this.storage.array[currIdx] = this.storage.array[parentIdx];
            currIdx = parentIdx;
        }
        this.storage.array[currIdx] = elem;
        return true;
    }

    @Override
    public @Nullable E poll() {
        if (this.size == 0) {
            return null;
        }
        Object result = this.storage.array[0];
        --this.size;
        if (this.size > 0) {
            this.storage.array[0] = this.storage.array[this.size];
            this.downHeap();
        }
        this.storage.array[this.size] = null;
        return (E)result;
    }

    private void downHeap() {
        Object elem = this.storage.array[0];
        int currIdx = 0;
        while (2 * currIdx + 1 < this.size) {
            Object rightChild;
            int childIdx = 2 * currIdx + 1;
            Object child = this.storage.array[childIdx];
            int rightChildIdx = childIdx + 1;
            if (rightChildIdx < this.size && this.comparator.compare(child, rightChild = this.storage.array[rightChildIdx]) > 0) {
                child = rightChild;
                childIdx = rightChildIdx;
            }
            if (this.comparator.compare(elem, child) > 0) {
                this.storage.array[currIdx] = child;
                this.storage.array[childIdx] = elem;
                currIdx = childIdx;
                continue;
            }
            return;
        }
    }

    @Override
    public @Nullable E peek() {
        if (this.size == 0) {
            return null;
        }
        return (E)this.storage.array[0];
    }

    @Override
    public Iterator<E> iterator() {
        return Iterators.forArray((Object[])this.storage.array);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    public static interface MergeOperation<E> {
        public E merge(E var1, E var2);
    }
}

