/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.automaton.conformance;

import com.google.common.collect.Iterators;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.automatalib.alphabet.ProceduralInputAlphabet;
import net.automatalib.automaton.UniversalDeterministicAutomaton;
import net.automatalib.common.util.collection.AbstractThreeLevelIterator;
import net.automatalib.common.util.collection.AbstractTwoLevelIterator;
import net.automatalib.common.util.collection.CollectionsUtil;
import net.automatalib.common.util.collection.ReusableIterator;
import net.automatalib.util.automaton.cover.Covers;
import net.automatalib.util.automaton.equivalence.CharacterizingSets;
import net.automatalib.util.automaton.procedural.ATSequences;
import net.automatalib.word.Word;
import net.automatalib.word.WordBuilder;
import org.checkerframework.checker.nullness.qual.NonNull;

class ProceduralWMethodTestsIterator<I, M extends UniversalDeterministicAutomaton<?, I, ?, ?, ?>>
extends AbstractTwoLevelIterator<I, Word<I>, Word<I>> {
    private static final List<List<Word<?>>> EPSILON = Collections.singletonList(Collections.singletonList(Word.epsilon()));
    private final ProceduralInputAlphabet<I> alphabet;
    private final Collection<I> proceduralInputs;
    private final Map<I, M> procedures;
    private final ATSequences<I> atSequences;
    private final int maxDepth;
    private final List<I> continuableSymbols;
    private final List<Word<I>> continuableWords;
    private final List<Word<I>> nonContinuableWords;

    ProceduralWMethodTestsIterator(ProceduralInputAlphabet<I> alphabet, Collection<I> proceduralInputs, Map<I, M> procedures, ATSequences<I> atSequences, int maxDepth) {
        super(atSequences.accessSequences.keySet().iterator());
        this.alphabet = alphabet;
        this.proceduralInputs = proceduralInputs;
        this.procedures = procedures;
        this.atSequences = atSequences;
        this.maxDepth = maxDepth;
        this.continuableSymbols = new ArrayList<I>(alphabet.size() - 1);
        this.continuableWords = new ArrayList<Word<I>>(alphabet.size());
        this.nonContinuableWords = new ArrayList<Word<I>>(alphabet.getNumCalls() + 1);
        this.continuableSymbols.addAll(alphabet.getInternalAlphabet());
        for (Object i : alphabet.getInternalAlphabet()) {
            this.continuableWords.add(Word.fromLetter(i));
        }
        this.continuableWords.add(Word.epsilon());
        for (Object i : alphabet.getCallAlphabet()) {
            if (this.atSequences.terminatingSequences.containsKey(i)) {
                this.continuableSymbols.add(i);
                this.continuableWords.add(Word.fromLetter(i));
                continue;
            }
            this.nonContinuableWords.add(Word.fromLetter(i));
        }
        this.nonContinuableWords.add(Word.fromLetter(alphabet.getReturnSymbol()));
    }

    @Override
    protected Iterator<Word<I>> l2Iterator(I callSymbol) {
        @NonNull UniversalDeterministicAutomaton p = (UniversalDeterministicAutomaton)this.procedures.get(callSymbol);
        return this.proceduralTestWords(p);
    }

    @Override
    protected Word<I> combine(I callSymbol, Word<I> testSequence) {
        @NonNull Word<I> as = this.atSequences.accessSequences.get(callSymbol);
        if (testSequence.isEmpty()) {
            return as;
        }
        Word<Object> exp = this.alphabet.expand(testSequence.prefix(-1), this.atSequences.terminatingSequences::get);
        return Word.fromWords(as, exp, Word.fromLetter(testSequence.lastSymbol()));
    }

    private Iterator<Word<I>> proceduralTestWords(M automaton) {
        ReusableIterator<Word<I>> sCov = new ReusableIterator<Word<I>>(Covers.stateCoverIterator(automaton, this.continuableSymbols));
        Iterator<Word<I>> cSet = CharacterizingSets.characterizingSetIterator(automaton, this.proceduralInputs);
        ContinuableIterator continuableIter = new ContinuableIterator(sCov, cSet);
        NonContinuableIterator nonContinuableIter = new NonContinuableIterator(sCov);
        return Iterators.concat((Iterator)nonContinuableIter, (Iterator)continuableIter);
    }

    private class NonContinuableIterator
    extends AbstractTwoLevelIterator<Word<I>, Word<I>, Word<I>> {
        NonContinuableIterator(Iterable<Word<I>> sCov) {
            super(sCov.iterator());
        }

        @Override
        protected Iterator<Word<I>> l2Iterator(Word<I> sCov) {
            return ProceduralWMethodTestsIterator.this.nonContinuableWords.iterator();
        }

        @Override
        protected Word<I> combine(Word<I> sCov, Word<I> nonCon) {
            return sCov.concat(nonCon);
        }
    }

    private class ContinuableIterator
    extends AbstractThreeLevelIterator<Word<I>, List<Word<I>>, List<I>, Word<I>> {
        private final Iterable<Word<I>> sCov;

        ContinuableIterator(Iterable<Word<I>> sCov, Iterator<Word<I>> cSet) {
            super(cSet);
            this.sCov = sCov;
        }

        @Override
        protected Iterator<List<Word<I>>> l2Iterator(Word<I> cSet) {
            Iterator epsilon = EPSILON.iterator();
            return Iterators.concat(epsilon, CollectionsUtil.cartesianProduct(this.sCov, ProceduralWMethodTestsIterator.this.continuableWords).iterator());
        }

        @Override
        protected Iterator<List<I>> l3Iterator(Word<I> cSet, List<Word<I>> tCov) {
            return CollectionsUtil.allTuples(ProceduralWMethodTestsIterator.this.continuableSymbols, 0, ProceduralWMethodTestsIterator.this.maxDepth).iterator();
        }

        @Override
        protected Word<I> combine(Word<I> cSet, List<Word<I>> tCov, List<I> tuples) {
            WordBuilder wb = new WordBuilder();
            for (Word w : tCov) {
                wb.append(w);
            }
            wb.append(tuples);
            wb.append(cSet);
            return wb.toWord();
        }
    }
}

