/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.automaton.ads;

import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import net.automatalib.alphabet.Alphabet;
import net.automatalib.automaton.transducer.MealyMachine;
import net.automatalib.common.smartcollection.ReflexiveMapView;
import net.automatalib.common.util.Pair;
import net.automatalib.graph.ads.ADSLeafNode;
import net.automatalib.graph.ads.ADSNode;
import net.automatalib.util.automaton.Automata;
import net.automatalib.util.automaton.ads.ADSUtil;
import net.automatalib.util.automaton.ads.SplitTree;
import net.automatalib.word.Word;

public final class StateEquivalence {
    private StateEquivalence() {
    }

    public static <S, I, O> Optional<ADSNode<S, I, O>> compute(MealyMachine<S, I, ?, O> automaton, Alphabet<I> input, Set<S> states) {
        if (states.size() != 2) {
            throw new IllegalArgumentException("StateEquivalence can only distinguish 2 states");
        }
        SplitTree node = new SplitTree(states, new ReflexiveMapView<S>(states));
        return StateEquivalence.compute(automaton, input, node);
    }

    static <S, I, O> Optional<ADSNode<S, I, O>> compute(MealyMachine<S, I, ?, O> automaton, Alphabet<I> input, SplitTree<S, I, O> node) {
        S s2;
        Iterator<S> targetStateIterator = node.getPartition().iterator();
        S s1 = targetStateIterator.next();
        Word<I> separatingWord = Automata.findSeparatingWord(automaton, s1, s2 = targetStateIterator.next(), input);
        if (separatingWord == null) {
            return Optional.empty();
        }
        Object s1Output = automaton.computeStateOutput((Object)s1, (Iterable)separatingWord);
        Object s2Output = automaton.computeStateOutput((Object)s2, (Iterable)separatingWord);
        Word sharedOutput = ((Word)s1Output).longestCommonPrefix((Word<?>)s2Output);
        Word<I> trace = separatingWord.prefix(sharedOutput.length() + 1);
        Pair<ADSNode<S, I, O>, ADSNode<S, I, O>> ads = ADSUtil.buildFromTrace(automaton, trace, s1);
        ADSNode<S, I, O> head = ads.getFirst();
        ADSNode<S, I, O> tail = ads.getSecond();
        ADSLeafNode<S, I, O> s1FinalNode = new ADSLeafNode<S, I, O>(tail, node.getMapping().get(s1));
        ADSLeafNode<S, I, O> s2FinalNode = new ADSLeafNode<S, I, O>(tail, node.getMapping().get(s2));
        tail.getChildren().put(((Word)s1Output).getSymbol(sharedOutput.length()), s1FinalNode);
        tail.getChildren().put(((Word)s2Output).getSymbol(sharedOutput.length()), s2FinalNode);
        return Optional.of(head);
    }
}

