/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.automaton.ads;

import com.google.common.collect.HashBiMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.automatalib.alphabet.Alphabet;
import net.automatalib.automaton.transducer.MealyMachine;
import net.automatalib.common.smartcollection.ReflexiveMapView;
import net.automatalib.common.util.Pair;
import net.automatalib.graph.CompactSimpleGraph;
import net.automatalib.graph.ads.ADSLeafNode;
import net.automatalib.graph.ads.ADSNode;
import net.automatalib.graph.base.CompactEdge;
import net.automatalib.util.automaton.ads.ADSUtil;
import net.automatalib.util.automaton.ads.LYResult;
import net.automatalib.util.automaton.ads.SplitTree;
import net.automatalib.util.automaton.ads.SplitTreeResult;
import net.automatalib.util.graph.Path;
import net.automatalib.util.graph.ShortestPaths;
import net.automatalib.util.graph.traversal.GraphTraversal;
import net.automatalib.word.Word;

public final class LeeYannakakis {
    private LeeYannakakis() {
    }

    public static <S, I, O> LYResult<S, I, O> compute(MealyMachine<S, I, ?, O> automaton, Alphabet<I> input) {
        SplitTreeResult<S, I, O> str = LeeYannakakis.computeSplitTree(automaton, input);
        if (str.isPresent()) {
            HashSet states = new HashSet(automaton.getStates());
            return new LYResult<S, I, O>(LeeYannakakis.extractADS(automaton, str.get(), states, new ReflexiveMapView(states), null));
        }
        return new LYResult(str.getIndistinguishableStates());
    }

    private static <S, I, O> SplitTreeResult<S, I, O> computeSplitTree(MealyMachine<S, I, ?, O> automaton, Alphabet<I> input) {
        SplitTree st = new SplitTree(new HashSet(automaton.getStates()));
        HashSet leaves = Sets.newHashSetWithExpectedSize((int)automaton.size());
        leaves.add(st);
        while (leaves.stream().anyMatch(LeeYannakakis::needsRefinement)) {
            SplitTree newChild;
            Set indistinguishableNodes;
            HashSet<Object> intersection;
            Set<Object> wSet;
            Map successorsToNodes;
            SplitTree<Map.Entry<Object, Set<Object>>, Word<Object>, O> nodeToRefine;
            int maxCardinality = leaves.stream().mapToInt(x -> x.getPartition().size()).max().orElseThrow(IllegalStateException::new);
            Set<SplitTree<S, I, O>> r = leaves.stream().filter(x -> x.getPartition().size() == maxCardinality).collect(Collectors.toSet());
            Map<Validity, Set<Pair<Word<Word<I>>, SplitTree<Map.Entry<Object, Set<Object>>, Word<I>, O>>>> validitySetMap = LeeYannakakis.computeValidities(automaton, input, r, leaves);
            if (!validitySetMap.get((Object)Validity.INVALID).isEmpty()) {
                Set<Pair<Word<Word<I>>, SplitTree<Map.Entry<Object, Set<Object>>, Word<I>, O>>> set = validitySetMap.get((Object)Validity.INVALID);
                HashSet<Map.Entry<Object, Set<Object>>> indistinguishableStates = new HashSet<Map.Entry<Object, Set<Object>>>();
                for (Pair<Word<Word<I>>, SplitTree<Map.Entry<Object, Set<Object>>, Word<I>, O>> pair : set) {
                    indistinguishableStates.addAll(pair.getSecond().getPartition());
                }
                return new SplitTreeResult(indistinguishableStates);
            }
            for (Pair<Word<Word<I>>, SplitTree<Map.Entry<Object, Set<Object>>, Word<I>, O>> aPartition : validitySetMap.get((Object)Validity.A_VALID)) {
                assert (aPartition.getFirst().size() == 1) : "a-valid inputs should always contain exactly 1 symbol";
                Word<I> aValidInput = aPartition.getFirst().firstSymbol();
                nodeToRefine = aPartition.getSecond();
                Map successorMap = nodeToRefine.getPartition().stream().collect(Collectors.groupingBy(s -> automaton.getOutput((Map.Entry<Object, Set<Object>>)s, (Word)aValidInput), Collectors.toSet()));
                nodeToRefine.setSequence(Word.fromSymbols(aValidInput));
                leaves.remove(nodeToRefine);
                for (Map.Entry entry : successorMap.entrySet()) {
                    SplitTree splitTree = new SplitTree(entry.getValue());
                    nodeToRefine.getSuccessors().put(entry.getKey(), splitTree);
                    leaves.add(splitTree);
                }
                for (Map.Entry<Object, Set<Object>> s2 : nodeToRefine.getPartition()) {
                    nodeToRefine.getMapping().put(s2, automaton.getSuccessor(s2, aValidInput));
                }
            }
            for (Pair<Word<Word<I>>, SplitTree<Map.Entry<Object, Set<Object>>, Word<I>, O>> bPartition : validitySetMap.get((Object)Validity.B_VALID)) {
                assert (bPartition.getFirst().size() == 1) : "b-valid inputs should always contain exactly 1 symbol";
                Word<I> bValidInput = bPartition.getFirst().firstSymbol();
                nodeToRefine = bPartition.getSecond();
                successorsToNodes = nodeToRefine.getPartition().stream().collect(Collectors.toMap(x -> automaton.getSuccessor((Map.Entry<Object, Set<Object>>)x, (Word)bValidInput), Function.identity()));
                SplitTree v = st.findLowestSubsetNode(successorsToNodes.keySet()).orElseThrow(IllegalStateException::new);
                nodeToRefine.setSequence(v.getSequence().prepend(bValidInput));
                leaves.remove(nodeToRefine);
                for (Map.Entry entry : v.getSuccessors().entrySet()) {
                    wSet = entry.getValue().getPartition();
                    intersection = new HashSet<Object>(successorsToNodes.keySet());
                    intersection.retainAll(wSet);
                    if (intersection.isEmpty()) continue;
                    indistinguishableNodes = intersection.stream().map(successorsToNodes::get).collect(Collectors.toSet());
                    newChild = new SplitTree(indistinguishableNodes);
                    nodeToRefine.getSuccessors().put(entry.getKey(), newChild);
                    leaves.add(newChild);
                }
                for (Map.Entry<Object, Object> entry : nodeToRefine.getPartition()) {
                    nodeToRefine.getMapping().put(entry, (Map.Entry<Object, Set<Object>>)v.getMapping().get(automaton.getSuccessor(entry, bValidInput)));
                }
            }
            for (Pair<Word<Word<I>>, SplitTree<Map.Entry<Object, Set<Object>>, Word<I>, O>> cPartition : validitySetMap.get((Object)Validity.C_VALID)) {
                Word<Word<I>> cValidInput = cPartition.getFirst();
                nodeToRefine = cPartition.getSecond();
                successorsToNodes = nodeToRefine.getPartition().stream().collect(Collectors.toMap(x -> automaton.getSuccessor((Map.Entry<Object, Set<Object>>)x, cValidInput), Function.identity()));
                SplitTree c = st.findLowestSubsetNode(successorsToNodes.keySet()).orElseThrow(IllegalStateException::new);
                nodeToRefine.setSequence(cValidInput.concat(c.getSequence()));
                leaves.remove(nodeToRefine);
                for (Map.Entry<Object, Object> entry : c.getSuccessors().entrySet()) {
                    wSet = ((SplitTree)entry.getValue()).getPartition();
                    intersection = new HashSet<Object>(successorsToNodes.keySet());
                    intersection.retainAll(wSet);
                    if (intersection.isEmpty()) continue;
                    indistinguishableNodes = intersection.stream().map(successorsToNodes::get).collect(Collectors.toSet());
                    newChild = new SplitTree(indistinguishableNodes);
                    nodeToRefine.getSuccessors().put(entry.getKey(), newChild);
                    leaves.add(newChild);
                }
                for (Map.Entry<Object, Object> entry : nodeToRefine.getPartition()) {
                    nodeToRefine.getMapping().put(entry, (Map.Entry<Object, Set<Object>>)c.getMapping().get(automaton.getSuccessor(entry, cValidInput)));
                }
            }
        }
        return new SplitTreeResult(st);
    }

    private static <S, I, O> ADSNode<S, I, O> extractADS(MealyMachine<S, I, ?, O> automaton, SplitTree<S, I, O> st, Set<S> currentSet, Map<S, S> currentToInitialMapping, ADSNode<S, I, O> predecessor) {
        if (currentSet.size() == 1) {
            S currentNode = currentSet.iterator().next();
            assert (currentToInitialMapping.containsKey(currentNode));
            return new ADSLeafNode<S, I, O>(predecessor, currentToInitialMapping.get(currentNode));
        }
        SplitTree u = st.findLowestSubsetNode(currentSet).orElseThrow(IllegalStateException::new);
        Pair<ADSNode<S, I, O>, ADSNode<S, I, O>> ads = ADSUtil.buildFromTrace(automaton, u.getSequence(), currentSet.iterator().next());
        ADSNode<S, I, O> head = ads.getFirst();
        ADSNode<S, I, O> tail = ads.getSecond();
        head.setParent(predecessor);
        for (Map.Entry<O, SplitTree<S, I, O>> entry : u.getSuccessors().entrySet()) {
            O output = entry.getKey();
            SplitTree<S, I, O> tree = entry.getValue();
            HashSet<S> intersection = new HashSet<S>(tree.getPartition());
            intersection.retainAll(currentSet);
            if (intersection.isEmpty()) continue;
            Map<Object, Object> nextCurrentToInitialMapping = intersection.stream().collect(Collectors.toMap(key -> u.getMapping().get(key), currentToInitialMapping::get));
            Set nextCurrent = intersection.stream().map(x -> u.getMapping().get(x)).collect(Collectors.toSet());
            tail.getChildren().put(output, LeeYannakakis.extractADS(automaton, st, nextCurrent, nextCurrentToInitialMapping, tail));
        }
        return head;
    }

    private static <S, I, O> boolean needsRefinement(SplitTree<S, I, O> node) {
        return node.getPartition().size() > 1;
    }

    private static <S, I, O> boolean isValidInput(MealyMachine<S, I, ?, O> automaton, I input, Set<S> states) {
        HashMap successors = new HashMap();
        for (S s : states) {
            Object output = automaton.getOutput(s, input);
            S successor = automaton.getSuccessor(s, input);
            if (!successors.containsKey(output)) {
                successors.put(output, new HashSet());
            }
            if (((Set)successors.get(output)).add(successor)) continue;
            return false;
        }
        return true;
    }

    private static <S, I, O> Map<Validity, Set<Pair<Word<I>, SplitTree<S, I, O>>>> computeValidities(MealyMachine<S, I, ?, O> automaton, Alphabet<I> inputs, Set<SplitTree<S, I, O>> r, Set<SplitTree<S, I, O>> pi) {
        EnumMap<Validity, Set<Pair<Word<I>, SplitTree<S, I, O>>>> result = new EnumMap<Validity, Set<Pair<Word<I>, SplitTree<S, I, O>>>>(Validity.class);
        HashMap stateToPartitionMap = new HashMap();
        HashBiMap partitionToNodeMap = HashBiMap.create();
        int counter = 0;
        for (SplitTree<S, I, O> partition : pi) {
            for (S s2 : partition.getPartition()) {
                Integer previousValue = stateToPartitionMap.put(s2, counter);
                assert (previousValue == null) : "Not a true partition";
            }
            partitionToNodeMap.put((Object)counter, partition);
            ++counter;
        }
        for (Validity v : Validity.values()) {
            result.put(v, new HashSet());
        }
        HashSet<SplitTree<S, I, O>> pendingCs = new HashSet<SplitTree<S, I, O>>();
        HashMap<Integer, Validity> partitionToClassificationMap = new HashMap<Integer, Validity>();
        CompactSimpleGraph implicationGraph = new CompactSimpleGraph(partitionToNodeMap.size());
        for (int i = 0; i < partitionToNodeMap.size(); ++i) {
            implicationGraph.addIntNode();
        }
        block4: for (SplitTree<S, I, O> b : r) {
            HashMap validInputMap = Maps.newHashMapWithExpectedSize((int)inputs.size());
            for (Object i : inputs) {
                validInputMap.put(i, LeeYannakakis.isValidInput(automaton, i, b.getPartition()));
            }
            for (Object i : inputs) {
                Set outputs;
                if (!((Boolean)validInputMap.get(i)).booleanValue() || (outputs = b.getPartition().stream().map(s -> automaton.getOutput(s, i)).collect(Collectors.toSet())).size() <= 1) continue;
                ((Set)result.get((Object)Validity.A_VALID)).add(Pair.of(Word.fromSymbols(i), b));
                partitionToClassificationMap.put((Integer)stateToPartitionMap.get(b.getPartition().iterator().next()), Validity.A_VALID);
                continue block4;
            }
            for (Object i : inputs) {
                Set successors;
                if (!((Boolean)validInputMap.get(i)).booleanValue() || (successors = b.getPartition().stream().map(s -> (Integer)stateToPartitionMap.get(automaton.getSuccessor(s, i))).collect(Collectors.toSet())).size() <= 1) continue;
                ((Set)result.get((Object)Validity.B_VALID)).add(Pair.of(Word.fromSymbols(i), b));
                partitionToClassificationMap.put((Integer)stateToPartitionMap.get(b.getPartition().iterator().next()), Validity.B_VALID);
                continue block4;
            }
            for (Object i : inputs) {
                Integer successorPartition;
                if (!((Boolean)validInputMap.get(i)).booleanValue()) continue;
                S nodeInPartition = b.getPartition().iterator().next();
                S successor = automaton.getSuccessor(nodeInPartition, i);
                Integer partition = (Integer)stateToPartitionMap.get(nodeInPartition);
                if (partition.equals(successorPartition = (Integer)stateToPartitionMap.get(successor))) continue;
                implicationGraph.connect(partition, successorPartition, i);
                pendingCs.add(b);
            }
            if (pendingCs.contains(b)) continue;
            ((Set)result.get((Object)Validity.INVALID)).add(Pair.of(null, b));
        }
        block9: for (SplitTree<S, I, O> pendingC : pendingCs) {
            Integer pendingPartition = (Integer)partitionToNodeMap.inverse().get(pendingC);
            Iterator<Integer> iter = GraphTraversal.breadthFirstIterator(implicationGraph, Collections.singleton(pendingPartition));
            while (iter.hasNext()) {
                Integer successor = iter.next();
                Validity successorValidity = (Validity)((Object)partitionToClassificationMap.get(successor));
                if (successorValidity != Validity.A_VALID && successorValidity != Validity.B_VALID) continue;
                Path path = ShortestPaths.shortestPath(implicationGraph, pendingPartition, implicationGraph.size(), successor);
                assert (path != null);
                Word word = path.stream().map(CompactEdge::getProperty).collect(Word.collector());
                ((Set)result.get((Object)Validity.C_VALID)).add(Pair.of(word, pendingC));
                continue block9;
            }
            ((Set)result.get((Object)Validity.INVALID)).add(Pair.of(null, pendingC));
        }
        return result;
    }

    private static enum Validity {
        A_VALID,
        B_VALID,
        C_VALID,
        INVALID;

    }
}

