/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.serialization.etf.writer;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.io.OutputStream;
import java.io.PrintWriter;
import net.automatalib.alphabet.Alphabet;
import net.automatalib.automaton.concept.StateIDs;
import net.automatalib.automaton.transducer.MealyMachine;
import net.automatalib.common.util.IOUtil;
import net.automatalib.serialization.etf.writer.AbstractETFWriter;

public final class Mealy2ETFWriterIO<I, O>
extends AbstractETFWriter<I, MealyMachine<?, I, ?, O>> {
    private static final Mealy2ETFWriterIO<?, ?> INSTANCE = new Mealy2ETFWriterIO();

    @Override
    protected void writeEdge(PrintWriter pw) {
        pw.println("begin edge");
        pw.println("input:input");
        pw.println("output:output");
        pw.println("end edge");
    }

    @Override
    protected void writeETF(PrintWriter pw, MealyMachine<?, I, ?, O> mealy, Alphabet<I> inputs) {
        this.writeETFInternal(pw, mealy, inputs);
    }

    private <S, T> void writeETFInternal(PrintWriter pw, MealyMachine<S, I, T, O> mealy, Alphabet<I> inputs) {
        StateIDs stateIDs = mealy.stateIDs();
        Object init = mealy.getInitialState();
        if (init != null) {
            pw.println("begin init");
            pw.printf("%d%n", stateIDs.getStateId(init));
            pw.println("end init");
        }
        pw.println("begin sort id");
        mealy.getStates().forEach(s -> pw.printf("\"%s\"%n", s));
        pw.println("end sort");
        HashBiMap outputIndices = HashBiMap.create();
        pw.println("begin trans");
        for (Object s2 : mealy.getStates()) {
            for (Object i2 : inputs) {
                Object t = mealy.getTransition(s2, i2);
                if (t == null) continue;
                Object o = mealy.getTransitionOutput(t);
                outputIndices.computeIfAbsent(o, arg_0 -> Mealy2ETFWriterIO.lambda$writeETFInternal$1((BiMap)outputIndices, arg_0));
                Object n = mealy.getSuccessor(t);
                pw.printf("%s/%s %d %d%n", stateIDs.getStateId(s2), stateIDs.getStateId(n), inputs.getSymbolIndex(i2), outputIndices.get(o));
            }
        }
        pw.println("end trans");
        pw.println("begin sort input");
        inputs.forEach(i -> pw.printf("\"%s\"%n", i));
        pw.println("end sort");
        pw.println("begin sort output");
        for (int i3 = 0; i3 < outputIndices.size(); ++i3) {
            pw.printf("\"%s\"%n", outputIndices.inverse().get((Object)i3));
        }
        pw.println("end sort");
    }

    @Override
    public void writeModel(OutputStream os, MealyMachine<?, I, ?, O> model, Alphabet<I> alphabet) {
        try (PrintWriter pw = new PrintWriter(IOUtil.asBufferedNonClosingUTF8Writer(os));){
            this.write(pw, model, alphabet);
        }
    }

    public static <I, O> Mealy2ETFWriterIO<I, O> getInstance() {
        return INSTANCE;
    }

    private static /* synthetic */ Integer lambda$writeETFInternal$1(BiMap outputIndices, Object ii) {
        return outputIndices.size();
    }
}

