/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.serialization.dot;

import java.io.Flushable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.automatalib.automaton.Automaton;
import net.automatalib.automaton.graph.TransitionEdge;
import net.automatalib.common.util.mapping.MutableMapping;
import net.automatalib.common.util.string.StringUtil;
import net.automatalib.graph.Graph;
import net.automatalib.graph.UndirectedGraph;
import net.automatalib.graph.concept.GraphViewable;
import net.automatalib.serialization.dot.AggregateDOTVisualizationHelper;
import net.automatalib.serialization.dot.DOTVisualizationHelper;
import net.automatalib.serialization.dot.DefaultDOTVisualizationHelper;
import net.automatalib.visualization.VisualizationHelper;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class GraphDOT {
    private static final String INITIAL_LABEL = "__start";
    private static final String HTML_START_TAG = "<HTML>";
    private static final String HTML_END_TAG = "</HTML>";

    private GraphDOT() {
    }

    public static void write(GraphViewable gv, Appendable a) throws IOException {
        Graph<?, ?> graph = gv.graphView();
        GraphDOT.write(graph, a);
    }

    public static <S, I, T> void write(Automaton<S, I, T> automaton, Collection<? extends I> inputAlphabet, Appendable a) throws IOException {
        GraphDOT.write(automaton.transitionGraphView(inputAlphabet), a);
    }

    @SafeVarargs
    public static <S, I, T> void write(Automaton<S, I, T> automaton, Collection<? extends I> inputAlphabet, Appendable a, VisualizationHelper<S, ? super TransitionEdge<I, T>> ... additionalHelpers) throws IOException {
        GraphDOT.write(automaton, inputAlphabet, a, Arrays.asList(additionalHelpers));
    }

    public static <S, I, T> void write(Automaton<S, I, T> automaton, Collection<? extends I> inputAlphabet, Appendable a, List<VisualizationHelper<S, ? super TransitionEdge<I, T>>> additionalHelpers) throws IOException {
        GraphDOT.write(automaton.transitionGraphView(inputAlphabet), a, additionalHelpers);
    }

    public static <N, E> void write(Graph<N, E> graph, Appendable a) throws IOException {
        GraphDOT.writeRaw(graph, a, GraphDOT.toDOTVisualizationHelper(graph.getVisualizationHelper()));
    }

    @SafeVarargs
    public static <N, E> void write(Graph<N, E> graph, Appendable a, VisualizationHelper<N, ? super E> ... additionalHelpers) throws IOException {
        GraphDOT.write(graph, a, Arrays.asList(additionalHelpers));
    }

    public static <N, E> void write(Graph<N, E> graph, Appendable a, List<VisualizationHelper<N, ? super E>> additionalHelpers) throws IOException {
        ArrayList<VisualizationHelper<N, VisualizationHelper<N, E>>> helpers = new ArrayList<VisualizationHelper<N, VisualizationHelper<N, E>>>(additionalHelpers.size() + 1);
        helpers.add(graph.getVisualizationHelper());
        helpers.addAll(additionalHelpers);
        GraphDOT.writeRaw(graph, a, GraphDOT.toDOTVisualizationHelper(helpers));
    }

    public static void write(List<Graph<?, ?>> graphs, Appendable a) throws IOException {
        boolean directed = false;
        for (Graph<?, ?> g : graphs) {
            if (g instanceof UndirectedGraph) continue;
            directed = true;
            break;
        }
        GraphDOT.writeRawHeader(a, directed);
        int clusterId = 0;
        for (Graph<?, ?> g : graphs) {
            String idPrefix = "c" + clusterId + '_';
            a.append(System.lineSeparator()).append("subgraph cluster").append(Integer.toString(clusterId)).append(" {").append(System.lineSeparator());
            Graph<?, ?> graph = g;
            GraphDOT.writeRawBody(graph, a, GraphDOT.toDOTVisualizationHelper(graph.getVisualizationHelper()), !(graph instanceof UndirectedGraph), idPrefix);
            a.append('}').append(System.lineSeparator());
            ++clusterId;
        }
        GraphDOT.writeRawFooter(a);
    }

    private static <N, E> void writeRaw(Graph<N, E> graph, Appendable a, DOTVisualizationHelper<N, ? super E> dotHelper) throws IOException {
        boolean directed = !(graph instanceof UndirectedGraph);
        GraphDOT.writeRawHeader(a, directed);
        GraphDOT.writeRawBody(graph, a, dotHelper, directed, "");
        GraphDOT.writeRawFooter(a);
        if (a instanceof Flushable) {
            ((Flushable)((Object)a)).flush();
        }
    }

    private static void writeRawHeader(Appendable a, boolean directed) throws IOException {
        if (directed) {
            a.append("di");
        }
        a.append("graph g {").append(System.lineSeparator());
    }

    private static <N, E> void writeRawBody(Graph<N, E> graph, Appendable a, DOTVisualizationHelper<N, ? super E> dotHelper, boolean directed, String idPrefix) throws IOException {
        HashMap<String, String> props = new HashMap<String, String>();
        dotHelper.getGlobalNodeProperties(props);
        if (!props.isEmpty()) {
            a.append('\t').append("node");
            GraphDOT.appendParams(props, a);
            a.append(';').append(System.lineSeparator());
        }
        props.clear();
        dotHelper.getGlobalEdgeProperties(props);
        if (!props.isEmpty()) {
            a.append('\t').append("edge");
            GraphDOT.appendParams(props, a);
            a.append(';').append(System.lineSeparator());
        }
        dotHelper.writePreamble(a);
        a.append(System.lineSeparator());
        MutableMapping<N, @Nullable V> nodeNames = graph.createStaticNodeMapping();
        HashSet<String> initialNodes = new HashSet<String>();
        int i = 0;
        for (Object node : graph) {
            props.clear();
            if (!dotHelper.getNodeProperties(node, props)) continue;
            String id = idPrefix + "s" + i++;
            if (Boolean.parseBoolean((String)props.remove("initial"))) {
                initialNodes.add(id);
            }
            a.append('\t').append(id);
            GraphDOT.appendParams(props, a);
            a.append(';').append(System.lineSeparator());
            nodeNames.put(node, id);
        }
        for (Object node : graph) {
            Collection<E> outEdges;
            String srcId = (String)nodeNames.get(node);
            if (srcId == null || (outEdges = graph.getOutgoingEdges(node)).isEmpty()) continue;
            for (E e : outEdges) {
                Object tgt = graph.getTarget(e);
                String tgtId = (String)nodeNames.get(tgt);
                if (tgtId == null || !directed && tgtId.compareTo(srcId) < 0) continue;
                props.clear();
                if (!dotHelper.getEdgeProperties(node, e, tgt, props)) continue;
                a.append('\t').append(srcId).append(' ');
                if (directed) {
                    a.append("-> ");
                } else {
                    a.append("-- ");
                }
                a.append(tgtId);
                GraphDOT.appendParams(props, a);
                a.append(';').append(System.lineSeparator());
            }
        }
        if (!initialNodes.isEmpty()) {
            a.append(System.lineSeparator());
            GraphDOT.renderInitialArrowTip(initialNodes, idPrefix, a);
        }
        a.append(System.lineSeparator());
        dotHelper.writePostamble(a);
    }

    private static void writeRawFooter(Appendable a) throws IOException {
        a.append('}').append(System.lineSeparator());
    }

    private static void appendParams(Map<String, String> params, Appendable a) throws IOException {
        if (params.isEmpty()) {
            return;
        }
        a.append(" [");
        boolean first = true;
        for (Map.Entry<String, String> e : params.entrySet()) {
            if (first) {
                first = false;
            } else {
                a.append(' ');
            }
            String key = e.getKey();
            String value = e.getValue();
            a.append(e.getKey()).append("=");
            if (key.equals("label")) {
                String upperCase = value.toUpperCase(Locale.ROOT);
                if (upperCase.startsWith(HTML_START_TAG)) {
                    a.append('<');
                    if (upperCase.endsWith(HTML_END_TAG)) {
                        a.append(value.substring(HTML_START_TAG.length(), value.length() - HTML_END_TAG.length()));
                    } else {
                        a.append(value.substring(HTML_START_TAG.length()));
                    }
                    a.append('>');
                    continue;
                }
                StringUtil.enquote(e.getValue(), a);
                continue;
            }
            StringUtil.enquote(e.getValue(), a);
        }
        a.append(']');
    }

    private static void renderInitialArrowTip(Set<String> initialNodes, String idPrefix, Appendable a) throws IOException {
        int i = 0;
        for (String init : initialNodes) {
            a.append(GraphDOT.initialLabel(idPrefix, i)).append(" [label=\"\" shape=\"none\" width=\"0\" height=\"0\"];").append(System.lineSeparator()).append(GraphDOT.initialLabel(idPrefix, i++)).append(" -> ").append(init).append(';').append(System.lineSeparator());
        }
    }

    public static String initialLabel(int n) {
        return GraphDOT.initialLabel("", n);
    }

    public static String initialLabel(String idPrefix, int n) {
        return idPrefix + INITIAL_LABEL + n;
    }

    public static <N, E> DOTVisualizationHelper<N, E> toDOTVisualizationHelper(VisualizationHelper<N, E> helper) {
        if (helper instanceof DOTVisualizationHelper) {
            return (DOTVisualizationHelper)helper;
        }
        return new DefaultDOTVisualizationHelper<N, E>(helper);
    }

    public static <N, E> DOTVisualizationHelper<N, E> toDOTVisualizationHelper(List<VisualizationHelper<N, ? super E>> helpers) {
        ArrayList<DOTVisualizationHelper<N, E>> convertedHelpers = new ArrayList<DOTVisualizationHelper<N, E>>(helpers.size());
        for (VisualizationHelper<N, E> visualizationHelper : helpers) {
            convertedHelpers.add(GraphDOT.toDOTVisualizationHelper(visualizationHelper));
        }
        return new AggregateDOTVisualizationHelper(convertedHelpers);
    }
}

