/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.serialization.dot;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.automatalib.alphabet.Alphabet;
import net.automatalib.alphabet.Alphabets;
import net.automatalib.automaton.AutomatonCreator;
import net.automatalib.automaton.MutableAutomaton;
import net.automatalib.common.util.IOUtil;
import net.automatalib.common.util.Pair;
import net.automatalib.common.util.mapping.Mapping;
import net.automatalib.common.util.mapping.MutableMapping;
import net.automatalib.serialization.dot.DOTInputModelData;
import net.automatalib.serialization.dot.DOTInputModelDeserializer;
import net.automatalib.serialization.dot.Edge;
import net.automatalib.serialization.dot.InternalDOTParser;
import net.automatalib.serialization.dot.Node;

public class DOTMutableAutomatonParser<S, I, SP, TP, A extends MutableAutomaton<S, I, ?, SP, TP>>
implements DOTInputModelDeserializer<S, I, A> {
    private final AutomatonCreator<A, I> creator;
    private final Function<Map<String, String>, SP> nodeParser;
    private final Function<Map<String, String>, Pair<I, TP>> edgeParser;
    private final Collection<String> initialNodeIds;
    private final boolean fakeInitialNodeIds;

    public DOTMutableAutomatonParser(AutomatonCreator<A, I> creator, Function<Map<String, String>, SP> nodeParser, Function<Map<String, String>, Pair<I, TP>> edgeParser, Collection<String> initialNodeIds, boolean fakeInitialNodeIds) {
        this.creator = creator;
        this.nodeParser = nodeParser;
        this.edgeParser = edgeParser;
        this.initialNodeIds = initialNodeIds;
        this.fakeInitialNodeIds = fakeInitialNodeIds;
    }

    @Override
    public DOTInputModelData<S, I, A> readModel(InputStream is) throws IOException {
        try (Reader r = IOUtil.asUncompressedBufferedNonClosingUTF8Reader(is);){
            InternalDOTParser parser = new InternalDOTParser(r);
            parser.parse();
            assert (parser.isDirected());
            HashSet<I> inputs = new HashSet<I>();
            for (Edge edge : parser.getEdges()) {
                if (this.fakeInitialNodeIds && this.initialNodeIds.contains(edge.src)) continue;
                inputs.add(this.edgeParser.apply(edge.attributes).getFirst());
            }
            Alphabet alphabet = Alphabets.fromCollection(inputs);
            MutableAutomaton automaton = (MutableAutomaton)this.creator.createAutomaton(alphabet, parser.getNodes().size());
            Mapping<S, String> labels = this.parseNodesAndEdges(parser, automaton);
            DOTInputModelData dOTInputModelData = new DOTInputModelData(automaton, alphabet, labels);
            return dOTInputModelData;
        }
    }

    private Mapping<S, String> parseNodesAndEdges(InternalDOTParser parser, MutableAutomaton<S, I, ?, SP, TP> automaton) {
        List<Node> nodes = parser.getNodes();
        HashMap stateMap = Maps.newHashMapWithExpectedSize((int)nodes.size());
        MutableMapping mapping = automaton.createDynamicStateMapping();
        for (Node node : nodes) {
            if (this.fakeInitialNodeIds && this.initialNodeIds.contains(node.id)) continue;
            S state = !this.fakeInitialNodeIds && this.initialNodeIds.contains(node.id) ? automaton.addInitialState(this.nodeParser.apply(node.attributes)) : automaton.addState(this.nodeParser.apply(node.attributes));
            stateMap.put(node.id, state);
            String label = node.attributes.getOrDefault("label", node.id);
            mapping.put(state, label);
        }
        for (Edge edge : parser.getEdges()) {
            if (this.fakeInitialNodeIds && this.initialNodeIds.contains(edge.src)) {
                automaton.setInitial(stateMap.get(edge.tgt), true);
                continue;
            }
            Pair<I, TP> property = this.edgeParser.apply(edge.attributes);
            automaton.addTransition(stateMap.get(edge.src), property.getFirst(), stateMap.get(edge.tgt), property.getSecond());
        }
        return mapping;
    }
}

