/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.serialization.dot;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.automatalib.common.util.IOUtil;
import net.automatalib.graph.MutableGraph;
import net.automatalib.serialization.ModelDeserializer;
import net.automatalib.serialization.dot.Edge;
import net.automatalib.serialization.dot.InternalDOTParser;
import net.automatalib.serialization.dot.Node;

public class DOTGraphParser<NP, EP, G extends MutableGraph<?, ?, NP, EP>>
implements ModelDeserializer<G> {
    private final Supplier<G> creator;
    private final Function<Map<String, String>, NP> nodeParser;
    private final Function<Map<String, String>, EP> edgeParser;

    public DOTGraphParser(Supplier<G> creator, Function<Map<String, String>, NP> nodeParser, Function<Map<String, String>, EP> edgeParser) {
        this.creator = creator;
        this.nodeParser = nodeParser;
        this.edgeParser = edgeParser;
    }

    @Override
    public G readModel(InputStream is) throws IOException {
        try (Reader r = IOUtil.asUncompressedBufferedNonClosingUTF8Reader(is);){
            InternalDOTParser parser = new InternalDOTParser(r);
            parser.parse();
            MutableGraph graph = (MutableGraph)this.creator.get();
            this.parseNodesAndEdges(parser, graph);
            MutableGraph mutableGraph = graph;
            return (G)mutableGraph;
        }
    }

    private <N> void parseNodesAndEdges(InternalDOTParser parser, MutableGraph<N, ?, NP, EP> graph) {
        List<Node> nodes = parser.getNodes();
        List<Edge> edges = parser.getEdges();
        HashMap stateMap = Maps.newHashMapWithExpectedSize((int)nodes.size());
        for (Node node : nodes) {
            N n = graph.addNode(this.nodeParser.apply(node.attributes));
            stateMap.put(node.id, n);
        }
        for (Edge edge : edges) {
            graph.connect(stateMap.get(edge.src), stateMap.get(edge.tgt), this.edgeParser.apply(edge.attributes));
        }
    }
}

