/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.modelchecker.m3c.transformer;

import info.scce.addlib.dd.bdd.BDD;
import info.scce.addlib.dd.bdd.BDDManager;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.automatalib.modelchecker.m3c.formula.AbstractModalFormulaNode;
import net.automatalib.modelchecker.m3c.formula.AndNode;
import net.automatalib.modelchecker.m3c.formula.AtomicNode;
import net.automatalib.modelchecker.m3c.formula.BoxNode;
import net.automatalib.modelchecker.m3c.formula.DependencyGraph;
import net.automatalib.modelchecker.m3c.formula.DiamondNode;
import net.automatalib.modelchecker.m3c.formula.EquationalBlock;
import net.automatalib.modelchecker.m3c.formula.FalseNode;
import net.automatalib.modelchecker.m3c.formula.FormulaNode;
import net.automatalib.modelchecker.m3c.formula.NotNode;
import net.automatalib.modelchecker.m3c.formula.OrNode;
import net.automatalib.modelchecker.m3c.formula.TrueNode;
import net.automatalib.modelchecker.m3c.transformer.AbstractPropertyTransformer;
import net.automatalib.ts.modal.transition.ModalEdgeProperty;
import org.checkerframework.checker.nullness.qual.Nullable;

public class BDDTransformer<L, AP>
extends AbstractPropertyTransformer<BDDTransformer<L, AP>, L, AP> {
    private final BDDManager bddManager;
    private final BDD[] bdds;

    BDDTransformer(BDDManager bddManager, BDD[] bdds) {
        this.bddManager = bddManager;
        this.bdds = bdds;
    }

    BDDTransformer(BDDManager bddManager, BDD[] bdds, boolean isMust) {
        super(isMust);
        this.bddManager = bddManager;
        this.bdds = bdds;
    }

    public BDDTransformer(BDDManager bddManager, DependencyGraph<L, AP> dependencyGraph) {
        this(bddManager, new BDD[dependencyGraph.getNumVariables()]);
        for (EquationalBlock<L, AP> block : dependencyGraph.getBlocks()) {
            if (block.isMaxBlock()) {
                for (FormulaNode<L, AP> node : block.getNodes()) {
                    this.bdds[node.getVarNumber()] = bddManager.readOne();
                }
                continue;
            }
            for (FormulaNode<L, AP> node : block.getNodes()) {
                this.bdds[node.getVarNumber()] = bddManager.readLogicZero();
            }
        }
    }

    public <TP extends ModalEdgeProperty> BDDTransformer(BDDManager bddManager, L edgeLabel, TP edgeProperty, DependencyGraph<L, AP> dependencyGraph) {
        this(bddManager, new BDD[dependencyGraph.getNumVariables()], edgeProperty.isMust());
        for (FormulaNode<L, AP> node : dependencyGraph.getFormulaNodes()) {
            int xi = node.getVarNumber();
            if (node instanceof AbstractModalFormulaNode) {
                AbstractModalFormulaNode modalNode = (AbstractModalFormulaNode)node;
                Object action = modalNode.getAction();
                if (!(action != null && !action.equals(edgeLabel) || modalNode instanceof DiamondNode && !edgeProperty.isMust())) {
                    int xj = modalNode.getVarNumberChild();
                    this.bdds[xi] = bddManager.ithVar(xj);
                    continue;
                }
                if (modalNode instanceof DiamondNode) {
                    this.bdds[xi] = bddManager.readLogicZero();
                    continue;
                }
                if (!(modalNode instanceof BoxNode)) continue;
                this.bdds[xi] = bddManager.readOne();
                continue;
            }
            this.bdds[xi] = bddManager.readLogicZero();
        }
    }

    public BDDTransformer(BDDManager bddManager, int numberOfVars) {
        this(bddManager, new BDD[numberOfVars]);
        for (int var = 0; var < numberOfVars; ++var) {
            this.bdds[var] = bddManager.ithVar(var);
        }
    }

    @Override
    public BitSet evaluate(boolean[] input) {
        BitSet output = new BitSet();
        for (int i = 0; i < this.bdds.length; ++i) {
            if (!this.bdds[i].eval(input).equals((Object)this.bddManager.readOne())) continue;
            output.set(i);
        }
        return output;
    }

    @Override
    public BDDTransformer<L, AP> compose(BDDTransformer<L, AP> other) {
        BDD[] composedBDDs = new BDD[this.bdds.length];
        for (int var = 0; var < this.bdds.length; ++var) {
            BDD composedBDD;
            composedBDDs[var] = composedBDD = this.bdds[var].vectorCompose(other.bdds);
        }
        return new BDDTransformer<L, AP>(this.bddManager, composedBDDs, this.isMust());
    }

    @Override
    public BDDTransformer<L, AP> createUpdate(Set<AP> atomicPropositions, List<BDDTransformer<L, AP>> compositions, EquationalBlock<L, AP> currentBlock) {
        BDD[] updatedBDDs = (BDD[])this.bdds.clone();
        for (FormulaNode<L, AP> node : currentBlock.getNodes()) {
            this.updateFormulaNode(atomicPropositions, compositions, updatedBDDs, node);
        }
        return new BDDTransformer<L, AP>(this.bddManager, updatedBDDs);
    }

    private void updateFormulaNode(Set<AP> atomicPropositions, List<BDDTransformer<L, AP>> compositions, BDD[] updatedBDDs, FormulaNode<L, AP> node) {
        BDD result;
        int varIdx = node.getVarNumber();
        if (node instanceof BoxNode) {
            result = this.andBddList(compositions, varIdx);
        } else if (node instanceof DiamondNode) {
            result = this.orBddList(compositions, varIdx);
        } else if (node instanceof AndNode) {
            AndNode andNode = (AndNode)node;
            result = updatedBDDs[andNode.getVarNumberLeft()].and(updatedBDDs[andNode.getVarNumberRight()]);
        } else if (node instanceof OrNode) {
            OrNode orNode = (OrNode)node;
            result = updatedBDDs[orNode.getVarNumberLeft()].or(updatedBDDs[orNode.getVarNumberRight()]);
        } else if (node instanceof TrueNode) {
            result = this.bddManager.readOne();
        } else if (node instanceof FalseNode) {
            result = this.bddManager.readLogicZero();
        } else if (node instanceof NotNode) {
            NotNode notNode = (NotNode)node;
            result = this.bdds[notNode.getVarNumberChild()].not();
        } else if (node instanceof AtomicNode) {
            Object atomicProp = ((AtomicNode)node).getProposition();
            result = atomicPropositions.contains(atomicProp) ? this.bddManager.readOne() : this.bddManager.readLogicZero();
        } else {
            throw new IllegalArgumentException();
        }
        updatedBDDs[varIdx] = result;
    }

    BDD andBddList(List<BDDTransformer<L, AP>> compositions, int var) {
        Optional<BDD> result = compositions.stream().map(comp -> comp.getBDD(var)).reduce(BDD::and);
        return result.orElseGet(() -> ((BDDManager)this.bddManager).readOne());
    }

    BDD orBddList(List<BDDTransformer<L, AP>> compositions, int var) {
        Optional<BDD> result = compositions.stream().filter(AbstractPropertyTransformer::isMust).map(comp -> comp.getBDD(var)).reduce(BDD::or);
        return result.orElseGet(() -> ((BDDManager)this.bddManager).readLogicZero());
    }

    public BDD getBDD(int var) {
        return this.bdds[var];
    }

    public int getNumberOfVars() {
        return this.bdds.length;
    }

    public int hashCode() {
        return Arrays.hashCode(this.bdds);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BDDTransformer that = (BDDTransformer)o;
        return Arrays.equals(this.bdds, that.bdds);
    }
}

