/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.modelchecker.m3c.solver;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.automatalib.modelchecker.m3c.solver.SolverData;
import net.automatalib.modelchecker.m3c.solver.SolverState;
import net.automatalib.modelchecker.m3c.transformer.AbstractPropertyTransformer;
import net.automatalib.modelchecker.m3c.transformer.TransformerSerializer;

public final class SolverHistory<T extends AbstractPropertyTransformer<T, L, AP>, L, AP> {
    private final Map<L, SolverData<?, T, L, AP>> data;
    private final Map<L, List<String>> mustTransformers;
    private final Map<L, List<String>> mayTransformers;
    private final List<SolverState<?, T, L, AP>> solverStates;
    private final boolean isSat;

    SolverHistory(Map<L, SolverData<?, T, L, AP>> data, Map<L, List<String>> mustTransformers, Map<L, List<String>> mayTransformers, List<SolverState<?, T, L, AP>> solverStates, boolean isSat) {
        this.data = data;
        this.mustTransformers = mustTransformers;
        this.mayTransformers = mayTransformers;
        this.solverStates = solverStates;
        this.isSat = isSat;
    }

    public Map<L, SolverData<?, T, L, AP>> getData() {
        return this.data;
    }

    public Map<L, T> getMustTransformers(TransformerSerializer<T, L, AP> serializer) {
        return this.transform(this.mustTransformers, serializer);
    }

    public Map<L, T> getMayTransformers(TransformerSerializer<T, L, AP> serializer) {
        return this.transform(this.mayTransformers, serializer);
    }

    public List<SolverState<?, T, L, AP>> getSolverStates() {
        return this.solverStates;
    }

    public boolean isSat() {
        return this.isSat;
    }

    private Map<L, T> transform(Map<L, List<String>> input, TransformerSerializer<T, L, AP> serializer) {
        HashMap result = Maps.newHashMapWithExpectedSize((int)input.size());
        for (Map.Entry<L, List<String>> e : input.entrySet()) {
            result.put(e.getKey(), serializer.deserialize(e.getValue()));
        }
        return result;
    }
}

