/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.modelchecker.m3c.solver;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.automatalib.common.util.mapping.Mapping;
import net.automatalib.common.util.mapping.MutableMapping;
import net.automatalib.graph.ContextFreeModalProcessSystem;
import net.automatalib.graph.ProceduralModalProcessGraph;
import net.automatalib.modelchecker.m3c.formula.AndNode;
import net.automatalib.modelchecker.m3c.formula.AtomicNode;
import net.automatalib.modelchecker.m3c.formula.BoxNode;
import net.automatalib.modelchecker.m3c.formula.DependencyGraph;
import net.automatalib.modelchecker.m3c.formula.EquationalBlock;
import net.automatalib.modelchecker.m3c.formula.FormulaNode;
import net.automatalib.modelchecker.m3c.formula.NotNode;
import net.automatalib.modelchecker.m3c.formula.OrNode;
import net.automatalib.modelchecker.m3c.formula.TrueNode;
import net.automatalib.modelchecker.m3c.formula.visitor.CTLToMuCalc;
import net.automatalib.modelchecker.m3c.solver.SolverData;
import net.automatalib.modelchecker.m3c.solver.SolverHistory;
import net.automatalib.modelchecker.m3c.solver.SolverState;
import net.automatalib.modelchecker.m3c.solver.WitnessTree;
import net.automatalib.modelchecker.m3c.solver.WitnessTreeExtractor;
import net.automatalib.modelchecker.m3c.transformer.AbstractPropertyTransformer;
import net.automatalib.modelchecker.m3c.transformer.TransformerSerializer;
import net.automatalib.modelchecking.ModelChecker;
import net.automatalib.ts.modal.transition.ModalEdgeProperty;
import net.automatalib.ts.modal.transition.ProceduralModalEdgeProperty;
import org.checkerframework.checker.initialization.qual.UnderInitialization;
import org.checkerframework.checker.nullness.qual.KeyFor;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

abstract class AbstractDDSolver<T extends AbstractPropertyTransformer<T, L, AP>, L, AP>
implements ModelChecker<L, ContextFreeModalProcessSystem<L, AP>, FormulaNode<L, AP>, WitnessTree<L, AP>> {
    private final @KeyFor(value={"workUnits"}) L mainProcess;
    private TransformerSerializer<T, L, AP> serializer;
    private DependencyGraph<L, AP> dependencyGraph;
    private int currentBlockIndex;
    private final Map<L, WorkUnit<?, ?>> workUnits;
    private Map<L, T> mustTransformers;
    private Map<L, T> mayTransformers;

    AbstractDDSolver(ContextFreeModalProcessSystem<L, AP> cfmps) {
        Map<L, ProceduralModalProcessGraph<?, L, ?, AP, ?>> pmpgs = cfmps.getPMPGs();
        this.workUnits = Maps.newHashMapWithExpectedSize((int)pmpgs.size());
        for (Map.Entry<L, ProceduralModalProcessGraph<?, L, ?, AP, ?>> e : pmpgs.entrySet()) {
            L label = e.getKey();
            ProceduralModalProcessGraph<?, L, ?, AP, ?> pmpg = e.getValue();
            this.checkPMPG(label, pmpg);
            this.workUnits.put(label, this.initializeWorkUnits(label, pmpg));
        }
        L mainProcess = cfmps.getMainProcess();
        if (mainProcess == null || !this.workUnits.containsKey(mainProcess)) {
            throw new IllegalArgumentException("The main process is undefined or has no corresponding MPG.");
        }
        this.mainProcess = mainProcess;
    }

    private <N> void checkPMPG(@UnderInitialization AbstractDDSolver<T, L, AP> this, L label, ProceduralModalProcessGraph<N, L, ?, AP, ?> pmpg) {
        Object initialNode = pmpg.getInitialNode();
        if (initialNode == null) {
            throw new IllegalArgumentException("PMPG '" + label + "' has no initial node");
        }
        Object finalNode = pmpg.getFinalNode();
        if (finalNode == null) {
            throw new IllegalArgumentException("PMPG '" + label + "' has no final node");
        }
        Preconditions.checkArgument((boolean)this.isGuarded(pmpg, initialNode), (String)"PMPG '%s' is not guarded. All initial transitions must be labelled with atomic actions.", label);
        Preconditions.checkArgument((boolean)this.isTerminating(pmpg, finalNode), (String)"PMPG '%s' is not terminating. The final node is not allowed to have outgoing transitions.", label);
    }

    private <N, E> boolean isGuarded(@UnderInitialization AbstractDDSolver<T, L, AP> this, ProceduralModalProcessGraph<N, L, E, AP, ?> pmpg, N initialNode) {
        for (Object initialTransition : pmpg.getOutgoingEdges(initialNode)) {
            if (!((ProceduralModalEdgeProperty)pmpg.getEdgeProperty(initialTransition)).isProcess()) continue;
            return false;
        }
        return true;
    }

    private <N, E> boolean isTerminating(@UnderInitialization AbstractDDSolver<T, L, AP> this, ProceduralModalProcessGraph<N, L, E, AP, ?> pmpg, N finalNode) {
        return pmpg.getOutgoingEdges(finalNode).isEmpty();
    }

    private <N> WorkUnit<N, ?> initializeWorkUnits(@UnderInitialization AbstractDDSolver<T, L, AP> this, L label, ProceduralModalProcessGraph<N, L, ?, AP, ?> pmpg) {
        return new WorkUnit(label, pmpg, AbstractDDSolver.initPredecessorsMapping(pmpg));
    }

    private static <N, L, E, AP> Mapping<N, @Nullable Set<N>> initPredecessorsMapping(ProceduralModalProcessGraph<N, L, E, AP, ?> pmpg) {
        MutableMapping<N, @Nullable V> nodeToPredecessors = pmpg.createStaticNodeMapping();
        for (Object sourceNode : pmpg.getNodes()) {
            for (Object outgoingEdge : pmpg.getOutgoingEdges(sourceNode)) {
                Object targetNode = pmpg.getTarget(outgoingEdge);
                HashSet nodePredecessors = (HashSet)nodeToPredecessors.get(targetNode);
                if (nodePredecessors == null) {
                    nodePredecessors = new HashSet();
                    nodeToPredecessors.put(targetNode, nodePredecessors);
                }
                nodePredecessors.add(sourceNode);
            }
        }
        return nodeToPredecessors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @Nullable WitnessTree<L, AP> findCounterExample(ContextFreeModalProcessSystem<L, AP> cfmps, Collection<? extends L> inputs, FormulaNode<L, AP> formulaNode) {
        NotNode<L, AP> negatedFormula = new NotNode<L, AP>(formulaNode);
        FormulaNode<L, AP> ast = this.ctlToMuCalc(negatedFormula).toNNF();
        this.initialize(ast);
        try {
            this.solveInternal(false, Collections.emptyList());
            boolean sat = this.isSat();
            if (sat) {
                Map<L, WorkUnit<?, ?>> units = Collections.unmodifiableMap(this.workUnits);
                WitnessTree<L, AP> witnessTree = WitnessTreeExtractor.computeWitness(cfmps, units, this.dependencyGraph, ast, this.getAllAPDeadlockedNode());
                return witnessTree;
            }
            WitnessTree<L, AP> witnessTree = null;
            return witnessTree;
        }
        finally {
            this.shutdownDDManager();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean solve(FormulaNode<L, AP> formula) {
        FormulaNode<L, AP> ast = this.ctlToMuCalc(formula).toNNF();
        this.initialize(ast);
        try {
            this.solveInternal(false, Collections.emptyList());
            boolean bl = this.isSat();
            return bl;
        }
        finally {
            this.shutdownDDManager();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SolverHistory<T, L, AP> solveAndRecordHistory(FormulaNode<L, AP> formula) {
        ArrayList history = new ArrayList();
        FormulaNode<L, AP> ast = this.ctlToMuCalc(formula).toNNF();
        this.initialize(ast);
        try {
            HashMap data = Maps.newHashMapWithExpectedSize((int)this.workUnits.size());
            for (Map.Entry<L, WorkUnit<?, ?>> e : this.workUnits.entrySet()) {
                data.put(e.getKey(), this.createProcessData(e.getValue()));
            }
            this.solveInternal(true, history);
            Map<L, List<String>> serializedMustTransformers = this.serializePropertyTransformerMap(this.mustTransformers);
            Map<L, List<String>> serializedMayTransformers = this.serializePropertyTransformerMap(this.mayTransformers);
            boolean isSat = this.isSat();
            SolverHistory<T, L, AP> solverHistory = new SolverHistory<T, L, AP>(data, serializedMustTransformers, serializedMayTransformers, history, isSat);
            return solverHistory;
        }
        finally {
            this.shutdownDDManager();
        }
    }

    private <N, E> SolverData<N, T, L, AP> createProcessData(WorkUnit<N, E> unit) {
        return new SolverData(unit.pmpg, this.serializePropertyTransformers(unit), this.computeSatisfiedSubformulas(unit));
    }

    private Map<L, List<String>> serializePropertyTransformerMap(Map<L, T> transformers) {
        HashMap serializedTransformers = Maps.newHashMapWithExpectedSize((int)transformers.size());
        for (Map.Entry<L, T> entry : transformers.entrySet()) {
            serializedTransformers.put(entry.getKey(), this.serializer.serialize((AbstractPropertyTransformer)entry.getValue()));
        }
        return serializedTransformers;
    }

    private void solveInternal(boolean recordHistory, List<SolverState<?, T, L, AP>> history) {
        boolean workSetIsEmpty = false;
        while (!workSetIsEmpty) {
            workSetIsEmpty = true;
            for (Map.Entry<L, WorkUnit<?, ?>> entry : this.workUnits.entrySet()) {
                workSetIsEmpty &= this.solveInternal(entry.getValue(), recordHistory, history);
            }
        }
    }

    private <N> boolean solveInternal(WorkUnit<N, ?> unit, boolean recordHistory, List<SolverState<?, T, L, AP>> history) {
        if (!((WorkUnit)unit).workSet.isEmpty()) {
            Iterator iter = ((WorkUnit)unit).workSet.iterator();
            Object node = iter.next();
            iter.remove();
            Object label = unit.label;
            List<T> compositions = this.updateNodeAndGetCompositions(unit, node);
            if (recordHistory) {
                ArrayList<List<String>> serializedCompositions = new ArrayList<List<String>>(compositions.size());
                for (AbstractPropertyTransformer composition : compositions) {
                    serializedCompositions.add(this.serializer.serialize(composition));
                }
                history.add(new SolverState(this.serializer.serialize((AbstractPropertyTransformer)unit.propTransformers.get(node)), serializedCompositions, node, label, this.copyWorkSet(), this.getSatisfiedSubformulas(unit, node)));
            }
            return false;
        }
        return true;
    }

    private <N> List<T> updateNodeAndGetCompositions(WorkUnit<N, ?> unit, N node) {
        assert (!Objects.equals(node, unit.pmpg.getFinalNode())) : "End node must not be updated!";
        T nodeTransformer = this.getTransformer(unit, node);
        List<T> compositions = this.createCompositions(unit, node);
        T updatedTransformer = this.getUpdatedPropertyTransformer(unit, node, nodeTransformer, compositions);
        this.updateTransformerAndWorkSet(unit, node, nodeTransformer, updatedTransformer);
        return compositions;
    }

    private Map<L, Set<?>> copyWorkSet() {
        HashMap copy = Maps.newHashMapWithExpectedSize((int)this.workUnits.size());
        for (Map.Entry<L, WorkUnit<?, ?>> e : this.workUnits.entrySet()) {
            copy.put(e.getKey(), this.copyWorkSet(e.getValue()));
        }
        return copy;
    }

    private <N> Set<N> copyWorkSet(WorkUnit<N, ?> unit) {
        return new HashSet(((WorkUnit)unit).workSet);
    }

    private <N> Mapping<N, List<FormulaNode<L, AP>>> computeSatisfiedSubformulas(WorkUnit<N, ?> unit) {
        MutableMapping<N, @Nullable V> result = unit.pmpg.createStaticNodeMapping();
        for (Object node : unit.pmpg.getNodes()) {
            result.put(node, this.getSatisfiedSubformulas(unit, node));
        }
        return result;
    }

    private <N> List<FormulaNode<L, AP>> getSatisfiedSubformulas(WorkUnit<N, ?> unit, N node) {
        BitSet output = ((AbstractPropertyTransformer)unit.propTransformers.get(node)).evaluate(this.dependencyGraph.toBoolArray(this.getAllAPDeadlockedNode()));
        ArrayList<FormulaNode<L, AP>> satisfiedSubFormulas = new ArrayList<FormulaNode<L, AP>>();
        for (FormulaNode<L, AP> n : this.dependencyGraph.getFormulaNodes()) {
            if (!output.get(n.getVarNumber())) continue;
            satisfiedSubFormulas.add(n);
        }
        return satisfiedSubFormulas;
    }

    private BitSet getAllAPDeadlockedNode() {
        return this.getAllAPDeadlockedNode(this.workUnits.get(this.mainProcess).pmpg);
    }

    private <N, E, TP extends ProceduralModalEdgeProperty> BitSet getAllAPDeadlockedNode(ProceduralModalProcessGraph<N, L, E, AP, TP> mainMpg) {
        BitSet satisfiedVariables = new BitSet();
        @NonNull N finalNode = mainMpg.getFinalNode();
        for (int blockIdx = this.dependencyGraph.getBlocks().size() - 1; blockIdx >= 0; --blockIdx) {
            EquationalBlock<L, AP> block = this.dependencyGraph.getBlock(blockIdx);
            for (FormulaNode<L, AP> node : block.getNodes()) {
                NotNode notNode;
                if (node instanceof TrueNode) {
                    satisfiedVariables.set(node.getVarNumber());
                    continue;
                }
                if (node instanceof AtomicNode) {
                    Object atomicProposition = ((AtomicNode)node).getProposition();
                    Set<AP> finalNodeAPs = mainMpg.getAtomicPropositions(finalNode);
                    if (!finalNodeAPs.contains(atomicProposition)) continue;
                    satisfiedVariables.set(node.getVarNumber());
                    continue;
                }
                if (node instanceof BoxNode) {
                    satisfiedVariables.set(node.getVarNumber());
                    continue;
                }
                if (node instanceof AndNode) {
                    AndNode andNode = (AndNode)node;
                    if (!satisfiedVariables.get(andNode.getVarNumberLeft()) || !satisfiedVariables.get(andNode.getVarNumberRight())) continue;
                    satisfiedVariables.set(andNode.getVarNumber());
                    continue;
                }
                if (node instanceof OrNode) {
                    OrNode orNode = (OrNode)node;
                    if (!satisfiedVariables.get(orNode.getVarNumberLeft()) && !satisfiedVariables.get(orNode.getVarNumberRight())) continue;
                    satisfiedVariables.set(orNode.getVarNumber());
                    continue;
                }
                if (!(node instanceof NotNode) || satisfiedVariables.get((notNode = (NotNode)node).getVarNumberChild())) continue;
                satisfiedVariables.set(notNode.getVarNumber());
            }
        }
        return satisfiedVariables;
    }

    private <N> T getTransformer(WorkUnit<N, ?> unit, N node) {
        return (T)((AbstractPropertyTransformer)unit.propTransformers.get(node));
    }

    private <N, E> List<T> createCompositions(WorkUnit<N, E> unit, N node) {
        ProceduralModalProcessGraph pmpg = unit.pmpg;
        ArrayList<T> compositions = new ArrayList<T>();
        for (Object edge : pmpg.getOutgoingEdges(node)) {
            Object targetNode = pmpg.getTarget(edge);
            T edgeTransformer = this.getEdgeTransformer(unit, edge);
            T succTransformer = this.getTransformer(unit, targetNode);
            T composition = ((AbstractPropertyTransformer)edgeTransformer).compose(succTransformer);
            compositions.add(composition);
        }
        return compositions;
    }

    private <N> T getUpdatedPropertyTransformer(WorkUnit<N, ?> unit, N node, T nodeTransformer, List<T> compositions) {
        EquationalBlock<L, AP> currentBlock = this.dependencyGraph.getBlock(this.currentBlockIndex);
        Set atomicPropositions = unit.pmpg.getAtomicPropositions(node);
        return ((AbstractPropertyTransformer)nodeTransformer).createUpdate(atomicPropositions, compositions, currentBlock);
    }

    private <N> void updateTransformerAndWorkSet(WorkUnit<N, ?> unit, N node, T nodeTransformer, T updatedTransformer) {
        if (!nodeTransformer.equals(updatedTransformer)) {
            unit.propTransformers.put(node, updatedTransformer);
            this.updateWorkSet(unit, node);
        }
        if (this.workSetIsEmpty() && this.currentBlockIndex > 0) {
            --this.currentBlockIndex;
            this.resetWorkSet();
        }
    }

    private <E> T getEdgeTransformer(WorkUnit<?, E> unit, E edge) {
        Object edgeTransformer;
        ProceduralModalProcessGraph pmpg = unit.pmpg;
        Object label = pmpg.getEdgeLabel(edge);
        if (this.isProcessEdge(pmpg, edge)) {
            WorkUnit<?, ?> edgeUnit = this.workUnits.get(label);
            assert (edgeUnit != null);
            edgeTransformer = this.getInitialEdgeTransformer(edgeUnit);
        } else if (this.isMustEdge(pmpg, edge)) {
            if (this.mustTransformers.containsKey(label)) {
                edgeTransformer = (AbstractPropertyTransformer)this.mustTransformers.get(label);
            } else {
                edgeTransformer = this.createInitTransformerEdge(this.dependencyGraph, label, (ProceduralModalEdgeProperty)pmpg.getEdgeProperty(edge));
                this.mustTransformers.put(label, edgeTransformer);
            }
        } else if (this.mayTransformers.containsKey(label)) {
            edgeTransformer = (AbstractPropertyTransformer)this.mayTransformers.get(label);
        } else {
            edgeTransformer = this.createInitTransformerEdge(this.dependencyGraph, label, (ProceduralModalEdgeProperty)pmpg.getEdgeProperty(edge));
            this.mayTransformers.put(label, edgeTransformer);
        }
        return edgeTransformer;
    }

    private <E> boolean isMustEdge(ProceduralModalProcessGraph<?, L, E, AP, ?> pmpg, E edge) {
        return ((ProceduralModalEdgeProperty)pmpg.getEdgeProperty(edge)).isMust();
    }

    private <N> void updateWorkSet(WorkUnit<N, ?> unit, N node) {
        if (Objects.equals(unit.pmpg.getInitialNode(), node)) {
            this.updateWorkSetStartNode(unit.label);
        }
        this.addPredecessorsToWorkSet(unit, node);
    }

    private boolean workSetIsEmpty() {
        for (WorkUnit<?, ?> unit : this.workUnits.values()) {
            if (((WorkUnit)unit).workSet.isEmpty()) continue;
            return false;
        }
        return true;
    }

    private void resetWorkSet() {
        for (WorkUnit<?, ?> value : this.workUnits.values()) {
            this.resetWorkSet(value);
        }
    }

    private <N> void resetWorkSet(WorkUnit<N, ?> unit) {
        ((WorkUnit)unit).workSet = this.newWorkSet(unit.pmpg);
    }

    private <E> boolean isProcessEdge(ProceduralModalProcessGraph<?, L, E, AP, ?> pmpg, E edge) {
        return ((ProceduralModalEdgeProperty)pmpg.getEdgeProperty(edge)).isProcess();
    }

    private <N> T getInitialEdgeTransformer(WorkUnit<N, ?> unit) {
        @NonNull N initialNode = unit.pmpg.getInitialNode();
        return (T)((AbstractPropertyTransformer)unit.propTransformers.get(initialNode));
    }

    private void updateWorkSetStartNode(L label) {
        for (WorkUnit<?, ?> unit : this.workUnits.values()) {
            this.updateWorkSetStartNode(unit, label);
        }
    }

    private <N, E> void updateWorkSetStartNode(WorkUnit<N, E> unit, L labelOfUpdatedProcess) {
        ProceduralModalProcessGraph pmpg = unit.pmpg;
        for (Object node : pmpg) {
            for (Object outgoingEdge : pmpg.getOutgoingEdges(node)) {
                if (!Objects.equals(pmpg.getEdgeLabel(outgoingEdge), labelOfUpdatedProcess)) continue;
                this.addToWorkSet(unit, node);
            }
        }
    }

    private <N> void addPredecessorsToWorkSet(WorkUnit<N, ?> unit, N node) {
        Set preds = (Set)((WorkUnit)unit).predecessors.get(node);
        if (preds != null) {
            for (Object pred : preds) {
                this.addToWorkSet(unit, pred);
            }
        }
    }

    private <N> void addToWorkSet(WorkUnit<N, ?> unit, N node) {
        ((WorkUnit)unit).workSet.add(node);
    }

    private <N> Set<N> newWorkSet(ProceduralModalProcessGraph<N, L, ?, AP, ?> pmpg) {
        HashSet workset = new HashSet(pmpg.getNodes());
        workset.remove(pmpg.getFinalNode());
        return workset;
    }

    private FormulaNode<L, AP> ctlToMuCalc(FormulaNode<L, AP> ctlFormula) {
        CTLToMuCalc<L, AP> transformation = new CTLToMuCalc<L, AP>();
        return transformation.toMuCalc(ctlFormula);
    }

    private <N> Mapping<N, List<String>> serializePropertyTransformers(WorkUnit<N, ?> unit) {
        MutableMapping<N, @Nullable V> result = unit.pmpg.createStaticNodeMapping();
        for (Object node : unit.pmpg.getNodes()) {
            result.put(node, this.serializer.serialize((AbstractPropertyTransformer)unit.propTransformers.get(node)));
        }
        return result;
    }

    private void initialize(FormulaNode<L, AP> ast) {
        this.dependencyGraph = new DependencyGraph<L, AP>(ast);
        this.currentBlockIndex = this.dependencyGraph.getBlocks().size() - 1;
        this.initDDManager(this.dependencyGraph);
        this.serializer = this.getSerializer();
        this.mustTransformers = new HashMap<L, T>();
        this.mayTransformers = new HashMap<L, T>();
        for (WorkUnit<?, ?> unit : this.workUnits.values()) {
            this.initialize(unit);
        }
    }

    private <N> void initialize(WorkUnit<N, ?> unit) {
        ((WorkUnit)unit).workSet = this.newWorkSet(unit.pmpg);
        unit.propTransformers = this.initTransformers(unit.pmpg);
    }

    private <N> MutableMapping<N, T> initTransformers(ProceduralModalProcessGraph<N, L, ?, AP, ?> pmpg) {
        MutableMapping<N, @Nullable V> transformers = pmpg.createStaticNodeMapping();
        Object finalNode = pmpg.getFinalNode();
        for (Object n : pmpg) {
            if (Objects.equals(n, finalNode)) {
                transformers.put(n, this.createInitTransformerEndNode(this.dependencyGraph));
                continue;
            }
            transformers.put(n, this.createInitTransformerNode(this.dependencyGraph));
        }
        return transformers;
    }

    private boolean isSat() {
        return this.isSat(this.workUnits.get(this.mainProcess));
    }

    private <N> boolean isSat(WorkUnit<N, ?> unit) {
        @NonNull N initialNode = unit.pmpg.getInitialNode();
        return this.isSat(unit, initialNode);
    }

    private <N> boolean isSat(WorkUnit<N, ?> unit, N initialNode) {
        List<FormulaNode<L, AP>> satisfiedFormulas = this.getSatisfiedSubformulas(unit, initialNode);
        for (FormulaNode<L, AP> node : satisfiedFormulas) {
            if (node.getVarNumber() != 0) continue;
            return true;
        }
        return false;
    }

    protected abstract void initDDManager(DependencyGraph<L, AP> var1);

    protected abstract <TP extends ModalEdgeProperty> T createInitTransformerEdge(DependencyGraph<L, AP> var1, L var2, TP var3);

    protected abstract T createInitTransformerEndNode(DependencyGraph<L, AP> var1);

    protected abstract T createInitTransformerNode(DependencyGraph<L, AP> var1);

    protected abstract void shutdownDDManager();

    protected abstract TransformerSerializer<T, L, AP> getSerializer();

    class WorkUnit<N, E> {
        final L label;
        final ProceduralModalProcessGraph<N, L, E, AP, ?> pmpg;
        private final Mapping<N, @Nullable Set<N>> predecessors;
        MutableMapping<N, T> propTransformers;
        private Set<N> workSet;

        WorkUnit(L label, ProceduralModalProcessGraph<N, @Nullable L, E, AP, ?> pmpg, Mapping<N, Set<N>> predecessors) {
            this.label = label;
            this.pmpg = pmpg;
            this.predecessors = predecessors;
        }
    }
}

