/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.modelchecker.m3c.formula.parser;

import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import net.automatalib.modelchecker.m3c.formula.AndNode;
import net.automatalib.modelchecker.m3c.formula.AtomicNode;
import net.automatalib.modelchecker.m3c.formula.BoxNode;
import net.automatalib.modelchecker.m3c.formula.DiamondNode;
import net.automatalib.modelchecker.m3c.formula.FalseNode;
import net.automatalib.modelchecker.m3c.formula.FormulaNode;
import net.automatalib.modelchecker.m3c.formula.NotNode;
import net.automatalib.modelchecker.m3c.formula.OrNode;
import net.automatalib.modelchecker.m3c.formula.TrueNode;
import net.automatalib.modelchecker.m3c.formula.ctl.AFNode;
import net.automatalib.modelchecker.m3c.formula.ctl.AGNode;
import net.automatalib.modelchecker.m3c.formula.ctl.AUNode;
import net.automatalib.modelchecker.m3c.formula.ctl.AWUNode;
import net.automatalib.modelchecker.m3c.formula.ctl.EFNode;
import net.automatalib.modelchecker.m3c.formula.ctl.EGNode;
import net.automatalib.modelchecker.m3c.formula.ctl.EUNode;
import net.automatalib.modelchecker.m3c.formula.ctl.EWUNode;
import net.automatalib.modelchecker.m3c.formula.modalmu.GfpNode;
import net.automatalib.modelchecker.m3c.formula.modalmu.LfpNode;
import net.automatalib.modelchecker.m3c.formula.modalmu.VariableNode;
import net.automatalib.modelchecker.m3c.formula.parser.InternalM3CParserConstants;
import net.automatalib.modelchecker.m3c.formula.parser.InternalM3CParserTokenManager;
import net.automatalib.modelchecker.m3c.formula.parser.ParseException;
import net.automatalib.modelchecker.m3c.formula.parser.SimpleCharStream;
import net.automatalib.modelchecker.m3c.formula.parser.Token;

class InternalM3CParser<L, AP>
implements InternalM3CParserConstants {
    private Set<String> fixedPointVars;
    private Function<String, L> labelParser;
    private Function<String, AP> apParser;
    public InternalM3CParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private int jj_gen;
    private final int[] jj_la1 = new int[12];
    private static int[] jj_la1_0;
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private boolean trace_enabled;

    private void addFixedPointVar(String fixedPointVar) throws ParseException {
        if (this.fixedPointVars.contains(fixedPointVar)) {
            throw new ParseException("Input formula is not valid. The variable " + fixedPointVar + " is defined multiple times.");
        }
        this.fixedPointVars.add(fixedPointVar);
    }

    public final FormulaNode<L, AP> parse(Function<String, L> labelParser, Function<String, AP> apParser) throws ParseException {
        this.fixedPointVars = new HashSet<String>();
        this.labelParser = labelParser;
        this.apParser = apParser;
        FormulaNode<L, AP> node = this.formula();
        this.jj_consume_token(0);
        return node;
    }

    private final FormulaNode<L, AP> formula() throws ParseException {
        FormulaNode<L, AP> node;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 7: 
            case 8: {
                node = this.untilFormula();
                break;
            }
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 29: 
            case 30: {
                node = this.equivFormula();
                break;
            }
            default: {
                this.jj_la1[0] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return node;
    }

    private final FormulaNode<L, AP> untilFormula() throws ParseException {
        boolean isAll = false;
        boolean isStrongUntil = false;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 7: {
                this.jj_consume_token(7);
                isAll = true;
                break;
            }
            case 8: {
                this.jj_consume_token(8);
                break;
            }
            default: {
                this.jj_la1[1] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.jj_consume_token(17);
        FormulaNode<L, AP> l = this.formula();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 13: {
                this.jj_consume_token(13);
                isStrongUntil = true;
                break;
            }
            case 14: {
                this.jj_consume_token(14);
                break;
            }
            default: {
                this.jj_la1[2] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        FormulaNode<L, AP> r = this.formula();
        this.jj_consume_token(18);
        if (isAll) {
            if (isStrongUntil) {
                return new AUNode<L, AP>(l, r);
            }
            return new AWUNode<L, AP>(l, r);
        }
        if (isStrongUntil) {
            return new EUNode<L, AP>(l, r);
        }
        return new EWUNode<L, AP>(l, r);
    }

    private final FormulaNode<L, AP> equivFormula() throws ParseException {
        FormulaNode<L, AP> r = null;
        FormulaNode<L, AP> l = this.implFormula();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 27: {
                this.jj_consume_token(27);
                r = this.equivFormula();
                break;
            }
            default: {
                this.jj_la1[3] = this.jj_gen;
            }
        }
        if (r == null) {
            return l;
        }
        return new AndNode<L, AP>(new OrNode<L, AP>(new NotNode<L, AP>(l), r), new OrNode<L, AP>(new NotNode<L, AP>(r), l));
    }

    private final FormulaNode<L, AP> implFormula() throws ParseException {
        FormulaNode<L, AP> r = null;
        FormulaNode<L, AP> l = this.orFormula();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 28: {
                this.jj_consume_token(28);
                r = this.implFormula();
                break;
            }
            default: {
                this.jj_la1[4] = this.jj_gen;
            }
        }
        if (r == null) {
            return l;
        }
        return new OrNode<L, AP>(new NotNode<L, AP>(l), r);
    }

    private final FormulaNode<L, AP> orFormula() throws ParseException {
        FormulaNode<L, AP> r = null;
        FormulaNode<L, AP> l = this.andFormula();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 26: {
                this.jj_consume_token(26);
                r = this.orFormula();
                break;
            }
            default: {
                this.jj_la1[5] = this.jj_gen;
            }
        }
        if (r == null) {
            return l;
        }
        return new OrNode<L, AP>(l, r);
    }

    private final FormulaNode<L, AP> andFormula() throws ParseException {
        FormulaNode<L, AP> r = null;
        FormulaNode<L, AP> l = this.unary();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 25: {
                this.jj_consume_token(25);
                r = this.andFormula();
                break;
            }
            default: {
                this.jj_la1[6] = this.jj_gen;
            }
        }
        if (r == null) {
            return l;
        }
        return new AndNode<L, AP>(l, r);
    }

    private final FormulaNode<L, AP> unary() throws ParseException {
        Token action = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 15: 
            case 16: {
                FormulaNode<L, AP> child = this.fixedPointFormula();
                return child;
            }
            case 23: {
                this.jj_consume_token(23);
                FormulaNode<L, AP> child = this.unary();
                return new NotNode<L, AP>(child);
            }
            case 9: {
                this.jj_consume_token(9);
                FormulaNode<L, AP> child = this.unary();
                return new AFNode<L, AP>(child);
            }
            case 10: {
                this.jj_consume_token(10);
                FormulaNode<L, AP> child = this.unary();
                return new AGNode<L, AP>(child);
            }
            case 11: {
                this.jj_consume_token(11);
                FormulaNode<L, AP> child = this.unary();
                return new EFNode<L, AP>(child);
            }
            case 12: {
                this.jj_consume_token(12);
                FormulaNode<L, AP> child = this.unary();
                return new EGNode<L, AP>(child);
            }
            case 21: {
                this.jj_consume_token(21);
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 29: {
                        action = this.jj_consume_token(29);
                        break;
                    }
                    default: {
                        this.jj_la1[7] = this.jj_gen;
                    }
                }
                this.jj_consume_token(22);
                FormulaNode<L, AP> child = this.unary();
                return new DiamondNode<Object, AP>((action == null ? null : (Object)this.labelParser.apply(action.toString())), child);
            }
            case 19: {
                this.jj_consume_token(19);
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 29: {
                        action = this.jj_consume_token(29);
                        break;
                    }
                    default: {
                        this.jj_la1[8] = this.jj_gen;
                    }
                }
                this.jj_consume_token(20);
                FormulaNode<L, AP> child = this.unary();
                return new BoxNode<Object, AP>((action == null ? null : (Object)this.labelParser.apply(action.toString())), child);
            }
            case 5: 
            case 6: 
            case 17: 
            case 29: 
            case 30: {
                FormulaNode<L, AP> child = this.element();
                return child;
            }
        }
        this.jj_la1[9] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    private final FormulaNode<L, AP> fixedPointFormula() throws ParseException {
        boolean isGFP = false;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 15: {
                this.jj_consume_token(15);
                isGFP = true;
                break;
            }
            case 16: {
                this.jj_consume_token(16);
                break;
            }
            default: {
                this.jj_la1[10] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        Token var = this.jj_consume_token(29);
        this.addFixedPointVar(var.toString());
        this.jj_consume_token(24);
        this.jj_consume_token(17);
        FormulaNode<L, AP> child = this.formula();
        this.jj_consume_token(18);
        String fixedPointVar = var.toString();
        this.fixedPointVars.remove(fixedPointVar);
        if (isGFP) {
            return new GfpNode<L, AP>(fixedPointVar, child);
        }
        return new LfpNode<L, AP>(fixedPointVar, child);
    }

    private final FormulaNode<L, AP> element() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 30: {
                Token ap = this.jj_consume_token(30);
                String apString = ap.toString();
                String apWithoutQuotMarks = apString.substring(1, apString.length() - 1);
                return new AtomicNode(this.apParser.apply(apWithoutQuotMarks));
            }
            case 29: {
                Token var = this.jj_consume_token(29);
                String fixedPointVar = var.toString();
                if (!this.fixedPointVars.contains(fixedPointVar)) {
                    throw new ParseException("Referenced variable " + fixedPointVar + " is not in scope.");
                }
                return new VariableNode(fixedPointVar);
            }
            case 5: {
                this.jj_consume_token(5);
                return new TrueNode();
            }
            case 6: {
                this.jj_consume_token(6);
                return new FalseNode();
            }
            case 17: {
                this.jj_consume_token(17);
                FormulaNode<L, AP> node = this.formula();
                this.jj_consume_token(18);
                return node;
            }
        }
        this.jj_la1[11] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{1621860320, 384, 24576, 0x8000000, 0x10000000, 0x4000000, 0x2000000, 0x20000000, 0x20000000, 1621859936, 98304, 0x60020060};
    }

    public InternalM3CParser(InputStream stream) {
        this(stream, null);
    }

    public InternalM3CParser(InputStream stream, String encoding) {
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new InternalM3CParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 12; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 12; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public InternalM3CParser(Reader stream) {
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new InternalM3CParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 12; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(Reader stream) {
        if (this.jj_input_stream == null) {
            this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        } else {
            this.jj_input_stream.ReInit(stream, 1, 1);
        }
        if (this.token_source == null) {
            this.token_source = new InternalM3CParserTokenManager(this.jj_input_stream);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 12; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public InternalM3CParser(InternalM3CParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 12; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(InternalM3CParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 12; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk_f() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[31];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 12; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) == 0) continue;
                la1tokens[j] = true;
            }
        }
        for (i = 0; i < 31; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final boolean trace_enabled() {
        return this.trace_enabled;
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    static {
        InternalM3CParser.jj_la1_init_0();
    }
}

