/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.incremental.moore.dag;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.automatalib.alphabet.Alphabet;
import net.automatalib.alphabet.Alphabets;
import net.automatalib.automaton.concept.InputAlphabetHolder;
import net.automatalib.automaton.concept.StateIDs;
import net.automatalib.automaton.graph.TransitionEdge;
import net.automatalib.automaton.transducer.MooreMachine;
import net.automatalib.automaton.visualization.MooreVisualizationHelper;
import net.automatalib.common.util.UnionFind;
import net.automatalib.graph.Graph;
import net.automatalib.incremental.ConflictException;
import net.automatalib.incremental.moore.IncrementalMooreBuilder;
import net.automatalib.incremental.moore.dag.State;
import net.automatalib.incremental.moore.dag.StateSignature;
import net.automatalib.incremental.moore.dag.Transition;
import net.automatalib.ts.output.MooreTransitionSystem;
import net.automatalib.visualization.VisualizationHelper;
import net.automatalib.word.Word;
import net.automatalib.word.WordBuilder;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class IncrementalMooreDAGBuilder<I, O>
implements IncrementalMooreBuilder<I, O>,
InputAlphabetHolder<I> {
    private final Map<@Nullable StateSignature<O>, State<O>> register = new LinkedHashMap<StateSignature<O>, State<O>>();
    private final Alphabet<I> inputAlphabet;
    private int alphabetSize;
    private @MonotonicNonNull State<O> init;

    public IncrementalMooreDAGBuilder(Alphabet<I> inputAlphabet) {
        this.inputAlphabet = inputAlphabet;
        this.alphabetSize = inputAlphabet.size();
    }

    @Override
    public void addAlphabetSymbol(I symbol) {
        int newAlphabetSize;
        if (!this.inputAlphabet.containsSymbol(symbol)) {
            Alphabets.toGrowingAlphabetOrThrowException(this.inputAlphabet).addSymbol(symbol);
        }
        if (this.alphabetSize < (newAlphabetSize = this.inputAlphabet.size())) {
            this.register.values().forEach(n -> n.ensureInputCapacity(newAlphabetSize));
            this.alphabetSize = newAlphabetSize;
        }
    }

    @Override
    public boolean hasDefinitiveInformation(Word<? extends I> word) {
        return this.getState(word) != null;
    }

    private @Nullable State<O> getState(Word<? extends I> word) {
        I sym;
        int idx;
        State<O> s = this.init;
        if (s == null) {
            return null;
        }
        Iterator<I> iterator = word.iterator();
        while (iterator.hasNext() && (s = s.getSuccessor(idx = this.inputAlphabet.getSymbolIndex(sym = iterator.next()))) != null) {
        }
        return s;
    }

    @Override
    public boolean lookup(Word<? extends I> word, List<? super O> output) {
        State<O> curr = this.init;
        if (curr == null) {
            return false;
        }
        output.add(curr.getOutput());
        for (I sym : word) {
            int idx = this.inputAlphabet.getSymbolIndex(sym);
            State<O> succ = curr.getSuccessor(idx);
            if (succ == null) {
                return false;
            }
            output.add(succ.getOutput());
            curr = succ;
        }
        return true;
    }

    @Override
    public void insert(Word<? extends I> word, Word<? extends O> outputWord) {
        int idx;
        State state;
        Transition next;
        assert (word.size() + 1 == outputWord.size());
        Iterator<O> outWordIterator = outputWord.iterator();
        O rootOut = outWordIterator.next();
        if (this.init == null) {
            StateSignature<O> initSig = new StateSignature<O>(this.alphabetSize, rootOut);
            this.init = new State<O>(initSig);
            this.register.put(null, this.init);
        }
        State<O> curr = this.init;
        State<O> conf = null;
        ArrayDeque<Transition<O>> path = new ArrayDeque<Transition<O>>();
        for (I sym : word) {
            int idx2;
            State<O> succ;
            if (conf == null && curr.isConfluence()) {
                conf = curr;
            }
            if ((succ = curr.getSuccessor(idx2 = this.inputAlphabet.getSymbolIndex(sym))) == null) break;
            O outSym = outWordIterator.next();
            if (!Objects.equals(outSym, succ.getOutput())) {
                throw new ConflictException("Error inserting " + word.prefix(path.size() + 1) + " / " + outputWord.prefix(path.size() + 1) + ": Incompatible output symbols: " + outSym + " vs " + curr.getOutput());
            }
            path.push(new Transition<O>(curr, idx2));
            curr = succ;
        }
        int len = word.length();
        int prefixLen = path.size();
        if (prefixLen == len) {
            return;
        }
        State<Object> last = curr;
        if (conf != null) {
            if (conf == last) {
                conf = null;
            }
            last = this.hiddenClone(last);
            if (conf == null) {
                Transition peek = (Transition)path.peek();
                assert (peek != null);
                State prev = peek.state;
                if (prev != this.init) {
                    this.updateSignature(prev, peek.transIdx, last);
                } else {
                    this.updateInitSignature(peek.transIdx, last);
                }
            }
        } else if (last != this.init) {
            this.hide(last);
        }
        Word<I> suffix = word.subWord(prefixLen);
        Word<O> suffixOut = outputWord.subWord(prefixLen);
        I sym = suffix.firstSymbol();
        int suffTransIdx = this.inputAlphabet.getSymbolIndex(sym);
        O suffTransOut = suffixOut.firstSymbol();
        State<O> suffixState = this.createSuffix(suffix.subWord(1), suffixOut.subWord(1));
        if (last != this.init) {
            last = this.unhide(last, suffTransIdx, suffixState);
            if (suffixState.isConfluence()) {
                Iterator iter = path.descendingIterator();
                while (iter.hasNext()) {
                    State s = ((Transition)iter.next()).state;
                    if (s != conf && s != suffixState) continue;
                    conf = s;
                    break;
                }
            }
        } else {
            this.updateInitSignature(suffTransIdx, suffixState, suffTransOut);
        }
        if (path.isEmpty()) {
            return;
        }
        if (conf != null) {
            do {
                next = (Transition)path.pop();
                state = next.state;
                idx = next.transIdx;
                state = this.clone(state, idx, last);
                last = state;
            } while (next.state != conf);
        }
        while (path.size() > 1) {
            next = (Transition)path.pop();
            state = next.state;
            idx = next.transIdx;
            if (state == last) {
                last = this.clone(state, idx, last);
                continue;
            }
            State updated = this.updateSignature(state, idx, last);
            if (state == updated) {
                return;
            }
            last = updated;
        }
        int finalIdx = ((Transition)path.pop()).transIdx;
        this.updateInitSignature(finalIdx, last);
    }

    private State<O> hiddenClone(State<O> other) {
        StateSignature<O> sig = other.getSignature().duplicate();
        for (int i = 0; i < this.alphabetSize; ++i) {
            State succ = ((State[])sig.successors.array)[i];
            if (succ == null) continue;
            succ.increaseIncoming();
        }
        return new State<O>(sig);
    }

    private State<O> updateSignature(State<O> state, int idx, State<O> succ) {
        StateSignature<O> sig = state.getSignature();
        if (((State[])sig.successors.array)[idx] == succ) {
            return state;
        }
        this.register.remove(sig);
        if (((State[])sig.successors.array)[idx] != null) {
            ((State[])sig.successors.array)[idx].decreaseIncoming();
        }
        ((State[])sig.successors.array)[idx] = succ;
        succ.increaseIncoming();
        sig.updateHashCode();
        return this.replaceOrRegister(state);
    }

    private void updateInitSignature(int idx, State<O> succ) {
        assert (this.init != null);
        StateSignature<O> sig = this.init.getSignature();
        State oldSucc = ((State[])sig.successors.array)[idx];
        if (oldSucc == succ) {
            return;
        }
        if (oldSucc != null) {
            oldSucc.decreaseIncoming();
        }
        ((State[])sig.successors.array)[idx] = succ;
        succ.increaseIncoming();
    }

    private void updateInitSignature(int idx, State<O> succ, O out) {
        assert (this.init != null);
        StateSignature<O> sig = this.init.getSignature();
        State oldSucc = ((State[])sig.successors.array)[idx];
        if (oldSucc == succ && Objects.equals(out, succ.getOutput())) {
            return;
        }
        if (oldSucc != null) {
            oldSucc.decreaseIncoming();
        }
        ((State[])sig.successors.array)[idx] = succ;
        succ.increaseIncoming();
    }

    private void hide(State<O> state) {
        assert (state != this.init);
        StateSignature<O> sig = state.getSignature();
        this.register.remove(sig);
    }

    private State<O> createSuffix(Word<? extends I> suffix, Word<? extends O> suffixOut) {
        StateSignature<O> sig = new StateSignature<O>(this.alphabetSize, suffixOut.lastSymbol());
        sig.updateHashCode();
        State<O> last = this.replaceOrRegister(sig);
        int len = suffix.length();
        for (int i = len - 1; i >= 0; --i) {
            sig = new StateSignature<O>(this.alphabetSize, suffixOut.getSymbol(i));
            I sym = suffix.getSymbol(i);
            int idx = this.inputAlphabet.getSymbolIndex(sym);
            ((State[])sig.successors.array)[idx] = last;
            sig.updateHashCode();
            last = this.replaceOrRegister(sig);
        }
        return last;
    }

    private State<O> unhide(State<O> state, int idx, State<O> succ) {
        StateSignature<O> sig = state.getSignature();
        State prevSucc = ((State[])sig.successors.array)[idx];
        if (prevSucc != null) {
            prevSucc.decreaseIncoming();
        }
        ((State[])sig.successors.array)[idx] = succ;
        if (succ != null) {
            succ.increaseIncoming();
        }
        sig.updateHashCode();
        return this.replaceOrRegister(state);
    }

    private State<O> clone(State<O> other, int idx, State<O> succ) {
        StateSignature<O> sig = other.getSignature();
        if (((State[])sig.successors.array)[idx] == succ) {
            return other;
        }
        sig = sig.duplicate();
        ((State[])sig.successors.array)[idx] = succ;
        sig.updateHashCode();
        return this.replaceOrRegister(sig);
    }

    private State<O> replaceOrRegister(State<O> state) {
        StateSignature<O> sig = state.getSignature();
        State<O> other = this.register.get(sig);
        if (other != null) {
            if (state != other) {
                for (int i = 0; i < ((State[])sig.successors.array).length; ++i) {
                    State succ = ((State[])sig.successors.array)[i];
                    if (succ == null) continue;
                    succ.decreaseIncoming();
                }
            }
            return other;
        }
        this.register.put(sig, state);
        return state;
    }

    private State<O> replaceOrRegister(StateSignature<O> sig) {
        State<O> state = this.register.get(sig);
        if (state != null) {
            return state;
        }
        state = new State<O>(sig);
        this.register.put(sig, state);
        for (int i = 0; i < ((State[])sig.successors.array).length; ++i) {
            State succ = ((State[])sig.successors.array)[i];
            if (succ == null) continue;
            succ.increaseIncoming();
        }
        return state;
    }

    @Override
    public @Nullable Word<I> findSeparatingWord(MooreMachine<?, I, ?, O> target, Collection<? extends I> inputs, boolean omitUndefined) {
        return this.doFindSeparatingWord(target, inputs, omitUndefined);
    }

    private <S, T> @Nullable Word<I> doFindSeparatingWord(MooreMachine<S, I, T, O> moore, Collection<? extends I> inputs, boolean omitUndefined) {
        Record current;
        State<O> init1 = this.init;
        Object init2 = moore.getInitialState();
        if (init1 == null && init2 == null) {
            return null;
        }
        if (init1 == null || init2 == null) {
            return omitUndefined ? null : Word.epsilon();
        }
        if (!Objects.equals(init1.getOutput(), moore.getStateOutput(init2))) {
            return Word.epsilon();
        }
        HashMap<State<O>, Integer> ids = new HashMap<State<O>, Integer>();
        StateIDs<Object> mooreIds = moore.stateIDs();
        int thisStates = this.register.size();
        int id1 = IncrementalMooreDAGBuilder.getStateId(init1, ids);
        int id2 = mooreIds.getStateId(init2) + thisStates;
        UnionFind uf = new UnionFind(thisStates + moore.size());
        uf.link(id1, id2);
        ArrayDeque queue = new ArrayDeque();
        queue.offer(new Record(init1, init2));
        Object lastSym = null;
        block0: while ((current = (Record)queue.poll()) != null) {
            State state1 = current.state1;
            Object state2 = current.state2;
            for (I sym : inputs) {
                int r2;
                Object out2;
                int idx = this.inputAlphabet.getSymbolIndex(sym);
                State succ1 = state1.getSuccessor(idx);
                if (succ1 == null) continue;
                Object succ2 = moore.getSuccessor(state2, sym);
                if (succ2 == null) {
                    if (omitUndefined) continue;
                    lastSym = sym;
                    break block0;
                }
                Object out1 = succ1.getOutput();
                if (!Objects.equals(out1, out2 = moore.getStateOutput(succ2))) {
                    lastSym = sym;
                    break block0;
                }
                id1 = IncrementalMooreDAGBuilder.getStateId(succ1, ids);
                id2 = mooreIds.getStateId(succ2) + thisStates;
                int r1 = uf.find(id1);
                if (r1 == (r2 = uf.find(id2))) continue;
                uf.link(r1, r2);
                queue.offer(new Record(succ1, succ2, current, sym));
            }
        }
        if (current == null) {
            return null;
        }
        int ceLength = current.depth;
        if (lastSym != null) {
            ++ceLength;
        }
        WordBuilder<Object> wb = new WordBuilder<Object>(null, ceLength);
        int index = ceLength;
        if (lastSym != null) {
            wb.setSymbol(--index, lastSym);
        }
        while (current.reachedFrom != null) {
            Object reachedVia = current.reachedVia;
            wb.setSymbol(--index, reachedVia);
            current = current.reachedFrom;
        }
        return wb.toWord();
    }

    private static <O> int getStateId(State<O> state, Map<State<O>, Integer> ids) {
        return ids.computeIfAbsent(state, k -> ids.size());
    }

    @Override
    public Alphabet<I> getInputAlphabet() {
        return this.inputAlphabet;
    }

    @Override
    public MooreTransitionSystem<?, I, ?, O> asTransitionSystem() {
        return new AutomatonView();
    }

    @Override
    public Graph<?, ?> asGraph() {
        return new MooreMachine.MooreGraphView<State<O>, I, State<O>, O, AutomatonView>(new AutomatonView(), this.inputAlphabet){

            @Override
            public VisualizationHelper<State<O>, TransitionEdge<I, State<O>>> getVisualizationHelper() {
                return new MooreVisualizationHelper<State<O>, I, State<O>, O>((MooreMachine)this.automaton){

                    @Override
                    public boolean getNodeProperties(State<O> node, Map<String, String> properties) {
                        super.getNodeProperties(node, properties);
                        properties.put("label", String.valueOf(node.getOutput()));
                        if (node.isConfluence()) {
                            properties.put("shape", "octagon");
                        }
                        return true;
                    }
                };
            }
        };
    }

    private class AutomatonView
    implements MooreMachine<State<O>, I, State<O>, O> {
        private AutomatonView() {
        }

        @Override
        public O getStateOutput(State<O> state) {
            return state.getOutput();
        }

        @Override
        public @Nullable State<O> getTransition(State<O> state, I input) {
            return state.getSuccessor(IncrementalMooreDAGBuilder.this.inputAlphabet.getSymbolIndex(input));
        }

        @Override
        public State<O> getSuccessor(State<O> transition) {
            return transition;
        }

        @Override
        public @Nullable State<O> getInitialState() {
            return IncrementalMooreDAGBuilder.this.init;
        }

        @Override
        public Collection<State<O>> getStates() {
            return Collections.unmodifiableCollection(IncrementalMooreDAGBuilder.this.register.values());
        }
    }

    private static final class Record<S, I, O> {
        private final State<O> state1;
        private final S state2;
        private final I reachedVia;
        private final @Nullable Record<S, I, O> reachedFrom;
        private final int depth;

        Record(State<O> state1, S state2) {
            this.state1 = state1;
            this.state2 = state2;
            this.reachedFrom = null;
            this.reachedVia = null;
            this.depth = 0;
        }

        Record(State<O> state1, S state2, Record<S, I, O> reachedFrom, I reachedVia) {
            this.state1 = state1;
            this.state2 = state2;
            this.reachedFrom = reachedFrom;
            this.reachedVia = reachedVia;
            this.depth = reachedFrom.depth + 1;
        }
    }
}

