/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.incremental.dfa.tree;

import com.google.common.collect.Iterators;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import net.automatalib.alphabet.Alphabet;
import net.automatalib.automaton.UniversalAutomaton;
import net.automatalib.automaton.fsa.DFA;
import net.automatalib.automaton.graph.TransitionEdge;
import net.automatalib.automaton.graph.UniversalAutomatonGraphView;
import net.automatalib.common.util.mapping.MapMapping;
import net.automatalib.common.util.mapping.MutableMapping;
import net.automatalib.graph.Graph;
import net.automatalib.incremental.ConflictException;
import net.automatalib.incremental.dfa.AbstractIncrementalDFABuilder;
import net.automatalib.incremental.dfa.AbstractVisualizationHelper;
import net.automatalib.incremental.dfa.Acceptance;
import net.automatalib.incremental.dfa.tree.Node;
import net.automatalib.ts.UniversalDTS;
import net.automatalib.util.ts.traversal.TSTraversal;
import net.automatalib.visualization.VisualizationHelper;
import net.automatalib.word.Word;
import net.automatalib.word.WordBuilder;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class IncrementalDFATreeBuilder<I>
extends AbstractIncrementalDFABuilder<I> {
    final Node root = new Node();

    public IncrementalDFATreeBuilder(Alphabet<I> inputAlphabet) {
        super(inputAlphabet);
    }

    @Override
    public void addAlphabetSymbol(I symbol) {
        int oldSize = this.alphabetSize;
        super.addAlphabetSymbol(symbol);
        int newSize = this.alphabetSize;
        if (oldSize < newSize) {
            this.ensureInputCapacity(this.root, oldSize, newSize);
        }
    }

    private void ensureInputCapacity(Node node, int oldAlphabetSize, int newAlphabetSize) {
        node.ensureInputCapacity(newAlphabetSize);
        for (int i = 0; i < oldAlphabetSize; ++i) {
            Node child = node.getChild(i);
            if (child == null) continue;
            this.ensureInputCapacity(child, oldAlphabetSize, newAlphabetSize);
        }
    }

    @Override
    public @Nullable Word<I> findSeparatingWord(DFA<?, I> target, Collection<? extends I> inputs, boolean omitUndefined) {
        return this.doFindSeparatingWord(target, inputs, omitUndefined);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    <S> @Nullable Word<I> doFindSeparatingWord(DFA<S, I> target, Collection<? extends I> inputs, boolean omitUndefined) {
        Object automatonInit = target.getInitialState();
        if (automatonInit == null) {
            return omitUndefined ? null : Word.epsilon();
        }
        if (this.root.getAcceptance().conflicts(target.isAccepting(automatonInit))) {
            return Word.epsilon();
        }
        Record<@Nullable S, ? extends I> init = new Record(automatonInit, this.root, null, inputs.iterator());
        ArrayDeque<Record<@Nullable Object, ? extends I>> dfsStack = new ArrayDeque<Record<Object, ? extends I>>();
        dfsStack.push(init);
        while (!dfsStack.isEmpty()) {
            boolean succAcc;
            Object automatonSucc;
            @Nullable @NonNull Record rec = (Record)dfsStack.peek();
            if (!rec.inputIt.hasNext()) {
                dfsStack.pop();
                continue;
            }
            Object input = rec.inputIt.next();
            int inputIdx = this.inputAlphabet.getSymbolIndex(input);
            Node succ = rec.treeNode.getChild(inputIdx);
            if (succ == null) continue;
            @Nullable S state = rec.automatonState;
            Object s = automatonSucc = state == null ? null : (Object)target.getTransition(state, input);
            if (automatonSucc == null && omitUndefined) continue;
            boolean bl = succAcc = automatonSucc != null && target.isAccepting(automatonSucc);
            if (succ.getAcceptance().conflicts(succAcc)) {
                WordBuilder wb = new WordBuilder(dfsStack.size());
                wb.append(input);
                dfsStack.pop();
                while (!dfsStack.isEmpty()) {
                    wb.append(rec.incomingInput);
                    rec = (Record)dfsStack.pop();
                }
                return wb.reverse().toWord();
            }
            dfsStack.push(new Record<Object, I>(automatonSucc, succ, input, inputs.iterator()));
        }
        return null;
    }

    @Override
    public Acceptance lookup(Word<? extends I> inputWord) {
        Node curr = this.root;
        for (I sym : inputWord) {
            int symIdx = this.inputAlphabet.getSymbolIndex(sym);
            Node succ = curr.getChild(symIdx);
            if (succ == null) {
                return Acceptance.DONT_KNOW;
            }
            curr = succ;
        }
        return curr.getAcceptance();
    }

    @Override
    public void insert(Word<? extends I> word, boolean acceptance) {
        Node curr = this.root;
        for (I sym : word) {
            int inputIdx = this.inputAlphabet.getSymbolIndex(sym);
            Node succ = curr.getChild(inputIdx);
            if (succ == null) {
                succ = new Node();
                curr.setChild(inputIdx, this.alphabetSize, succ);
            }
            curr = succ;
        }
        Acceptance acc = curr.getAcceptance();
        Acceptance newWordAcc = Acceptance.fromBoolean(acceptance);
        if (acc == Acceptance.DONT_KNOW) {
            curr.setAcceptance(newWordAcc);
        } else if (acc != newWordAcc) {
            throw new ConflictException("Conflicting acceptance values for word " + word + ": " + (Object)((Object)acc) + " vs " + (Object)((Object)newWordAcc));
        }
    }

    @Override
    public UniversalDTS<?, I, ?, Acceptance, Void> asTransitionSystem() {
        return new TransitionSystemView();
    }

    @Override
    public Graph<?, ?> asGraph() {
        return new UniversalAutomatonGraphView<Node, I, Node, Acceptance, Void, TransitionSystemView>(new TransitionSystemView(), this.inputAlphabet){

            @Override
            public VisualizationHelper<Node, TransitionEdge<I, Node>> getVisualizationHelper() {
                return new AbstractVisualizationHelper<Node, I, Node, TransitionSystemView>((TransitionSystemView)this.automaton){

                    @Override
                    public Acceptance getAcceptance(Node node) {
                        return node.getAcceptance();
                    }
                };
            }
        };
    }

    class TransitionSystemView
    implements UniversalDTS<Node, I, Node, Acceptance, Void>,
    UniversalAutomaton<Node, I, Node, Acceptance, Void> {
        TransitionSystemView() {
        }

        @Override
        public Node getSuccessor(Node transition) {
            return transition;
        }

        @Override
        public @Nullable Node getTransition(Node state, I input) {
            int inputIdx = IncrementalDFATreeBuilder.this.inputAlphabet.getSymbolIndex(input);
            return state.getChild(inputIdx);
        }

        @Override
        public Node getInitialState() {
            return IncrementalDFATreeBuilder.this.root;
        }

        @Override
        public Acceptance getStateProperty(Node state) {
            return state.getAcceptance();
        }

        @Override
        public Void getTransitionProperty(Node transition) {
            return null;
        }

        @Override
        public Collection<Node> getStates() {
            ArrayList<Node> result = new ArrayList<Node>();
            Iterators.addAll(result, TSTraversal.breadthFirstIterator(this, IncrementalDFATreeBuilder.this.inputAlphabet));
            return result;
        }

        @Override
        public <V> MutableMapping<Node, V> createStaticStateMapping() {
            return new MapMapping();
        }
    }

    static final class Record<S, I> {
        public final S automatonState;
        public final Node treeNode;
        public final I incomingInput;
        public final Iterator<? extends I> inputIt;

        Record(S automatonState, Node treeNode, I incomingInput, Iterator<? extends I> inputIt) {
            this.automatonState = automatonState;
            this.treeNode = treeNode;
            this.incomingInput = incomingInput;
            this.inputIt = inputIt;
        }
    }
}

