/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.graph.visualization;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.automatalib.common.util.Pair;
import net.automatalib.graph.ProceduralModalProcessGraph;
import net.automatalib.graph.visualization.PMPGVisualizationHelper;
import net.automatalib.visualization.DefaultVisualizationHelper;
import org.checkerframework.checker.nullness.qual.NonNull;

public class CFMPSVisualizationHelper<N, L, E>
extends DefaultVisualizationHelper<Pair<L, N>, Pair<L, E>> {
    private final Map<L, PMPGVisualizationHelper<N, E, ?>> visualizers;
    private final List<Pair<L, N>> initialNodes;

    public CFMPSVisualizationHelper(Map<L, ? extends ProceduralModalProcessGraph<? extends N, L, ? extends E, ?, ?>> pmpgs) {
        this.visualizers = Maps.newHashMapWithExpectedSize((int)pmpgs.size());
        this.initialNodes = new ArrayList<Pair<L, N>>(pmpgs.size());
        for (Map.Entry<L, ProceduralModalProcessGraph<N, L, E, ?, ?>> e : pmpgs.entrySet()) {
            ProceduralModalProcessGraph<N, L, E, ?, ?> value = e.getValue();
            Object initialNode = value.getInitialNode();
            this.visualizers.put(e.getKey(), new PMPGVisualizationHelper(value));
            if (initialNode == null) continue;
            this.initialNodes.add(Pair.of(e.getKey(), initialNode));
        }
    }

    @Override
    protected Collection<Pair<L, N>> initialNodes() {
        return this.initialNodes;
    }

    @Override
    public boolean getNodeProperties(Pair<L, N> node, Map<String, String> properties) {
        L process = node.getFirst();
        @NonNull PMPGVisualizationHelper<N, E, ?> visualizer = this.visualizers.get(process);
        return visualizer.getNodeProperties(node.getSecond(), properties);
    }

    @Override
    public boolean getEdgeProperties(Pair<L, N> src, Pair<L, E> edge, Pair<L, N> tgt, Map<String, String> properties) {
        L process = edge.getFirst();
        @NonNull PMPGVisualizationHelper<N, E, ?> visualizer = this.visualizers.get(process);
        return visualizer.getEdgeProperties(src.getSecond(), edge.getSecond(), tgt.getSecond(), properties);
    }
}

