/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.graph;

import com.google.common.collect.Collections2;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Iterator;
import net.automatalib.graph.IndefiniteGraph;
import net.automatalib.graph.SimpleGraph;
import net.automatalib.visualization.DefaultVisualizationHelper;
import net.automatalib.visualization.VisualizationHelper;

public interface Graph<N, E>
extends IndefiniteGraph<N, E>,
SimpleGraph<N> {
    public Collection<E> getOutgoingEdges(N var1);

    default public Collection<N> getAdjacentNodes(N node) {
        return Collections2.transform(this.getOutgoingEdges(node), this::getTarget);
    }

    @Override
    default public Iterator<E> getOutgoingEdgesIterator(N node) {
        return this.getOutgoingEdges(node).iterator();
    }

    @Override
    default public VisualizationHelper<N, E> getVisualizationHelper() {
        return new DefaultVisualizationHelper();
    }

    public static interface IntAbstraction<E>
    extends SimpleGraph.IntAbstraction {
        public Collection<E> getOutgoingEdges(int var1);

        public int getIntTarget(E var1);

        default public Iterator<E> getOutgoingEdgesIterator(int node) {
            return this.getOutgoingEdges(node).iterator();
        }

        default public Collection<E> getEdgesBetween(int from, int to) {
            return Lists.newArrayList((Iterator)Iterators.filter(this.getOutgoingEdgesIterator(from), e -> this.getIntTarget(e) == to));
        }

        @Override
        default public boolean isConnected(int source, int target) {
            return Iterators.any(this.getOutgoingEdgesIterator(source), e -> this.getIntTarget(e) == target);
        }
    }
}

