/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.graph;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.Map;
import net.automatalib.graph.ContextFreeModalProcessSystem;
import net.automatalib.graph.ProceduralModalProcessGraph;
import org.checkerframework.checker.nullness.qual.Nullable;

public class DefaultCFMPS<L, AP>
implements ContextFreeModalProcessSystem<L, AP> {
    private final Map<L, ProceduralModalProcessGraph<?, L, ?, AP, ?>> pmpgs;
    private final L mainProcess;

    public DefaultCFMPS(L mainProcess, Map<L, ? extends ProceduralModalProcessGraph<?, L, ?, AP, ?>> pmpgs) {
        Preconditions.checkArgument((boolean)pmpgs.containsKey(mainProcess), (Object)"There exists no process graph for the main process");
        this.pmpgs = Collections.unmodifiableMap(pmpgs);
        this.mainProcess = mainProcess;
    }

    @Override
    public Map<L, ProceduralModalProcessGraph<?, L, ?, AP, ?>> getPMPGs() {
        return this.pmpgs;
    }

    @Override
    public @Nullable L getMainProcess() {
        return this.mainProcess;
    }
}

